/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.commons.dbutils.DbUtils;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.QueryProgress;
import org.gcube.data.analysis.tabulardata.operation.QueryThread;
import org.gcube.data.analysis.tabulardata.operation.StatementContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SQLHelper {
    private static final Logger log = LoggerFactory.getLogger(SQLHelper.class);

    public static void executeSQLCommand(String sqlCommand, DatabaseConnectionProvider connectionProvider) throws SQLException {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = connectionProvider.getConnection();
            stmt = conn.createStatement();
            StatementContainer.set(stmt);
            log.debug("Executing SQL command: " + sqlCommand);
            stmt.execute(sqlCommand);
        }
        catch (SQLException e) {
            try {
                String msg = "Unable to execute SQL command: " + sqlCommand;
                log.error(msg, (Throwable)e);
                SQLException next = e.getNextException();
                if (next != null) {
                    throw next;
                }
                throw e;
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(stmt);
                StatementContainer.reset();
                DbUtils.closeQuietly((Connection)conn);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((Statement)stmt);
        StatementContainer.reset();
        DbUtils.closeQuietly((Connection)conn);
    }

    public static QueryProgress SQLInsertCommandWithProgress(Table table, String insertCommand, int extimatedAffectedRows, DatabaseConnectionProvider connectionProvider) throws SQLException {
        QueryThread thread = new QueryThread(connectionProvider, insertCommand);
        QueryProgress progress = new QueryProgress(connectionProvider, table, extimatedAffectedRows, thread);
        new Thread(thread).start();
        return progress;
    }

    public static int[] executeSQLBatchCommands(DatabaseConnectionProvider connectionProvider, String ... sqlCommands) throws SQLException {
        int[] i2;
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = connectionProvider.getConnection();
            stmt = conn.createStatement();
            StatementContainer.set(stmt);
            for (int i2 = 0; i2 < sqlCommands.length; ++i2) {
                log.debug("Adding to batch: " + sqlCommands[i2]);
                stmt.addBatch(sqlCommands[i2]);
            }
            i2 = stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                String msg = "Unable to execute batch sql command";
                log.error(msg, (Throwable)e);
                SQLException next = e.getNextException();
                if (next != null) {
                    throw next;
                }
                throw e;
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(stmt);
                StatementContainer.reset();
                DbUtils.closeQuietly((Connection)conn);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((Statement)stmt);
        StatementContainer.reset();
        DbUtils.closeQuietly((Connection)conn);
        return i2;
    }

    public static String generateColumnNameSnippet(List<Column> columnsToCopy) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Column column : columnsToCopy) {
            stringBuilder.append(" " + column.getName());
            if (columnsToCopy.indexOf(column) == columnsToCopy.size() - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public static void iteratePreparedStatementOverColumnValues(Column toCheckColumn, String sqlCommand, DatabaseConnectionProvider connectionProvider, List<Object> values) throws SQLException, Exception {
        if (!toCheckColumn.getColumnType().equals((Object)new IdColumnType()) && !toCheckColumn.getColumnType().equals((Object)new ValidationColumnType())) {
            throw new Exception("Invalid column type " + toCheckColumn.getColumnType());
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = connectionProvider.getConnection();
            stmt = conn.prepareStatement(sqlCommand);
            StatementContainer.set(stmt);
            for (Object value : values) {
                if (toCheckColumn.getColumnType().equals((Object)new IdColumnType())) {
                    stmt.setInt(1, (Integer)value);
                } else {
                    stmt.setBoolean(1, (Boolean)value);
                }
                stmt.execute();
            }
        }
        catch (SQLException e) {
            try {
                String msg = "Unable to execute batch sql command";
                log.error(msg, (Throwable)e);
                SQLException next = e.getNextException();
                if (next != null) {
                    throw next;
                }
                throw e;
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(stmt);
                StatementContainer.reset();
                DbUtils.closeQuietly((Connection)conn);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((Statement)stmt);
        StatementContainer.reset();
        DbUtils.closeQuietly((Connection)conn);
    }

    public static int getSpecificCount(DatabaseConnectionProvider connectionProvider, String tableName, String countArgument, String condition) throws SQLException {
        int n;
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = connectionProvider.getConnection();
            stmt = conn.createStatement();
            StatementContainer.set(stmt);
            if (condition == null) {
                condition = "true";
            }
            ResultSet rs = stmt.executeQuery("SELECT count(" + countArgument + ") FROM " + tableName + " WHERE " + condition);
            rs.next();
            n = rs.getInt(1);
        }
        catch (SQLException e) {
            try {
                String msg = "Unable to execute batch sql command";
                log.error(msg, (Throwable)e);
                SQLException next = e.getNextException();
                if (next != null) {
                    throw next;
                }
                throw e;
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(stmt);
                StatementContainer.reset();
                DbUtils.closeQuietly((Connection)conn);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((Statement)stmt);
        StatementContainer.reset();
        DbUtils.closeQuietly((Connection)conn);
        return n;
    }

    public static int getCount(DatabaseConnectionProvider connectionProvider, String tableName, String condition) throws SQLException {
        return SQLHelper.getSpecificCount(connectionProvider, tableName, "*", condition);
    }

    public static int getCountEstimation(DatabaseConnectionProvider connectionProvider, String query) throws SQLException {
        int n;
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = connectionProvider.getConnection();
            stmt = conn.createStatement();
            StatementContainer.set(stmt);
            ResultSet rs = stmt.executeQuery("SELECT count_estimate('" + query.replace("'", "''") + "')");
            rs.next();
            n = rs.getInt(1);
        }
        catch (SQLException e) {
            try {
                String msg = "Unable to execute batch sql command";
                log.error(msg, (Throwable)e);
                SQLException next = e.getNextException();
                if (next != null) {
                    throw next;
                }
                throw e;
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(stmt);
                StatementContainer.reset();
                DbUtils.closeQuietly((Connection)conn);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((Statement)stmt);
        StatementContainer.reset();
        DbUtils.closeQuietly((Connection)conn);
        return n;
    }

    public static Object sampleColumn(DatabaseConnectionProvider connectionProvider, Table table, Column col) throws SQLException {
        Object object;
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = connectionProvider.getConnection();
            stmt = conn.createStatement();
            StatementContainer.set(stmt);
            ResultSet rs = stmt.executeQuery(String.format("SELECT %1$s from %2$s ORDER BY %1$s LIMIT 1 OFFSET 0 ", col.getName(), table.getName()));
            rs.next();
            object = rs.getObject(1);
        }
        catch (SQLException e) {
            try {
                String msg = "Unable to execute batch sql command";
                log.error(msg, (Throwable)e);
                SQLException next = e.getNextException();
                if (next != null) {
                    throw next;
                }
                throw e;
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(stmt);
                StatementContainer.reset();
                DbUtils.closeQuietly((Connection)conn);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((Statement)stmt);
        StatementContainer.reset();
        DbUtils.closeQuietly((Connection)conn);
        return object;
    }
}

