/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.remove;

import java.util.HashMap;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.Equals;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDBoolean;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.data.remove.FilterByExpressionFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateDataWithExpression;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateDataWithExpressionFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerWrapper;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationAbortedException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ValidationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ValidityResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterByExpression
extends DataWorker {
    private static final Logger log = LoggerFactory.getLogger(ValidateDataWithExpression.class);
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private SQLExpressionEvaluatorFactory sqlEvaluatorFactory;
    private ValidateDataWithExpressionFactory validateDataWithExpressionFactory;
    private Table targetTable;
    private Table evaluatedTable;
    private Table filteredTable;
    private Table diffTable;
    private Column validationColumn;
    private Expression filterCondition;
    private Expression deleteCondition;

    public FilterByExpression(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory sqlEvaluatorFactory, ValidateDataWithExpressionFactory validateDataWithExpressionFactory) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.sqlEvaluatorFactory = sqlEvaluatorFactory;
        this.validateDataWithExpressionFactory = validateDataWithExpressionFactory;
    }

    protected WorkerResult execute() throws WorkerException, OperationAbortedException {
        this.retrieveParameters();
        this.updateProgress(0.1f, "Validating to remove rows");
        this.checkAborted();
        this.executeValidation();
        this.checkAborted();
        this.updateProgress(0.3f, "Gathering to remove rows");
        this.filteredTable = this.cubeManager.createTable(this.evaluatedTable.getTableType()).like(this.evaluatedTable, true).create();
        this.diffTable = this.cubeManager.createTable(this.evaluatedTable.getTableType()).like(this.evaluatedTable, false, this.evaluatedTable.getColumnsByType(new Class[]{ValidationColumnType.class})).create();
        this.updateProgress(0.5f, "Filtering rows");
        this.checkAborted();
        this.filterValidatedTable();
        this.updateProgress(0.9f, "Finalizing");
        this.cubeManager.removeValidations(this.targetTable.getId());
        return new ImmutableWorkerResult(this.cubeManager.removeValidations(this.filteredTable.getId()), this.diffTable);
    }

    private void retrieveParameters() {
        this.filterCondition = (Expression)this.getSourceInvocation().getParameterInstances().get(FilterByExpressionFactory.EXPRESSION_PARAMETER.getIdentifier());
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
    }

    private void executeValidation() throws WorkerException, OperationAbortedException {
        WorkerWrapper wrapper = this.createWorkerWrapper((WorkerFactory)this.validateDataWithExpressionFactory);
        HashMap<String, Expression> map = new HashMap<String, Expression>();
        map.put(ValidateDataWithExpressionFactory.EXPRESSION_PARAMETER.getIdentifier(), this.filterCondition);
        try {
            WorkerStatus status = wrapper.execute(this.targetTable.getId(), null, map);
            if (!status.equals((Object)WorkerStatus.SUCCEDED)) {
                throw new WorkerException("Wrapped step has failed, see previous log");
            }
            this.evaluatedTable = this.cubeManager.getTable(this.targetTable.getId());
            this.validationColumn = this.evaluatedTable.getColumnById(((ValidationDescriptor)((ValidityResult)wrapper.getResult()).getValidationDescriptors().get(0)).getValidationColumn());
            log.debug("Evaluated table : " + this.evaluatedTable);
        }
        catch (InvalidInvocationException e) {
            throw new WorkerException("Unable to check condition", (Throwable)e);
        }
    }

    private void filterValidatedTable() throws WorkerException {
        log.debug("Creating condition on validation column for table " + this.filteredTable);
        this.deleteCondition = new Equals((Expression)this.filteredTable.getColumnReference(this.validationColumn), (Expression)new TDBoolean(false));
        this.executeFilter(this.deleteCondition);
    }

    private void executeFilter(Expression deleteCondition) throws WorkerException {
        try {
            StringBuilder columnsString = new StringBuilder("id ");
            for (Column column : this.filteredTable.getColumnsExceptTypes(new Class[]{ValidationColumnType.class, IdColumnType.class})) {
                columnsString.append(",").append(column.getName());
            }
            String sqlCommand = String.format("WITH deleted AS (DELETE FROM %1$s WHERE %2$s RETURNING %3$s ) INSERT INTO  %4$s (%3$s) SELECT %3$s FROM deleted ", this.filteredTable.getName(), this.sqlEvaluatorFactory.getEvaluator(deleteCondition).evaluate(), columnsString.toString(), this.diffTable.getName());
            SQLHelper.executeSQLBatchCommands((DatabaseConnectionProvider)this.connectionProvider, (String[])new String[]{sqlCommand});
        }
        catch (Exception e) {
            throw new WorkerException("Error occurred while executing SQL command", (Throwable)e);
        }
    }
}

