/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.statistical.specific;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.csv4j.ParseException;
import net.sf.csv4j.ProcessingException;
import org.gcube.data.analysis.dataminermanagercl.server.dmservice.SClient;
import org.gcube.data.analysis.dataminermanagercl.shared.parameters.Parameter;
import org.gcube.data.analysis.dataminermanagercl.shared.process.Operator;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.Equals;
import org.gcube.data.analysis.tabulardata.expression.functions.Cast;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDNumeric;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.resources.ResourceType;
import org.gcube.data.analysis.tabulardata.model.resources.TableResource;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.data.add.AddColumnFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerWrapper;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationAbortedException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ResourcesResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ResourceDescriptorResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;
import org.gcube.data.analysis.tabulardata.statistical.Common;
import org.gcube.data.analysis.tabulardata.statistical.ExportToStatisticalOperationFactory;
import org.gcube.data.analysis.tabulardata.statistical.StatisticalOperationFactory;
import org.gcube.data.analysis.tabulardata.statistical.specific.EnhanceLatLonFactory;
import org.gcube.data.analysis.tabulardata.statistical.specific.LatLongFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhanceLatLong
extends DataWorker {
    public static final Logger log = LoggerFactory.getLogger(EnhanceLatLong.class);
    private StatisticalOperationFactory statisticalFactory;
    private AddColumnFactory addColumnFactory;
    private CubeManager cubeManager;
    private Table targetTable;
    private Column latColumn;
    private Column longColumn;
    private Double precision;
    private LatLongFeature feature;
    private Column quadrant;
    private boolean deleteRemote = false;
    private boolean deleteGenerated = false;
    private Map<String, Object> wrapperParameters = new HashMap<String, Object>();
    private Table generatedTable;
    private Table resultTable;
    private String exportedIdColumnLabel;
    private ColumnType importedColumnType;
    private Table enhancedTable;
    private String toEscapeColumnName = null;

    public EnhanceLatLong(OperationInvocation sourceInvocation, StatisticalOperationFactory statisticalFactory, AddColumnFactory addColumnFactory, CubeManager cubeManager) {
        super(sourceInvocation);
        this.statisticalFactory = statisticalFactory;
        this.addColumnFactory = addColumnFactory;
        this.cubeManager = cubeManager;
    }

    protected WorkerResult execute() throws WorkerException, OperationAbortedException {
        try {
            this.updateProgress(0.1f, "Initializing");
            this.init();
            this.updateProgress(0.2f, "Preparing data");
            this.prepareData();
            this.checkAborted();
            this.prepareSMParameters();
            this.updateProgress(0.3f, "Executing staistical algorithm");
            this.checkAborted();
            this.submitExecution();
            this.updateProgress(0.8f, "Merging result..");
            this.checkAborted();
            this.addColumn();
            return new ImmutableWorkerResult(this.resultTable);
        }
        catch (WorkerException e) {
            throw e;
        }
        catch (OperationAbortedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WorkerException("Unexpected internal error. Please contact support", (Throwable)e);
        }
    }

    private void init() {
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        this.importedColumnType = this.targetTable.getTableType().getAllowedColumnTypes().contains(new AnnotationColumnType()) ? new AnnotationColumnType() : new AttributeColumnType();
        this.latColumn = this.targetTable.getColumnById(((ColumnReference)OperationHelper.getParameter((LeafParameter)EnhanceLatLonFactory.LATITUDE_COLUMN_PARAM, (OperationInvocation)this.getSourceInvocation())).getColumnId());
        this.longColumn = this.targetTable.getColumnById(((ColumnReference)OperationHelper.getParameter((LeafParameter)EnhanceLatLonFactory.LONGITUTE_COLUMN_PARAM, (OperationInvocation)this.getSourceInvocation())).getColumnId());
        try {
            this.precision = ((TDNumeric)OperationHelper.getParameter((LeafParameter)EnhanceLatLonFactory.RESOLUTION_PARAM, (OperationInvocation)this.getSourceInvocation())).getValue();
        }
        catch (Throwable t) {
            this.precision = null;
        }
        try {
            this.quadrant = this.targetTable.getColumnById(((ColumnReference)OperationHelper.getParameter((LeafParameter)EnhanceLatLonFactory.QUADRANT_COLUMN_PARAMETER, (OperationInvocation)this.getSourceInvocation())).getColumnId());
        }
        catch (Throwable t) {
            this.quadrant = null;
        }
        this.feature = LatLongFeature.valueOf((String)OperationHelper.getParameter((LeafParameter)EnhanceLatLonFactory.TO_ADD_FEATURE_PARAM, (OperationInvocation)this.getSourceInvocation()));
        try {
            this.deleteRemote = (Boolean)OperationHelper.getParameter((LeafParameter)EnhanceLatLonFactory.DELETE_REMOTE, (OperationInvocation)this.getSourceInvocation());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.deleteGenerated = (Boolean)OperationHelper.getParameter((LeafParameter)EnhanceLatLonFactory.DELETE_GENERATED, (OperationInvocation)this.getSourceInvocation());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        switch (this.feature) {
            case CSQUARECODE: {
                this.toEscapeColumnName = "csquare_code";
                break;
            }
            case OCEANAREA: {
                this.toEscapeColumnName = "fao_ocean_area";
            }
        }
    }

    private void prepareData() throws OperationAbortedException, WorkerException, ParseException, IOException, ProcessingException {
        Column idColumn = (Column)this.targetTable.getColumnsByType(new Class[]{IdColumnType.class}).get(0);
        this.exportedIdColumnLabel = Common.fixColumnName(idColumn.getLocalId().getValue());
        HashMap<String, Object> addColumnParameters = new HashMap<String, Object>();
        addColumnParameters.put(AddColumnFactory.COLUMN_TYPE.getIdentifier(), this.importedColumnType);
        addColumnParameters.put(AddColumnFactory.DATA_TYPE.getIdentifier(), idColumn.getDataType());
        addColumnParameters.put(AddColumnFactory.LABEL.getIdentifier(), new ImmutableLocalizedText(idColumn.getLocalId().getValue()));
        addColumnParameters.put(AddColumnFactory.VALUE_PARAMETER.getIdentifier(), this.targetTable.getColumnReference(idColumn));
        WorkerWrapper wrapper = this.createWorkerWrapper((WorkerFactory)this.addColumnFactory);
        try {
            WorkerStatus status = wrapper.execute(this.targetTable.getId(), null, addColumnParameters);
            if (!status.equals((Object)WorkerStatus.SUCCEDED)) {
                throw new WorkerException("Failed to prepare data : " + status);
            }
            this.enhancedTable = ((WorkerResult)wrapper.getResult()).getResultTable();
        }
        catch (InvalidInvocationException e) {
            throw new WorkerException("Unable to prepare data", (Throwable)e);
        }
    }

    private void prepareSMParameters() throws WorkerException {
        try {
            this.wrapperParameters.put(StatisticalOperationFactory.CLEAR_DATASPACE.getIdentifier(), this.deleteGenerated);
            this.wrapperParameters.put(StatisticalOperationFactory.REMOVE_EXPORTED.getIdentifier(), this.deleteRemote);
            SClient dmClient = Common.getDMClient();
            Operator op = null;
            switch (this.feature) {
                case CSQUARECODE: {
                    this.wrapperParameters.put(ExportToStatisticalOperationFactory.toEscapeFieldNamesParam.getIdentifier(), "csquare_code");
                    op = dmClient.getOperatorById("org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers.CSQUARE_COLUMN_CREATOR");
                    for (Parameter param : dmClient.getInputParameters(op)) {
                        switch (param.getName()) {
                            case "InputTable": {
                                param.setValue(this.enhancedTable.getId().getValue() + "");
                                break;
                            }
                            case "Longitude_Column": {
                                param.setValue(this.longColumn.getLocalId().getValue());
                                break;
                            }
                            case "Latitude_Column": {
                                param.setValue(this.latColumn.getLocalId().getValue());
                                break;
                            }
                            case "CSquare_Resolution": {
                                param.setValue((this.precision != null ? this.precision : (double)new Float(0.1).floatValue()) + "");
                                break;
                            }
                            case "OutputTableName": {
                                param.setValue("csquare_");
                            }
                        }
                        op.addOperatorParameter(param);
                    }
                    break;
                }
                case OCEANAREA: {
                    op = dmClient.getOperatorById("org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers.FAO_OCEAN_AREA_COLUMN_CREATOR");
                    for (Parameter param : dmClient.getInputParameters(op)) {
                        switch (param.getName()) {
                            case "InputTable": {
                                param.setValue(this.enhancedTable.getId().getValue() + "");
                                break;
                            }
                            case "Longitude_Column": {
                                param.setValue(this.longColumn.getLocalId().getValue());
                                break;
                            }
                            case "Latitude_Column": {
                                param.setValue(this.latColumn.getLocalId().getValue());
                                break;
                            }
                            case "Resolution": {
                                Integer resolution = this.precision != null ? (this.precision > 0.0 ? this.precision.intValue() : 1) : 1;
                                param.setValue(resolution.toString());
                                break;
                            }
                            case "OutputTableName": {
                                param.setValue("ocean_");
                            }
                        }
                        op.addOperatorParameter(param);
                    }
                    break;
                }
            }
            log.debug("Going to submit resulting operator {} ", (Object)op);
            this.wrapperParameters.put(StatisticalOperationFactory.SM_ENTRIES.getIdentifier(), Collections.singletonMap("operator", op));
        }
        catch (IOException | ProcessingException e) {
            throw new WorkerException("Unexpected error : Unable to prepare column names.", e);
        }
        catch (Exception e) {
            throw new WorkerException("Unable to prepare WPS request.", (Throwable)e);
        }
    }

    private void submitExecution() throws OperationAbortedException, WorkerException {
        block5: {
            WorkerWrapper wrapper = this.createWorkerWrapper((WorkerFactory)this.statisticalFactory);
            try {
                WorkerStatus status = wrapper.execute(this.enhancedTable.getId(), null, this.wrapperParameters);
                if (status.equals((Object)WorkerStatus.SUCCEDED)) {
                    for (ResourceDescriptorResult result : ((ResourcesResult)wrapper.getResult()).getResources()) {
                        if (!result.getResourceType().equals((Object)ResourceType.GENERIC_TABLE)) continue;
                        this.generatedTable = this.cubeManager.getTable(((TableResource)result.getResource()).getTableId());
                    }
                    if (this.generatedTable == null) {
                        throw new WorkerException("No tables were generated by submitted computation");
                    }
                    break block5;
                }
                throw new WorkerException("Failed algorithm execution, internal status is :" + status);
            }
            catch (InvalidInvocationException e) {
                log.debug("Unable to submit to SM : ", (Throwable)e);
                throw new WorkerException("Unable to submit computation, " + e.getMessage());
            }
        }
        this.cubeManager.removeTable(this.enhancedTable.getId());
    }

    private void addColumn() throws WorkerException, OperationAbortedException, ParseException, IOException, ProcessingException {
        Column generatedCol = null;
        Column externalIdColumn = null;
        Collection<String> curatedLabels = Common.curateLabels(this.targetTable, this.toEscapeColumnName).values();
        for (Column externalCol : this.generatedTable.getColumnsExceptTypes(new Class[]{IdColumnType.class})) {
            boolean isGenerated = true;
            String externalLabel = OperationHelper.retrieveColumnLabel((Column)externalCol);
            if (externalLabel.equalsIgnoreCase(this.exportedIdColumnLabel)) {
                externalIdColumn = externalCol;
                continue;
            }
            if (curatedLabels.contains(externalLabel)) {
                isGenerated = false;
                continue;
            }
            generatedCol = externalCol;
        }
        Column localId = (Column)this.targetTable.getColumnsByType(new Class[]{IdColumnType.class}).get(0);
        Equals condition = new Equals((Expression)this.targetTable.getColumnReference(localId), (Expression)new Cast((Expression)this.generatedTable.getColumnReference(externalIdColumn), localId.getDataType()));
        HashMap<String, Object> addColumnParameters = new HashMap<String, Object>();
        addColumnParameters.put(AddColumnFactory.COLUMN_TYPE.getIdentifier(), this.importedColumnType);
        addColumnParameters.put(AddColumnFactory.DATA_TYPE.getIdentifier(), generatedCol.getDataType());
        addColumnParameters.put(AddColumnFactory.LABEL.getIdentifier(), new ImmutableLocalizedText(OperationHelper.retrieveColumnLabel((Column)generatedCol) + (this.precision != null ? this.precision : "")));
        addColumnParameters.put(AddColumnFactory.VALUE_PARAMETER.getIdentifier(), this.generatedTable.getColumnReference(generatedCol));
        addColumnParameters.put(AddColumnFactory.CONDITION_PARAMETER.getIdentifier(), condition);
        WorkerWrapper wrapper = this.createWorkerWrapper((WorkerFactory)this.addColumnFactory);
        try {
            WorkerStatus status = wrapper.execute(this.targetTable.getId(), null, addColumnParameters);
            if (!status.equals((Object)WorkerStatus.SUCCEDED)) {
                throw new WorkerException("Unexpected worker status while adding column : " + status);
            }
            this.resultTable = ((WorkerResult)wrapper.getResult()).getResultTable();
        }
        catch (InvalidInvocationException e) {
            throw new WorkerException("Unable to add generatedColumn", (Throwable)e);
        }
        this.cubeManager.removeTable(this.generatedTable.getId());
    }
}

