package org.gcube.data.analysis.tabulardata.commons.templates.model;

import java.util.Arrays;
import java.util.List;

import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.ColumnCategory;

import static org.gcube.data.analysis.tabulardata.commons.templates.model.columns.ColumnCategory.*;



public enum TemplateCategory {

	CODELIST(CODENAME, CODEDESCRIPTION, ANNOTATION, CODE),
	DATASET(ATTRIBUTE, DIMENSION, MEASURE), 
	GENERIC(MEASURE, ATTRIBUTE);
	
	private List<ColumnCategory> columnTypes;
	
	private TemplateCategory(ColumnCategory ... columnTypes ) {
		this.columnTypes = Arrays.asList(columnTypes);
	}

	/**
	 * @return the classes
	 */
	public List<ColumnCategory> getAllowedColumn() {
		return columnTypes;
	}
	
	
}
