package org.gcube.data.analysis.tabulardata.commons.webservice;

import java.util.List;

import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;
import javax.jws.soap.SOAPBinding.Style;
import javax.jws.soap.SOAPBinding.Use;
import org.gcube.data.analysis.tabulardata.commons.rules.Rule;
import org.gcube.data.analysis.tabulardata.commons.rules.RuleScope;
import org.gcube.data.analysis.tabulardata.commons.utils.Constants;

@WebService(targetNamespace=Constants.TNS)
@SOAPBinding(style = Style.DOCUMENT, use=Use.LITERAL)
public interface RuleManager {

	public static final String SERVICE_NAME = "rulemanager";

	@SOAPBinding(parameterStyle=ParameterStyle.WRAPPED)
	long saveRule(String name, String description, Rule rule);

	@SOAPBinding(parameterStyle=ParameterStyle.WRAPPED)
	List<Rule> getRules();
	
	@SOAPBinding(parameterStyle=ParameterStyle.WRAPPED)
	List<Rule> getRulesByScope(RuleScope scope);
	
}
