package org.gcube.data.analysis.tabulardata.commons.webservice.types;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import org.gcube.data.analysis.tabulardata.commons.templates.model.Template;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class TemplateDescription {
	
	private long id;
	
	private String name;
	
	private String description;
	
	private String agency;
	
	private Template template;

	@SuppressWarnings("unused")
	private TemplateDescription(){}
	
	public TemplateDescription(long id, String name, String description,
			String agency, Template template) {
		super();
		this.id = id;
		this.name = name;
		this.description = description;
		this.agency = agency;
		this.template = template;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @param description the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * @return the agency
	 */
	public String getAgency() {
		return agency;
	}

	/**
	 * @param agency the agency to set
	 */
	public void setAgency(String agency) {
		this.agency = agency;
	}

	/**
	 * @return the template
	 */
	public Template getTemplate() {
		return template;
	}

	/**
	 * @param template the template to set
	 */
	public void setTemplate(Template template) {
		this.template = template;
	}

	/**
	 * @return the id
	 */
	public long getId() {
		return id;
	}
	
}
