/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.commons.rules;

import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.commons.rules.Rule;
import org.gcube.data.analysis.tabulardata.commons.rules.RuleScope;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.MalformedExpressionException;
import org.gcube.data.analysis.tabulardata.expression.PlaceholderReplacer;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.table.TableId;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ColumnRule<T extends DataType>
extends Rule {
    private Expression preparedExpression;

    private ColumnRule() {
    }

    public ColumnRule(Expression preparedExpression) {
        this.preparedExpression = preparedExpression;
    }

    public Expression getPreparedExpression() {
        return this.preparedExpression;
    }

    @Override
    public RuleScope getScope() {
        return RuleScope.COLUMN;
    }

    @Override
    public Expression getExpression(TableId tableId, Map<String, Column> placeholderColumnMapping) {
        if (placeholderColumnMapping.size() != 1) {
            throw new IllegalArgumentException("a ColumnRule can be applied only on one column");
        }
        Column selectedColumn = (Column)placeholderColumnMapping.values().toArray()[0];
        ColumnReference reference = new ColumnReference(tableId, selectedColumn.getLocalId());
        PlaceholderReplacer replacer = null;
        try {
            replacer = new PlaceholderReplacer(this.getPreparedExpression());
            replacer.replaceAll(reference);
        }
        catch (MalformedExpressionException e) {
            throw new RuntimeException(e);
        }
        return replacer.getExpression();
    }
}

