/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.commons.webservice.types;

import java.io.Serializable;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TaskStatus;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TaskStep;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.WorkerResult;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.adapters.ThrowableAdapter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TaskInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement
    protected TaskType type = TaskType.OPERATION;
    @XmlElement
    protected long referenceId;
    @XmlElement
    private String identifier;
    @XmlElement
    private String submitter;
    @XmlElement
    private Calendar startTime;
    @XmlElement
    private Calendar endTime;
    @XmlJavaTypeAdapter(value=ThrowableAdapter.class)
    private Throwable errorCause;
    @XmlElement
    private List<TaskStep> taskSteps;
    @XmlElement
    private TaskStatus status;
    @XmlElement
    private WorkerResult result;

    TaskInfo() {
    }

    public TaskInfo(String submitter) {
        this.submitter = submitter;
        this.identifier = UUID.randomUUID().toString();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean isAborted() {
        return this.getStatus() == TaskStatus.ABORTED;
    }

    public Calendar getStartTime() {
        return this.startTime;
    }

    public Calendar getEndTime() {
        return this.endTime;
    }

    public void setStartTime(Calendar startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Calendar endTime) {
        this.endTime = endTime;
    }

    public Throwable getErrorCause() {
        return this.errorCause;
    }

    public void setErrorCause(Throwable errorCause) {
        this.errorCause = errorCause;
    }

    public List<TaskStep> getTaskSteps() {
        return this.taskSteps;
    }

    public void setTaskSteps(List<TaskStep> taskSteps) {
        this.taskSteps = taskSteps;
    }

    public String getSubmitter() {
        return this.submitter;
    }

    public TaskStatus getStatus() {
        return this.status;
    }

    public void setStatus(TaskStatus status) {
        this.status = status;
    }

    public WorkerResult getResult() {
        return this.result;
    }

    public TaskType getType() {
        return this.type;
    }

    public void setResult(WorkerResult result) {
        this.result = result;
    }

    public String toString() {
        return "TaskInfo [type=" + (Object)((Object)this.type) + ", identifier=" + this.identifier + ", submitter=" + this.submitter + ", errorCause=" + this.errorCause + ", taskSteps=" + this.taskSteps + ", status=" + (Object)((Object)this.status) + ", result=" + this.result + "]";
    }

    public static enum TaskType {
        TEMPLATE,
        OPERATION;

    }
}

