package org.gcube.data.analysis.tabulardata.commons.webservice;

import java.util.List;

import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;

import org.gcube.data.analysis.tabulardata.commons.webservice.exception.InternalSecurityException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.resources.ResourceDescriptor;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.resources.ResourceType;

public interface ResourceManager {

	public static final String SERVICE_NAME = "resourcemanager";
	
	@SOAPBinding(parameterStyle=ParameterStyle.WRAPPED)
	List<ResourceDescriptor> getResourcePerTabularResource(long tabularResourceId) throws NoSuchTabularResourceException, InternalSecurityException;
	
	@SOAPBinding(parameterStyle=ParameterStyle.WRAPPED)
	List<ResourceDescriptor> getResourcePerTabularResourceAndType(long tabularResourceId, ResourceType type) throws NoSuchTabularResourceException;
}
