/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks;

import java.io.Serializable;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TaskStatus;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.WorkerResult;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.adapters.ThrowableAdapter;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.OperationTaskInfo;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.RollbackTaskInfo;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.TaskStep;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.TemplateTaskInfo;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlSeeAlso(value={TemplateTaskInfo.class, OperationTaskInfo.class, RollbackTaskInfo.class})
public abstract class TaskInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private String identifier;
    @XmlElement
    private String submitter;
    @XmlElement
    private Calendar startTime;
    @XmlElement
    private Calendar endTime;
    @XmlJavaTypeAdapter(value=ThrowableAdapter.class)
    private Throwable errorCause;
    @XmlElement
    private List<TaskStep> taskSteps;
    @XmlElement
    private TaskStatus status = TaskStatus.INITIALIZING;
    @XmlElement
    private WorkerResult result;

    protected TaskInfo() {
    }

    public TaskInfo(String submitter) {
        this.submitter = submitter;
        this.setStartTime(Calendar.getInstance());
        this.identifier = UUID.randomUUID().toString();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean isAborted() {
        return this.getStatus() == TaskStatus.ABORTED;
    }

    public Calendar getStartTime() {
        return this.startTime;
    }

    public Calendar getEndTime() {
        return this.endTime;
    }

    public void setStartTime(Calendar startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Calendar endTime) {
        this.endTime = endTime;
    }

    public Throwable getErrorCause() {
        return this.errorCause;
    }

    public void setErrorCause(Throwable errorCause) {
        this.errorCause = errorCause;
    }

    public List<TaskStep> getTaskSteps() {
        return this.taskSteps;
    }

    public void setTaskSteps(List<TaskStep> taskSteps) {
        this.taskSteps = taskSteps;
    }

    public String getSubmitter() {
        return this.submitter;
    }

    public TaskStatus getStatus() {
        return this.status;
    }

    public void setStatus(TaskStatus status) {
        this.status = status;
    }

    public WorkerResult getResult() {
        return this.result;
    }

    public abstract boolean isResubmittable();

    public abstract TaskType getType();

    public void setResult(WorkerResult result) {
        this.result = result;
    }

    public String toString() {
        return "TaskInfo [type=" + (Object)((Object)this.getType()) + ", identifier=" + this.identifier + ", submitter=" + this.submitter + ", errorCause=" + this.errorCause + ", taskSteps=" + this.taskSteps + ", status=" + (Object)((Object)this.status) + ", result=" + this.result + "]";
    }

    public static enum TaskType {
        TEMPLATE,
        OPERATION,
        ROLLBACK;

    }
}

