/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.commons.templates.model.actions.arguments;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gcube.data.analysis.tabulardata.commons.templates.model.Representable;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.arguments.ArgumentDescriptor;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.arguments.ChangeHandler;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.arguments.ContainerInstance;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.arguments.InstanceChangedEventListener;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.arguments.InstanceInterface;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.arguments.InvalidationEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArgumentInstance<T extends Representable>
implements InstanceInterface,
InstanceChangedEventListener {
    private static final Logger log = LoggerFactory.getLogger(ArgumentInstance.class);
    private String identifier = UUID.randomUUID().toString();
    private boolean valid = false;
    private boolean alive = true;
    private List<T> instance;
    private ContainerInstance containerInstanceBelongsTo;
    private List<T> selector;
    private Map<String, ChangeHandler<T>> handlerMap;
    private List<InstanceChangedEventListener> instanceChangeListener = new ArrayList<InstanceChangedEventListener>();
    private List<InvalidationEventListener> invalidationEventListeners = new ArrayList<InvalidationEventListener>();
    private ArgumentDescriptor<T> parent;

    protected ArgumentInstance(ArgumentDescriptor<T> parent) {
        this.parent = parent;
        if (this.parent.getSelection() != null) {
            this.selector = new ArrayList<T>(this.parent.getSelection());
        }
    }

    public List<T> values() {
        return this.instance;
    }

    public void addInvalidatorListener(InvalidationEventListener listener) {
        log.trace("registering invalidation listener ");
        this.invalidationEventListeners.add(listener);
    }

    protected synchronized void registerListener(InstanceChangedEventListener listener) {
        log.trace("registering on change listener ");
        this.instanceChangeListener.add(listener);
    }

    public void set(T ... instance) {
        this.instance = Arrays.asList(instance);
        log.trace("instanceModified - notifying parent");
        this.instanceChangedNotification();
    }

    public void set(List<T> instances) {
        this.instance = instances;
        log.trace("instanceModified - notifying parent");
        this.instanceChangedNotification();
    }

    public List<T> get() {
        return Collections.unmodifiableList(this.instance);
    }

    protected void invalidationNotification() {
        log.trace("notifying registered listener(instance changed)");
        for (InvalidationEventListener descriptor : this.invalidationEventListeners) {
            descriptor.onInvalid(this.getIdentifier());
        }
    }

    protected void selectorChangedNotification() {
        log.trace("notifying registered listener(instance changed)");
        for (InvalidationEventListener descriptor : this.invalidationEventListeners) {
            descriptor.onSelectorChanged(this.getIdentifier());
        }
    }

    protected synchronized void instanceChangedNotification() {
        log.trace("notifying registered listener(instance changed)");
        ArrayList<InstanceChangedEventListener> toRemove = new ArrayList<InstanceChangedEventListener>();
        for (InstanceChangedEventListener descriptor : this.instanceChangeListener) {
            if (descriptor.isAlive()) {
                descriptor.onChange(this.get(), this.parent.getIdentifier(), this.getIdentifier());
                continue;
            }
            toRemove.add(descriptor);
        }
        this.instanceChangeListener.removeAll(toRemove);
    }

    private void reset() {
        this.instance = new ArrayList<T>();
        this.instanceChangedNotification();
    }

    protected void setInvalid() {
        this.valid = false;
        this.reset();
        this.invalidationNotification();
    }

    @Override
    public String getDescription() {
        return this.parent.getDescription();
    }

    @Override
    public String getName() {
        return this.parent.getName();
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    public String toString() {
        return "ArgumentInstance [identifier=" + this.identifier + ", getDescription()=" + this.getDescription() + ", getName()=" + this.getName() + " isMultiSelection=" + this.parent.isMultiArgument() + "]";
    }

    @Override
    public void onChange(List<Object> values, String senderArgumentId, String senderInstanceId) {
        log.trace("handler is null? " + (this.handlerMap.get(senderArgumentId) == null) + " in " + this.parent.getName());
        if (this.handlerMap.get(senderArgumentId) == null) {
            return;
        }
        List<T> newvalues = this.handlerMap.get(senderArgumentId).change(values, Collections.unmodifiableList(this.parent.getSelection()), senderInstanceId);
        if (newvalues != null) {
            this.selector = newvalues;
            this.selectorChangedNotification();
            log.trace("notifiing selector change");
        }
        log.trace("invalidating instance");
        this.setInvalid();
    }

    @Override
    public boolean isAlive() {
        return this.alive;
    }

    public void setAlive(boolean alive) {
        this.alive = alive;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArgumentInstance)) {
            return false;
        }
        ArgumentInstance other = (ArgumentInstance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        return !(this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier));
    }

    public boolean canEqual(Object other) {
        return other instanceof ArgumentInstance;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        String $identifier = this.getIdentifier();
        result = result * 31 + ($identifier == null ? 0 : $identifier.hashCode());
        return result;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    public ContainerInstance getContainerInstanceBelongsTo() {
        return this.containerInstanceBelongsTo;
    }

    protected void setContainerInstanceBelongsTo(ContainerInstance containerInstanceBelongsTo) {
        this.containerInstanceBelongsTo = containerInstanceBelongsTo;
    }

    public void setSelector(List<T> selector) {
        this.selector = selector;
    }

    public List<T> getSelector() {
        return this.selector;
    }

    public void setHandlerMap(Map<String, ChangeHandler<T>> handlerMap) {
        this.handlerMap = handlerMap;
    }

    public ArgumentDescriptor<T> getParent() {
        return this.parent;
    }
}

