/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.service;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.jws.WebService;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationProvider;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationToken;
import org.gcube.data.analysis.tabulardata.commons.webservice.HistoryManager;
import org.gcube.data.analysis.tabulardata.commons.webservice.QueryManager;
import org.gcube.data.analysis.tabulardata.commons.webservice.TabularResourceManager;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.InternalSecurityException;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TabularResource;
import org.gcube.data.analysis.tabulardata.mobile.model.MColumnDescription;
import org.gcube.data.analysis.tabulardata.mobile.model.MTabularResource;
import org.gcube.data.analysis.tabulardata.mobile.service.MOrderDirection;
import org.gcube.data.analysis.tabulardata.mobile.service.MTabularResourceType;
import org.gcube.data.analysis.tabulardata.mobile.service.MobileInterface;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryOrder;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryOrderDirection;
import org.gcube.data.analysis.tabulardata.query.parameters.QueryPage;
import org.gcube.data.analysis.tabulardata.weld.WeldService;

@WebService(portName="MobileInterfacePort", serviceName="mobileinterface", targetNamespace="http://gcube-system.org/mobile", endpointInterface="org.gcube.data.analysis.tabulardata.mobile.service.MobileInterface")
@Singleton
@WeldService
public class MobileInterfaceImpl
implements MobileInterface {
    @Inject
    TabularResourceManager tdManager;
    @Inject
    QueryManager queryManager;
    @Inject
    HistoryManager historyManager;

    public List<String> getAllTabularResource(String user, String scope) {
        ScopeProvider.instance.set(scope);
        AuthorizationProvider.instance.set(new AuthorizationToken(user));
        List resources = Collections.emptyList();
        try {
            resources = this.tdManager.getAllTabularResources();
        }
        catch (InternalSecurityException internalSecurityException) {
            // empty catch block
        }
        ArrayList<String> toReturn = new ArrayList<String>();
        for (TabularResource resource : resources) {
            MTabularResource mobileTR = new MTabularResource(resource.getId(), resource.getCreationDate(), resource.getName(), resource.getOwner(), MTabularResourceType.valueOf((String)resource.getTableType().toUpperCase()));
            toReturn.add(new Gson().toJson((Object)mobileTR));
        }
        return toReturn;
    }

    public String getData(String user, String scope, long trid, String orderColumn, MOrderDirection orderType, int start, int limit) {
        ScopeProvider.instance.set(scope);
        AuthorizationProvider.instance.set(new AuthorizationToken(user));
        try {
            Table table = this.historyManager.getLastTable(trid);
            QueryOrder order = new QueryOrder(new ColumnLocalId(orderColumn), QueryOrderDirection.valueOf((String)orderType.name()));
            return this.queryManager.queryAsJson(table.getId().getValue(), new QueryPage(start, limit), null, null, null, order);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int getCount(String user, String scope, long trid) {
        ScopeProvider.instance.set(scope);
        AuthorizationProvider.instance.set(new AuthorizationToken(user));
        try {
            Table table = this.historyManager.getLastTable(trid);
            if (table == null) {
                return 0;
            }
            return this.queryManager.getQueryLenght(table.getId().getValue(), null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getTableDescription(String user, String scope, long trid) {
        ScopeProvider.instance.set(scope);
        AuthorizationProvider.instance.set(new AuthorizationToken(user));
        try {
            Table table = this.historyManager.getLastTable(trid);
            ArrayList<String> mColumns = new ArrayList<String>();
            for (Column column : table.getColumns()) {
                String label = column.contains(NamesMetadata.class) ? ((LocalizedText)((NamesMetadata)column.getMetadata(NamesMetadata.class)).getTexts().get(0)).getValue() : column.getName();
                MColumnDescription mColumnDescr = new MColumnDescription(label, column.getName(), MColumnDescription.Type.valueOf((String)column.getColumnType().getCode()), column.getLocalId().getValue());
                mColumns.add(new Gson().toJson((Object)mColumnDescr));
            }
            return mColumns;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

