/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.service;

import javax.persistence.EntityManager;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationToken;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.InternalSecurityException;
import org.gcube.data.analysis.tabulardata.exceptions.NoSuchObjectException;
import org.gcube.data.analysis.tabulardata.metadata.Identifiable;
import org.gcube.data.analysis.tabulardata.utils.Util;

public class SharingHelper {
    public static <T, I extends Identifiable> I share(Class<I> returnClass, T entityId, EntityManager entityManager, AuthorizationToken ... shares) throws NoSuchObjectException, InternalSecurityException {
        Util.checkAuthorization();
        Identifiable sTr = Util.getOwnerhipAuthorizedObject(entityId, returnClass, (EntityManager)entityManager);
        if (shares != null && shares.length > 0) {
            for (AuthorizationToken token : shares) {
                if (token.getGroup() == null) {
                    String userToken = String.format("u(%s)", token.getUser());
                    if (sTr.getSharedWith().contains(userToken)) continue;
                    sTr.getSharedWith().add(userToken);
                    continue;
                }
                String groupToken = String.format("g(%s)", token.getGroup());
                if (sTr.getSharedWith().contains(groupToken)) continue;
                sTr.getSharedWith().add(groupToken);
            }
            entityManager.getTransaction().begin();
            entityManager.merge((Object)sTr);
            entityManager.getTransaction().commit();
        }
        return (I)sTr;
    }

    public static <T, I extends Identifiable> I unshare(Class<I> returnClass, T entityId, EntityManager entityManager, AuthorizationToken ... unshares) throws NoSuchObjectException, InternalSecurityException {
        Util.checkAuthorization();
        Identifiable sTr = Util.getOwnerhipAuthorizedObject(entityId, returnClass, (EntityManager)entityManager);
        if (unshares == null || unshares.length == 0) {
            for (AuthorizationToken token : unshares) {
                if (token.getGroup() == null) {
                    sTr.getSharedWith().remove(String.format("u(%s)", token.getUser()));
                    continue;
                }
                sTr.getSharedWith().remove(String.format("g(%s)", token.getGroup()));
            }
            entityManager.getTransaction().begin();
            entityManager.merge((Object)sTr);
            entityManager.getTransaction().commit();
        }
        return (I)sTr;
    }
}

