/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.service;

import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.jws.WebService;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.tabulardata.cleaner.GarbageCollectorFactory;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationProvider;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationToken;
import org.gcube.data.analysis.tabulardata.commons.webservice.TabularResourceManager;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.InternalSecurityException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TabularResource;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TabularResourceType;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.notifications.Notification;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.exceptions.NoSuchObjectException;
import org.gcube.data.analysis.tabulardata.metadata.StorableHistoryStep;
import org.gcube.data.analysis.tabulardata.metadata.notification.StorableNotification;
import org.gcube.data.analysis.tabulardata.metadata.tabularresource.RelationLink;
import org.gcube.data.analysis.tabulardata.metadata.tabularresource.StorableTabularResource;
import org.gcube.data.analysis.tabulardata.model.metadata.table.DatasetViewTableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.service.SharingHelper;
import org.gcube.data.analysis.tabulardata.utils.EntityManagerHelper;
import org.gcube.data.analysis.tabulardata.utils.Notifier;
import org.gcube.data.analysis.tabulardata.utils.Util;
import org.gcube.data.analysis.tabulardata.weld.WeldService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService(portName="TabularResourceManagerPort", serviceName="tabularresourcemanager", targetNamespace="http://gcube-system.org/tabularresource", endpointInterface="org.gcube.data.analysis.tabulardata.commons.webservice.TabularResourceManager")
@Singleton
@WeldService
public class TabularResourceManagerImpl
implements TabularResourceManager {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, MMM d, yyyy 'at' HH:mm:ss z");
    private Logger logger = LoggerFactory.getLogger(TabularResourceManager.class);
    @Inject
    private EntityManagerHelper emHelper;
    @Inject
    private CubeManager cubeManager;
    @Inject
    private GarbageCollectorFactory garbageCollectorFactory;
    @Inject
    private Notifier notifier;

    @PreDestroy
    public void removePendingTable() {
        this.logger.trace("removing pending table before shutdown");
        this.garbageCollectorFactory.getGarbageCollector().stop();
    }

    public TabularResource createTabularResource(TabularResourceType tabularResourceType) throws InternalSecurityException {
        Util.checkAuthorization();
        this.logger.trace("create tabularResource method called");
        StorableTabularResource resource = new StorableTabularResource();
        resource.setScopes((List)Lists.newArrayList((Object[])new String[]{ScopeProvider.instance.get()}));
        resource.setOwner(AuthorizationProvider.instance.get().getUser());
        resource.setName("tabularResource " + dateFormat.format(resource.getCreationDate().getTime()));
        resource.setTabularResourceType(tabularResourceType);
        EntityManager em = this.emHelper.getEntityManager();
        em.getTransaction().begin();
        em.persist((Object)resource);
        em.getTransaction().commit();
        em.close();
        return Util.toTabularResource((StorableTabularResource)resource);
    }

    public TabularResource updateTabularResource(TabularResource tabularResource) throws NoSuchTabularResourceException, InternalSecurityException {
        StorableTabularResource sTr;
        this.logger.trace("update tabularResource method called with properties " + tabularResource.getProperties());
        EntityManager em = this.emHelper.getEntityManager();
        try {
            sTr = (StorableTabularResource)Util.getOwnerhipAuthorizedObject((Object)tabularResource.getId(), StorableTabularResource.class, (EntityManager)em);
        }
        catch (NoSuchObjectException e) {
            em.close();
            throw new NoSuchTabularResourceException(tabularResource.getId());
        }
        sTr.setName(tabularResource.getName());
        sTr.setProperties(tabularResource.getProperties());
        sTr.finalize(tabularResource.isFinalized());
        Boolean updateLink = false;
        try {
            if (tabularResource.getNewVersionId() != null && (sTr.getNewVersion() == null || tabularResource.getNewVersionId().longValue() != sTr.getNewVersion().getId())) {
                sTr.setNewVersion((StorableTabularResource)Util.getUserAuthorizedObject((Object)tabularResource.getNewVersionId(), StorableTabularResource.class, (EntityManager)em));
                updateLink = true;
            }
        }
        catch (NoSuchObjectException e1) {
            this.logger.warn("error setting new version with id " + tabularResource.getNewVersionId());
        }
        em.getTransaction().begin();
        em.merge((Object)sTr);
        if (updateLink.booleanValue() && sTr.getLinkedBy().size() > 0) {
            List notifications = this.notifier.onLinkUpdated(sTr.getLinkedBy());
            for (StorableNotification notification : notifications) {
                em.persist((Object)notification);
                notification.getTabularResource().getNotifications().add(notification);
                em.merge((Object)notification.getTabularResource());
            }
        }
        em.getTransaction().commit();
        em.close();
        return Util.toTabularResource((StorableTabularResource)sTr);
    }

    public void remove(long id) throws NoSuchTabularResourceException, InternalSecurityException {
        StorableTabularResource sTr;
        this.logger.debug("removing tabular resource " + id);
        EntityManager em = this.emHelper.getEntityManager();
        try {
            sTr = (StorableTabularResource)Util.getOwnerhipAuthorizedObject((Object)id, StorableTabularResource.class, (EntityManager)em);
        }
        catch (NoSuchObjectException e) {
            em.close();
            throw new NoSuchTabularResourceException(id);
        }
        em.getTransaction().begin();
        this.removeInternal(sTr, em);
        em.getTransaction().commit();
        em.close();
    }

    private List<TableId> removeInternal(StorableTabularResource sTr, EntityManager em) {
        ArrayList<TableId> tableIdsToRemove = new ArrayList<TableId>();
        TypedQuery linksToQuery = em.createNamedQuery("RelationLink.linksTo", RelationLink.class);
        linksToQuery.setParameter("trid", (Object)sTr.getId());
        Long tableId = sTr.getTableId();
        for (Object hs : sTr.getHistorySteps()) {
            if (hs.getTableId() == null) continue;
            tableIdsToRemove.add(new TableId(hs.getTableId().longValue()));
        }
        for (RelationLink link : linksToQuery.getResultList()) {
            em.remove((Object)link);
            if (link.getLinksToTabulaResource().isDeleted() && link.getLinksToTabulaResource().getLinkedBy().size() == 0) {
                tableIdsToRemove.addAll(this.removeInternal(link.getLinksToTabulaResource(), em));
                this.logger.trace("removing tabualarResource " + link.getLinksToTabulaResource().getId() + " without links");
            }
            this.logger.trace("removing linksTo: " + link);
        }
        TypedQuery linkedByQuery = em.createNamedQuery("RelationLink.linkedBy", RelationLink.class);
        linkedByQuery.setParameter("trid", (Object)sTr.getId());
        List linkedBy = linkedByQuery.getResultList();
        if (linkedBy.size() > 0) {
            this.logger.debug("setting external tabularResource " + sTr.getName() + " as deleted (it will not be removed)");
            sTr.setDeleted(true);
            em.merge((Object)sTr);
        } else {
            this.logger.debug("removing external tabularResource " + sTr.getName() + " cause is without links");
            em.remove((Object)sTr);
            if (tableId != null) {
                tableIdsToRemove.add(new TableId(tableId.longValue()));
            }
        }
        return tableIdsToRemove;
    }

    public List<TabularResource> getAllTabularResources() throws InternalSecurityException {
        Util.checkAuthorization();
        AuthorizationToken authToken = AuthorizationProvider.instance.get();
        ArrayList storedTabularResources = new ArrayList();
        HashMap<String, String> parameters = new HashMap<String, String>(3);
        parameters.put("user", authToken.getUser());
        parameters.put("group", authToken.getGroup());
        parameters.put("scope", ScopeProvider.instance.get());
        storedTabularResources.addAll(this.emHelper.getResults("TR.getAll", StorableTabularResource.class, parameters));
        ArrayList<TabularResource> tabularResources = new ArrayList<TabularResource>();
        for (StorableTabularResource str : storedTabularResources) {
            tabularResources.add(Util.toTabularResource((StorableTabularResource)str));
        }
        return tabularResources;
    }

    public List<TabularResource> getTabularResourcesByType(String type) throws InternalSecurityException {
        Util.checkAuthorization();
        AuthorizationToken authToken = AuthorizationProvider.instance.get();
        ArrayList storedTabularResources = new ArrayList();
        HashMap<String, String> parameters = new HashMap<String, String>(4);
        parameters.put("user", authToken.getUser());
        parameters.put("group", authToken.getGroup());
        parameters.put("scope", ScopeProvider.instance.get());
        parameters.put("type", type);
        storedTabularResources.addAll(this.emHelper.getResults("TR.getAllByType", StorableTabularResource.class, parameters));
        ArrayList<TabularResource> tabularResources = new ArrayList<TabularResource>();
        for (StorableTabularResource str : storedTabularResources) {
            tabularResources.add(Util.toTabularResource((StorableTabularResource)str));
        }
        return tabularResources;
    }

    public TabularResource getTabularResource(long id) throws NoSuchTabularResourceException, InternalSecurityException {
        Util.checkAuthorization();
        AuthorizationToken authToken = AuthorizationProvider.instance.get();
        this.logger.info("calling getTabularResourceById with parameters: " + authToken.getUser() + " , " + ScopeProvider.instance.get() + " , " + id);
        ArrayList storedTabularResources = new ArrayList();
        HashMap<String, Object> parameters = new HashMap<String, Object>(4);
        parameters.put("user", authToken.getUser());
        parameters.put("group", authToken.getGroup());
        parameters.put("scope", ScopeProvider.instance.get());
        parameters.put("id", id);
        storedTabularResources.addAll(this.emHelper.getResults("TR.getById", StorableTabularResource.class, parameters));
        if (storedTabularResources.size() != 1 || ((StorableTabularResource)storedTabularResources.get(0)).isDeleted()) {
            throw new NoSuchTabularResourceException(id);
        }
        StorableTabularResource str = (StorableTabularResource)storedTabularResources.get(0);
        return Util.toTabularResource((StorableTabularResource)str);
    }

    public StorableTabularResource getTabularResourceByIdWithoutAuth(long id) throws NoSuchTabularResourceException {
        ArrayList storedTabularResources = new ArrayList();
        storedTabularResources.addAll(this.emHelper.getResults("TR.getByIdWithoutAuth", StorableTabularResource.class, Collections.singletonMap("id", id)));
        if (storedTabularResources.size() != 1 || ((StorableTabularResource)storedTabularResources.get(0)).isDeleted()) {
            throw new NoSuchTabularResourceException(id);
        }
        StorableTabularResource str = (StorableTabularResource)storedTabularResources.get(0);
        return str;
    }

    public List<Notification> getNotificationPerTabularResource(long id) throws InternalSecurityException {
        Util.checkAuthorization();
        AuthorizationToken authToken = AuthorizationProvider.instance.get();
        HashMap<String, Object> parameters = new HashMap<String, Object>(4);
        parameters.put("user", authToken.getUser());
        parameters.put("group", authToken.getGroup());
        parameters.put("scope", ScopeProvider.instance.get());
        parameters.put("trid", id);
        return Util.toNotificationList((List)this.emHelper.getResults("Notification.getByTr", StorableNotification.class, parameters));
    }

    public List<Notification> getNotificationPerUser() throws InternalSecurityException {
        Util.checkAuthorization();
        AuthorizationToken authToken = AuthorizationProvider.instance.get();
        HashMap<String, String> parameters = new HashMap<String, String>(3);
        parameters.put("user", authToken.getUser());
        parameters.put("group", authToken.getGroup());
        parameters.put("scope", ScopeProvider.instance.get());
        return Util.toNotificationList((List)this.emHelper.getResults("Notification.getByUser", StorableNotification.class, parameters));
    }

    public TabularResource share(Long entityId, AuthorizationToken ... authTokens) throws NoSuchTabularResourceException, InternalSecurityException {
        try (EntityManager em = this.emHelper.getEntityManager();){
            StorableTabularResource str = (StorableTabularResource)SharingHelper.share(StorableTabularResource.class, (Object)entityId, (EntityManager)em, (AuthorizationToken[])authTokens);
            TabularResource tabularResource = Util.toTabularResource((StorableTabularResource)str);
            return tabularResource;
        }
    }

    public TabularResource unshare(Long entityId, AuthorizationToken ... authTokens) throws NoSuchTabularResourceException, InternalSecurityException {
        try (EntityManager em = this.emHelper.getEntityManager();){
            TabularResource tabularResource = Util.toTabularResource((StorableTabularResource)((StorableTabularResource)SharingHelper.unshare(StorableTabularResource.class, (Object)entityId, (EntityManager)em, (AuthorizationToken[])authTokens)));
            return tabularResource;
        }
    }

    public void cleanDatabase() {
        ArrayList storedTabularResources = new ArrayList();
        storedTabularResources.addAll(this.emHelper.getResults("TR.getAllWithoutAuth", StorableTabularResource.class, new HashMap(0)));
        this.logger.trace("retrieved tablular resources are {}", (Object)storedTabularResources.size());
        ArrayList<Long> tableToSave = new ArrayList<Long>();
        for (StorableTabularResource st : storedTabularResources) {
            if (st.getTableId() != null) {
                try {
                    tableToSave.add(st.getTableId());
                    Table table = this.cubeManager.getTable(new TableId(st.getTableId().longValue()));
                    if (table.contains(DatasetViewTableMetadata.class)) {
                        tableToSave.add(((DatasetViewTableMetadata)table.getMetadata(DatasetViewTableMetadata.class)).getTargetDatasetViewTableId().getValue());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.logger.trace("retrieving histories for tabular resource {}", (Object)st.getId());
            for (StorableHistoryStep hs : st.getHistorySteps()) {
                if (hs.getTableId() == null) continue;
                tableToSave.add(hs.getTableId());
            }
        }
        Collection tables = this.cubeManager.getTables();
        this.logger.trace("retrieved tables are {}", (Object)tables.size());
        int removedTable = 0;
        for (Table table : tables) {
            try {
                if (tableToSave.contains(table.getId().getValue())) continue;
                this.cubeManager.removeTable(table.getId());
                this.logger.trace("removed table {}", (Object)table.getId());
                ++removedTable;
            }
            catch (Exception e) {
                this.logger.warn("table with id {} not removed", (Object)table.getId());
            }
        }
        this.logger.info("removed {} table", (Object)removedTable);
    }
}

