/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.OnRowErrorAction;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TaskStepClassifier;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.WorkerStatus;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.tasks.TaskStep;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ResourceCreatorWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ValidationWorker;
import org.gcube.data.analysis.tabulardata.task.ValidationStepUpdater;
import org.gcube.data.analysis.tabulardata.utils.InternalInvocation;

@Entity
public class TaskContext {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id;
    private List<InternalInvocation> invocationCouples;
    private List<InternalInvocation> postValidations = new ArrayList();
    private List<InternalInvocation> postOperations = new ArrayList();
    private List<TaskStep> tasks;
    private List<TaskStep> postValidationTasks = new ArrayList();
    private List<TaskStep> postOperationTasks = new ArrayList();
    private TableId currentTable;
    private TableId startingTable;
    @Column
    private int step;
    @Column
    private OnRowErrorAction behaviour;

    private TaskContext() {
    }

    public TaskContext(List<InternalInvocation> invocationCouples, OnRowErrorAction behaviour) {
        this.step = -1;
        this.invocationCouples = new ArrayList<InternalInvocation>(invocationCouples);
        this.behaviour = behaviour;
        this.tasks = this.getTaskSteps(invocationCouples, TaskStepClassifier.PROCESSING);
    }

    public void addPostValidations(List<InternalInvocation> postValidations) {
        this.postValidations = postValidations;
        this.postValidationTasks = this.getTaskSteps(postValidations, TaskStepClassifier.DATAVALIDATION);
    }

    public void addPostOperations(List<InternalInvocation> postOperations) {
        this.postOperations = postOperations;
        this.postOperationTasks = this.getTaskSteps(postOperations, TaskStepClassifier.POSTPROCESSING);
    }

    public List<InternalInvocation> getPostValidations() {
        return this.postValidations;
    }

    public List<InternalInvocation> getPostOperations() {
        return this.postOperations;
    }

    public List<TaskStep> getPostValidationTasks() {
        return this.postValidationTasks;
    }

    public List<TaskStep> getPostOperationTasks() {
        return this.postOperationTasks;
    }

    public List<InternalInvocation> getInvocationCouples() {
        return Collections.unmodifiableList(this.invocationCouples);
    }

    public boolean isParallelizableExecution() {
        for (InternalInvocation invocation : this.getInvocationCouples()) {
            if (!invocation.isNop() && invocation.getWorkerFactory().getWorkerType().equals(ResourceCreatorWorker.class)) continue;
            return false;
        }
        return true;
    }

    public List<TaskStep> getTasks() {
        ArrayList steps = new ArrayList(this.tasks);
        steps.addAll(this.postValidationTasks);
        steps.addAll(this.postOperationTasks);
        return Collections.unmodifiableList(steps);
    }

    public void insertRecoveryInvocation(InternalInvocation invocation) {
        if (!this.isFirst()) {
            this.invocationCouples.add(this.step, invocation);
            this.tasks.add(this.step, this.retrieveSingleTaskStep(invocation, TaskStepClassifier.PROCESSING));
        } else {
            this.invocationCouples.add(this.step, invocation);
            this.tasks.add(0, this.retrieveSingleTaskStep(invocation, TaskStepClassifier.PROCESSING));
        }
    }

    public boolean isFirst() {
        return this.step == 0;
    }

    public boolean isBeforeFirst() {
        return this.step == -1;
    }

    public InternalInvocation getCurrentInvocation() {
        return (InternalInvocation)this.invocationCouples.get(this.step);
    }

    public TaskStep getCurrentTask() {
        return (TaskStep)this.tasks.get(this.step);
    }

    public boolean hasNext() {
        return this.step < this.invocationCouples.size() - 1;
    }

    public boolean moveNext() {
        if (!this.hasNext()) {
            return false;
        }
        ++this.step;
        return true;
    }

    public boolean movePrevious() {
        if (this.isBeforeFirst()) {
            return false;
        }
        this.resetCurrentStep();
        --this.step;
        return true;
    }

    private void resetCurrentStep() {
        TaskStep taskStep = this.retrieveSingleTaskStep(this.getCurrentInvocation(), TaskStepClassifier.PROCESSING);
        this.tasks.set(this.step, taskStep);
    }

    public void cleanValidationsOnCurrentStep() {
        this.getCurrentTask().cleanValidations();
    }

    private List<TaskStep> getTaskSteps(List<InternalInvocation> invocations, TaskStepClassifier classifier) {
        ArrayList<TaskStep> workerSteps = new ArrayList<TaskStep>();
        for (InternalInvocation invocation : invocations) {
            workerSteps.add(this.retrieveSingleTaskStep(invocation, classifier));
        }
        return workerSteps;
    }

    private TaskStep retrieveSingleTaskStep(InternalInvocation invocation, TaskStepClassifier classifier) {
        if (invocation.isNop()) {
            return new TaskStep(null, TaskStepClassifier.PROCESSING);
        }
        OperationExecution opExecution = new OperationExecution(invocation.getWorkerFactory().getOperationDescriptor().getOperationId().getValue(), invocation.getParameters());
        if (invocation.getColumnId() != null) {
            opExecution.setColumnId(invocation.getColumnId().getValue());
        }
        TaskStep toReturn = new TaskStep(opExecution, classifier);
        toReturn.setExecutionDescription(invocation.getWorkerFactory().getOperationDescriptor().getDescription());
        Collection precoditions = invocation.getWorkerFactory().getPreconditionValidationMap().values();
        if (!precoditions.isEmpty()) {
            ArrayList<ValidationStepUpdater> validationSteps = new ArrayList<ValidationStepUpdater>(precoditions.size());
            for (WorkerFactory preconditionFactory : precoditions) {
                ValidationStepUpdater validationStep = new ValidationStepUpdater();
                validationStep.setExecutionDescription(preconditionFactory.getOperationDescriptor().getDescription());
                validationStep.setStatus(WorkerStatus.PENDING);
                validationSteps.add(validationStep);
            }
            toReturn.setValidationSteps(validationSteps);
        } else if (invocation.getWorkerFactory().getWorkerType().equals(ValidationWorker.class)) {
            ValidationStepUpdater validationStep = new ValidationStepUpdater();
            validationStep.setExecutionDescription(invocation.getWorkerFactory().getOperationDescriptor().getDescription());
            validationStep.setStatus(WorkerStatus.PENDING);
            toReturn.setValidationSteps(Collections.singletonList(validationStep));
        }
        return toReturn;
    }

    public TableId getCurrentTable() {
        return this.currentTable;
    }

    public void setCurrentTable(TableId currentTable) {
        this.currentTable = currentTable;
    }

    public TableId getStartingTable() {
        return this.startingTable;
    }

    public void setStartingTable(TableId startingTable) {
        this.startingTable = startingTable;
    }

    public OnRowErrorAction getBehaviour() {
        return this.behaviour;
    }

    public String toString() {
        return "TaskContext [id=" + this.id + ", invocationCouples=" + this.invocationCouples + ",  tasks=" + this.tasks + ", step=" + this.step + ", behaviour=" + this.behaviour + "]";
    }

    public void addParametersOnNextOperation(Map<String, Object> instanceParametersToChange) {
        if (!this.hasNext()) {
            return;
        }
        ((TaskStep)this.tasks.get(this.step + 1)).getSourceInvocation().getParameters().putAll(instanceParametersToChange);
        ((InternalInvocation)this.invocationCouples.get(this.step + 1)).getParameters().putAll(instanceParametersToChange);
    }

    public void resetPostOperationsForResume() {
        this.postValidationTasks = this.getTaskSteps(this.postValidations, TaskStepClassifier.POSTPROCESSING);
        this.postOperationTasks = this.getTaskSteps(this.postOperations, TaskStepClassifier.POSTPROCESSING);
    }
}

