/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.utils;

import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationProvider;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationToken;
import org.gcube.smartgears.handlers.application.RequestEvent;
import org.gcube.smartgears.handlers.application.RequestHandler;
import org.gcube.smartgears.handlers.application.request.RequestError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="authorization-handler")
public class AuthorizationHandler
extends RequestHandler {
    private static Logger logger = LoggerFactory.getLogger(AuthorizationHandler.class);

    public void handleRequest(RequestEvent call) {
        String authTokenString = call.request().getHeader("tabular-data-auth-header");
        if (authTokenString != null) {
            try {
                AuthorizationToken authToken = AuthorizationToken.unmarshal((String)authTokenString);
                AuthorizationProvider.instance.set(authToken);
            }
            catch (Exception e) {
                logger.error("error unmarshalling authorization token", (Throwable)e);
                RequestError.invalid_request_error.fire("error deserializing authorization token");
            }
        }
    }

    public String getName() {
        return "authorization-handler";
    }
}

