/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationProvider;
import org.gcube.data.analysis.tabulardata.commons.utils.AuthorizationToken;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.InternalSecurityException;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.HistoryData;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.RuleDescription;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TabularResource;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TemplateDescription;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.notifications.Notification;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.resources.ResourceDescriptor;
import org.gcube.data.analysis.tabulardata.exceptions.NoSuchObjectException;
import org.gcube.data.analysis.tabulardata.metadata.Identifiable;
import org.gcube.data.analysis.tabulardata.metadata.StorableHistoryStep;
import org.gcube.data.analysis.tabulardata.metadata.StorableRule;
import org.gcube.data.analysis.tabulardata.metadata.StorableTemplate;
import org.gcube.data.analysis.tabulardata.metadata.notification.StorableNotification;
import org.gcube.data.analysis.tabulardata.metadata.resources.StorableResource;
import org.gcube.data.analysis.tabulardata.metadata.tabularresource.StorableTabularResource;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.OperationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;

/*
 * Exception performing whole class analysis ignored.
 */
public class Util {
    public static List<HistoryData> toHistoryDataList(List<StorableHistoryStep> steps) {
        ArrayList<HistoryData> historyDataList = new ArrayList<HistoryData>();
        for (StorableHistoryStep step : steps) {
            historyDataList.add(Util.toHistoryData((StorableHistoryStep)step));
        }
        return historyDataList;
    }

    public static HistoryData toHistoryData(StorableHistoryStep step) {
        return new HistoryData(step.getId(), step.getOperationDescription(), step.getTableId() == null ? null : new TableId(step.getTableId().longValue()), step.getDate());
    }

    public static OperationExecution toOperationExecution(OperationInvocation invocation) {
        OperationExecution opExec = new OperationExecution(invocation.getOperationDescriptor().getOperationId().getValue(), invocation.getParameterInstances());
        if (invocation.getTargetColumnId() != null) {
            opExec.setColumnId(invocation.getTargetColumnId().getValue());
        }
        return opExec;
    }

    public static OperationDefinition toOperationDefinition(OperationDescriptor descriptor) {
        return new OperationDefinition(descriptor.getOperationId().getValue(), descriptor.getName(), descriptor.getDescription(), descriptor.getParameters());
    }

    public static TabularResource toTabularResource(StorableTabularResource sTr) {
        TabularResource tabularResource = new TabularResource(sTr.getId(), sTr.getTabularResourceType(), sTr.getName(), sTr.getOwner(), sTr.getCreationDate(), sTr.getTableType(), sTr.getSharedWith(), sTr.getProperties(), Util.toHistoryDataList((List)sTr.getHistorySteps()), sTr.isValid(), sTr.isLocked());
        tabularResource.finalize(sTr.isFinalized());
        return tabularResource;
    }

    public static ResourceDescriptor toResourceDescriptor(StorableResource sr) {
        ResourceDescriptor resource = new ResourceDescriptor(sr.getId(), sr.getName(), sr.getDescription(), sr.getCreationDate(), sr.getCreatorId(), sr.getResource(), sr.getType());
        return resource;
    }

    public static List<Notification> toNotificationList(List<StorableNotification> resultList) {
        if (resultList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        for (StorableNotification notification : resultList) {
            notifications.add(Util.toNotification((StorableNotification)notification));
        }
        return notifications;
    }

    public static Notification toNotification(StorableNotification result) {
        return new Notification(result.getAffectedObject(), result.getUpdateEvent(), result.getNotificationObject().getHumanReadableDescription(), result.getDate());
    }

    public static TemplateDescription toTemplateDescription(StorableTemplate sTemplate) {
        return new TemplateDescription(sTemplate.getId(), sTemplate.getOwner(), sTemplate.getName(), sTemplate.getDescription(), sTemplate.getAgency(), sTemplate.getCreationDate(), sTemplate.getTemplate(), sTemplate.getSharedWith());
    }

    public static RuleDescription toRuleDescription(StorableRule sRule) {
        return new RuleDescription(sRule.getId(), sRule.getName(), sRule.getDescription(), sRule.getCreationDate(), sRule.getRule().getExpressionWithPlaceholder(), sRule.getRuleScope(), sRule.getOwner(), sRule.getRuleType(), sRule.getSharedWith());
    }

    public static List<ResourceDescriptor> toResourceDescriptorList(List<StorableResource> resources) {
        if (resources.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ResourceDescriptor> descriptors = new ArrayList<ResourceDescriptor>();
        for (StorableResource sr : resources) {
            descriptors.add(Util.toResourceDescriptor((StorableResource)sr));
        }
        return descriptors;
    }

    public static <T, R extends Identifiable> R getOwnerhipAuthorizedObject(T id, Class<R> objectClass, EntityManager entityManager) throws NoSuchObjectException, InternalSecurityException {
        Util.checkAuthorization();
        AuthorizationToken authToken = AuthorizationProvider.instance.get();
        Identifiable sTr = (Identifiable)entityManager.find(objectClass, id);
        if (sTr == null || !sTr.getScopes().contains(ScopeProvider.instance.get())) {
            throw new NoSuchObjectException();
        }
        if (!sTr.getOwner().equals(authToken.getUser())) {
            throw new InternalSecurityException(authToken + " is not owner of " + objectClass.getName() + " with id " + id.toString());
        }
        return (R)sTr;
    }

    public static <T, R extends Identifiable> R getUserAuthorizedObject(T id, Class<R> objectClass, EntityManager entityManager) throws NoSuchObjectException, InternalSecurityException {
        Util.checkAuthorization();
        AuthorizationToken authToken = AuthorizationProvider.instance.get();
        Identifiable sTr = (Identifiable)entityManager.find(objectClass, id);
        if (sTr == null || !sTr.getScopes().contains(ScopeProvider.instance.get())) {
            throw new NoSuchObjectException();
        }
        if (!(sTr.getOwner().equals(authToken.getUser()) || sTr.getSharedWith().contains(String.format("u(%s)", authToken.getUser())) || sTr.getSharedWith().contains(String.format("g(%s)", authToken.getGroup())))) {
            throw new InternalSecurityException(authToken + " is not authorized to use " + objectClass.getName() + " with id " + id.toString());
        }
        return (R)sTr;
    }

    public static void checkAuthorization() throws InternalSecurityException {
        if (AuthorizationProvider.instance.get() == null || AuthorizationProvider.instance.get().getUser() == null) {
            throw new InternalSecurityException("authorization needed");
        }
    }
}

