package org.gcube.data.analysis.tabulardata.model.column;

import java.io.Serializable;
import java.util.Collection;

import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.metadata.CubeMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.HashMapMetadataHolder;
import org.gcube.data.analysis.tabulardata.model.metadata.MetadataHolder;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationship;

public abstract class Column implements Serializable, MetadataHolder {

	/**
	 * 
	 */
	private static final long serialVersionUID = 222621862202261888L;
	
	private MetadataHolder delegate = new HashMapMetadataHolder();

	public abstract String getLabel();

	public abstract void setLabel(String label);

	public abstract boolean hasName();

	public abstract String getName();

	public abstract void setName(String name);

	public abstract DataType getDataType();

	public abstract boolean hasRelationship();

	public abstract ColumnRelationship getRelationship();

	public abstract ColumnType getColumnType();

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("Column [getColumnType()=");
		builder.append(getColumnType());
		builder.append(", hasName()=");
		builder.append(hasName());
		if (hasName()) {
			builder.append(", getName()=");
			builder.append(getName());
		}
		builder.append(", getLabel()=");
		builder.append(getLabel());
		builder.append(", getDataType()=");
		builder.append(getDataType());
		builder.append(", getAllMetadata()=");
		builder.append(getAllMetadata());
		builder.append(", hasRelationship()=");
		builder.append(hasRelationship());
		if (hasRelationship()) {
			builder.append(", getRelationship()=");
			builder.append(getRelationship());
		}
		builder.append("]");
		return builder.toString();
	}

	public <C extends CubeMetadata<? extends Serializable>> C getMetadata(Class<C> metadataType) {
		return delegate.getMetadata(metadataType);
	}

	public void removeMetadata(Class<? extends CubeMetadata<? extends Serializable>> metadataType) {
		delegate.removeMetadata(metadataType);
	}

	public void setMetadata(CubeMetadata<? extends Serializable> metadata) {
		delegate.setMetadata(metadata);
	}

	public Collection<CubeMetadata<Serializable>> getAllMetadata() {
		return delegate.getAllMetadata();
	}

	public void removeAllMetadata() {
		delegate.removeAllMetadata();
	}

	public void setMetadata(Collection<? extends CubeMetadata<? extends Serializable>> metadataObjects) {
		delegate.setMetadata(metadataObjects);
	}

	public <T extends Serializable> T getMetadataObject(Class<? extends CubeMetadata<T>> metadataType) {
		return delegate.getMetadataObject(metadataType);
	}

	

}