package org.gcube.data.analysis.tabulardata.model.column;

import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationship;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationshipImpl;

import com.google.common.base.Optional;


public abstract class StatefulBaseColumn extends Column {

	/**
	 * 
	 */
	private static final long serialVersionUID = -8722122712089071970L;

	/**
	 * The label assigned to the column
	 */
	private String label;

	/**
	 * The table column name
	 */
	private Optional<String> name = Optional.absent();

	/**
	 * The column data type
	 */
	private DataType dataType;
	
	private Optional<ColumnRelationshipImpl> relationship = Optional.absent();

	private ColumnType columnType;

	public StatefulBaseColumn(String label, String name, DataType dataType, ColumnRelationshipImpl relationship, ColumnType columnType) {
		if (label == null || label.isEmpty() )
			throw new IllegalArgumentException("label cannot be null or empty");
		if (dataType == null)
			throw new IllegalArgumentException("DataType cannot be null");
		this.label = label;
		this.dataType = dataType;
		this.name = Optional.fromNullable(name);
		this.relationship = Optional.fromNullable(relationship);
		this.columnType = columnType;
	}

	@Override
	public String getLabel() {
		return label;
	}

	@Override
	public void setLabel(String label) {
		this.label=label;
		
	}

	@Override
	public boolean hasName() {
		return name.isPresent();
	}

	@Override
	public String getName() {
		return name.get();
	}

	@Override
	public DataType getDataType() {
		return dataType;
	}

	@Override
	public boolean hasRelationship() {
		return relationship.isPresent();
	}

	@Override
	public ColumnRelationship getRelationship() {
		return relationship.get();
	}

	@Override
	public ColumnType getColumnType() {
		return columnType;
	}

	@Override
	public void setName(String name) {
		this.name=Optional.of(name);
	}
}
