package org.gcube.data.analysis.tabulardata.model.metadata;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;

import com.google.common.collect.Maps;

public class HashMapMetadataHolder implements MetadataHolder {

	private Map<String, CubeMetadata<Serializable>> metadata = Maps.newHashMap();

	@SuppressWarnings("rawtypes")
	private String getMetadataKey(Class metadataType) {
		return metadataType.getName();
	}

	@SuppressWarnings("unchecked")
	@Override
	public <C extends CubeMetadata<? extends Serializable>> C getMetadata(Class<C> metadataType) {
		return (C) this.metadata.get(getMetadataKey(metadataType));
	}

	@Override
	public void removeMetadata(Class<? extends CubeMetadata<? extends Serializable>> metadataType) {
		this.metadata.remove((getMetadataKey(metadataType)));
	}

	@SuppressWarnings("unchecked")
	@Override
	public void setMetadata(CubeMetadata<? extends Serializable> metadata) {
		this.metadata.put(getMetadataKey(metadata.getClass()), (CubeMetadata<Serializable>) metadata);
	}

	@Override
	public Collection<CubeMetadata<Serializable>> getAllMetadata() {
		return this.metadata.values();
	}

	@Override
	public void removeAllMetadata() {
		this.metadata = Maps.newHashMap();
	}

	@Override
	public void setMetadata(Collection<? extends CubeMetadata<? extends Serializable>> metadataObjects) {
		for (CubeMetadata<? extends Serializable> cubeMetadata : metadataObjects) {
			setMetadata(cubeMetadata);
		}
	}

	@Override
	public <T extends Serializable> T getMetadataObject(Class<? extends CubeMetadata<T>> metadataType) {
		return getMetadata(metadataType).getMetadataObject();
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((metadata == null) ? 0 : metadata.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		HashMapMetadataHolder other = (HashMapMetadataHolder) obj;
		if (metadata == null) {
			if (other.metadata != null)
				return false;
		} else if (!metadata.equals(other.metadata))
			return false;
		return true;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("HashMapMetadataHolder [metadata=");
		builder.append(metadata);
		builder.append("]");
		return builder.toString();
	}

}
