package org.gcube.data.analysis.tabulardata.expression.leaf.text;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import org.gcube.data.analysis.tabulardata.expression.LeafExpression;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDText;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class TextEquals extends LeafExpression {

	private ColumnReference columnReference;

	private TDText checkedValue;
	
	@SuppressWarnings("unused")
	private TextEquals() {}

	public TextEquals(ColumnReference columnReference, TDText checkedValue) {
		super();
		this.columnReference = columnReference;
		this.checkedValue = checkedValue;
	}

	public ColumnReference getColumnReference() {
		return columnReference;
	}

	public TDText getCheckedValue() {
		return checkedValue;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((checkedValue == null) ? 0 : checkedValue.hashCode());
		result = prime * result + ((columnReference == null) ? 0 : columnReference.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		TextEquals other = (TextEquals) obj;
		if (checkedValue == null) {
			if (other.checkedValue != null)
				return false;
		} else if (!checkedValue.equals(other.checkedValue))
			return false;
		if (columnReference == null) {
			if (other.columnReference != null)
				return false;
		} else if (!columnReference.equals(other.columnReference))
			return false;
		return true;
	}

}
