package org.gcube.data.analysis.tabulardata.model.metadata.common;

import java.io.Serializable;
import java.util.Locale;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;

@XmlAccessorType(XmlAccessType.FIELD)
public class LocalizedText implements Serializable {

	/**
		 * 
		 */
	private static final long serialVersionUID = 5174487267101638176L;

	@XmlAttribute(name = "value")
	private String value;

	@XmlAttribute(name = "locale")
	private String localeCode = null;

	@SuppressWarnings("unused")
	private LocalizedText() {
		// Serialization only
	}

	public LocalizedText(String value) {
		this(value,Locale.ENGLISH);
	};

	public LocalizedText(String value, Locale locale) {
		this.value = value;
		this.localeCode = locale.getLanguage();
	}
	
	public LocalizedText(String value, String localeCode) {
		this.value = value;
		this.localeCode = new Locale(localeCode).getLanguage();
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public Locale getLocale() {
		return new Locale(localeCode);
	}

	public void setLocale(Locale locale) {
		this.localeCode = locale.getLanguage();
	}
	
	public String getLocaleCode(){
		return localeCode;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((localeCode == null) ? 0 : localeCode.hashCode());
		result = prime * result + ((value == null) ? 0 : value.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		LocalizedText other = (LocalizedText) obj;
		if (localeCode == null) {
			if (other.localeCode != null)
				return false;
		} else if (!localeCode.equals(other.localeCode))
			return false;
		if (value == null) {
			if (other.value != null)
				return false;
		} else if (!value.equals(other.value))
			return false;
		return true;
	}
	
	

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("LocalizedText [value=");
		builder.append(value);
		builder.append(", localeCode=");
		builder.append(localeCode);
		builder.append("]");
		return builder.toString();
	}

}
