/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model.metadata.common;

import java.io.Serializable;
import java.util.Locale;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class LocalizedText
implements Serializable {
    private static final long serialVersionUID = 5174487267101638176L;
    @XmlAttribute(name="value")
    private String value;
    @XmlAttribute(name="locale")
    private String localeCode = null;

    private LocalizedText() {
    }

    public LocalizedText(String value) {
        this(value, Locale.ENGLISH);
    }

    public LocalizedText(String value, Locale locale) {
        this.value = value;
        this.localeCode = locale.getLanguage();
    }

    public LocalizedText(String value, String localeCode) {
        this.value = value;
        this.localeCode = new Locale(localeCode).getLanguage();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Locale getLocale() {
        return new Locale(this.localeCode);
    }

    public void setLocale(Locale locale) {
        this.localeCode = locale.getLanguage();
    }

    public String getLocaleCode() {
        return this.localeCode;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.localeCode == null ? 0 : this.localeCode.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalizedText other = (LocalizedText)obj;
        if (this.localeCode == null ? other.localeCode != null : !this.localeCode.equals(other.localeCode)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LocalizedText [value=");
        builder.append(this.value);
        builder.append(", localeCode=");
        builder.append(this.localeCode);
        builder.append("]");
        return builder.toString();
    }
}

