package org.gcube.data.analysis.tabulardata.expression.leaf;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import org.gcube.data.analysis.tabulardata.expression.LeafExpression;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class ValueIsIn extends LeafExpression {

	private ColumnReference sourceColumnReference;

	private ColumnReference referencedColumnReference;

	@SuppressWarnings("unused")
	private ValueIsIn() {
	}

	public ValueIsIn(ColumnReference sourceColumnReference, ColumnReference referencedColumnReference) {
		super();
		this.sourceColumnReference = sourceColumnReference;
		this.referencedColumnReference = referencedColumnReference;
	}

	public ColumnReference getSourceColumnReference() {
		return sourceColumnReference;
	}

	public ColumnReference getReferencedColumnReference() {
		return referencedColumnReference;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((referencedColumnReference == null) ? 0 : referencedColumnReference.hashCode());
		result = prime * result + ((sourceColumnReference == null) ? 0 : sourceColumnReference.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ValueIsIn other = (ValueIsIn) obj;
		if (referencedColumnReference == null) {
			if (other.referencedColumnReference != null)
				return false;
		} else if (!referencedColumnReference.equals(other.referencedColumnReference))
			return false;
		if (sourceColumnReference == null) {
			if (other.sourceColumnReference != null)
				return false;
		} else if (!sourceColumnReference.equals(other.sourceColumnReference))
			return false;
		return true;
	}

}
