/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.expression.composite.arithmetic;

import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.MalformedExpressionException;
import org.gcube.data.analysis.tabulardata.expression.Operator;
import org.gcube.data.analysis.tabulardata.expression.composite.BinaryExpression;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.NumericType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;

@XmlRootElement
public class Subtraction
extends BinaryExpression {
    private static final long serialVersionUID = 1256644830788961321L;

    private Subtraction() {
    }

    public Subtraction(Expression leftArgument, Expression rightArgument) {
        super(leftArgument, rightArgument);
    }

    @Override
    public Operator getOperator() {
        return Operator.SUBTRACTION;
    }

    @Override
    public DataType getReturnedDataType() throws MalformedExpressionException {
        DataType right;
        DataType left = this.getLeftArgument().getReturnedDataType();
        if (left == (right = this.getRightArgument().getReturnedDataType())) {
            return left;
        }
        if (left instanceof TextType || right instanceof TextType) {
            return new TextType();
        }
        if (left instanceof NumericType || right instanceof NumericType) {
            return new NumericType();
        }
        throw new MalformedExpressionException("Left argument " + left + " and right argument " + right + " are not compatible for " + (Object)((Object)this.getOperator()));
    }
}

