/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.model.Converter;
import org.gcube.data.analysis.tabulardata.model.NumberConstant;
import org.gcube.data.analysis.tabulardata.model.ValueFormat;
import org.gcube.data.analysis.tabulardata.model.datatype.BooleanType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.DateType;
import org.gcube.data.analysis.tabulardata.model.datatype.GeometryType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.datatype.NumericType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.time.TimeConstants;

public class DataTypeFormats {
    private static Map<Class<? extends DataType>, List<ValueFormat>> dataTypeFormats = new HashMap<Class<? extends DataType>, List<ValueFormat>>();

    public static List<ValueFormat> getFormatsPerDataType(Class<? extends DataType> dataType) {
        return dataTypeFormats.get(dataType);
    }

    public static ValueFormat getFormatPerId(Class<? extends DataType> dataType, String id) {
        for (ValueFormat tf : dataTypeFormats.get(dataType)) {
            if (!tf.getId().equals(id)) continue;
            return tf;
        }
        return null;
    }

    static {
        dataTypeFormats.put(BooleanType.class, Arrays.asList(ValueFormat.format("BOOL TEXT", "^([Ff][Aa][Ll][Ss][Ee]|[Tt][Rr][Uu][Ee])$", "false|true", new Converter[0]), ValueFormat.format("BOOL NUMBER", "^(0|1)$", "0|1", new Converter[0])));
        dataTypeFormats.put(DateType.class, Arrays.asList(TimeConstants.ISO_DATE_ANY_SEP, TimeConstants.EUROPEAN_DATE, TimeConstants.US_DATE));
        dataTypeFormats.put(GeometryType.class, Arrays.asList(ValueFormat.format("POINT", "^POINT\\(\\s*[\\+-]?\\d+(\\.\\d+)?\\s+[\\+-]?\\d+(\\.\\d+)?\\s*\\)$", " (eg POINT(13.2 24) )", new Converter[0])));
        dataTypeFormats.put(IntegerType.class, Arrays.asList(NumberConstant.STORAGE_FORMAT_INT));
        dataTypeFormats.put(NumericType.class, Arrays.asList(NumberConstant.STORAGE_FORMAT_DEC, NumberConstant.FRENCH_FORMAT, NumberConstant.GERMAN_FORMAT, NumberConstant.ITALIAN_FORMAT, NumberConstant.US_FORMAT));
        dataTypeFormats.put(TextType.class, Arrays.asList(ValueFormat.format("TEXT", "^.*$", "lorem ipsum", new Converter[0])));
    }
}

