/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.ConvexHull;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;

public class MinimumDiameter {
    private final Geometry inputGeom;
    private final boolean isConvex;
    private LineSegment minBaseSeg = new LineSegment();
    private Coordinate minWidthPt = null;
    private int minPtIndex;
    private double minWidth = 0.0;

    public MinimumDiameter(Geometry inputGeom) {
        this(inputGeom, false);
    }

    public MinimumDiameter(Geometry inputGeom, boolean isConvex) {
        this.inputGeom = inputGeom;
        this.isConvex = isConvex;
    }

    public double getLength() {
        this.computeMinimumDiameter();
        return this.minWidth;
    }

    public Coordinate getWidthCoordinate() {
        this.computeMinimumDiameter();
        return this.minWidthPt;
    }

    public LineString getSupportingSegment() {
        this.computeMinimumDiameter();
        return this.inputGeom.getFactory().createLineString(new Coordinate[]{this.minBaseSeg.p0, this.minBaseSeg.p1});
    }

    public LineString getDiameter() {
        this.computeMinimumDiameter();
        if (this.minWidthPt == null) {
            return this.inputGeom.getFactory().createLineString((Coordinate[])null);
        }
        Coordinate basePt = this.minBaseSeg.project(this.minWidthPt);
        return this.inputGeom.getFactory().createLineString(new Coordinate[]{basePt, this.minWidthPt});
    }

    private void computeMinimumDiameter() {
        if (this.minWidthPt != null) {
            return;
        }
        if (this.isConvex) {
            this.computeWidthConvex(this.inputGeom);
        } else {
            Geometry convexGeom = new ConvexHull(this.inputGeom).getConvexHull();
            this.computeWidthConvex(convexGeom);
        }
    }

    private void computeWidthConvex(Geometry geom) {
        Coordinate[] pts = null;
        pts = geom instanceof Polygon ? ((Polygon)geom).getExteriorRing().getCoordinates() : geom.getCoordinates();
        if (pts.length == 0) {
            this.minWidth = 0.0;
            this.minWidthPt = null;
            this.minBaseSeg = null;
        } else if (pts.length == 1) {
            this.minWidth = 0.0;
            this.minWidthPt = pts[0];
            this.minBaseSeg.p0 = pts[0];
            this.minBaseSeg.p1 = pts[0];
        } else if (pts.length == 2 || pts.length == 3) {
            this.minWidth = 0.0;
            this.minWidthPt = pts[0];
            this.minBaseSeg.p0 = pts[0];
            this.minBaseSeg.p1 = pts[1];
        } else {
            this.computeConvexRingMinDiameter(pts);
        }
    }

    private void computeConvexRingMinDiameter(Coordinate[] pts) {
        this.minWidth = Double.MAX_VALUE;
        int currMaxIndex = 1;
        LineSegment seg = new LineSegment();
        for (int i = 0; i < pts.length - 1; ++i) {
            seg.p0 = pts[i];
            seg.p1 = pts[i + 1];
            currMaxIndex = this.findMaxPerpDistance(pts, seg, currMaxIndex);
        }
    }

    private int findMaxPerpDistance(Coordinate[] pts, LineSegment seg, int startIndex) {
        int maxIndex;
        double maxPerpDistance;
        double nextPerpDistance = maxPerpDistance = seg.distancePerpendicular(pts[startIndex]);
        int nextIndex = maxIndex = startIndex;
        while (nextPerpDistance >= maxPerpDistance) {
            maxPerpDistance = nextPerpDistance;
            maxIndex = nextIndex;
            nextIndex = MinimumDiameter.nextIndex(pts, maxIndex);
            nextPerpDistance = seg.distancePerpendicular(pts[nextIndex]);
        }
        if (maxPerpDistance < this.minWidth) {
            this.minPtIndex = maxIndex;
            this.minWidth = maxPerpDistance;
            this.minWidthPt = pts[this.minPtIndex];
            this.minBaseSeg = new LineSegment(seg);
        }
        return maxIndex;
    }

    private static int nextIndex(Coordinate[] pts, int index) {
        if (++index >= pts.length) {
            index = 0;
        }
        return index;
    }
}

