/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.collection.RandomFeatureAccess;
import org.geotools.feature.collection.SubFeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubFeatureList
extends SubFeatureCollection
implements RandomFeatureAccess {
    List<SortBy> sort;
    List<FeatureId> index;

    public SubFeatureList(SimpleFeatureCollection list, Filter filter) {
        this(list, filter, SortBy.NATURAL_ORDER);
    }

    public SubFeatureList(SimpleFeatureCollection list, SortBy sort) {
        this(list, (Filter)Filter.INCLUDE, sort);
    }

    public SubFeatureList(SimpleFeatureCollection list, Filter filter, SortBy subSort) {
        super(list, filter);
        if (subSort == null || subSort.equals(SortBy.NATURAL_ORDER)) {
            this.sort = Collections.emptyList();
        } else {
            this.sort = new ArrayList<SortBy>();
            if (this.collection instanceof SubFeatureList) {
                SubFeatureList sorted = (SubFeatureList)this.collection;
                this.sort.addAll(sorted.sort);
            }
            this.sort.add(subSort);
        }
        this.index = null;
    }

    public SubFeatureList(SimpleFeatureCollection list, List order) {
        super(list);
        this.index = order;
        this.filter = null;
    }

    public SimpleFeature get(int position) {
        if (this.collection instanceof RandomFeatureAccess) {
            RandomFeatureAccess random = (RandomFeatureAccess)this.collection;
            FeatureId fid = this.index().get(position);
            return random.getFeatureMember(fid.getID());
        }
        Iterator<SimpleFeature> it = this.iterator();
        try {
            int i = 0;
            while (it.hasNext()) {
                SimpleFeature feature = it.next();
                if (i == position) {
                    SimpleFeature simpleFeature = feature;
                    return simpleFeature;
                }
                ++i;
            }
            throw new IndexOutOfBoundsException();
        }
        finally {
            this.close(it);
        }
    }

    @Override
    protected Filter createFilter() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        HashSet<FeatureId> featureIds = new HashSet<FeatureId>();
        Iterator<FeatureId> it = this.index().iterator();
        while (it.hasNext()) {
            featureIds.add(ff.featureId((String)it.next()));
        }
        Id fids = ff.id(featureIds);
        return fids;
    }

    protected List<FeatureId> index() {
        if (this.index == null) {
            this.index = this.createIndex();
        }
        return this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<FeatureId> createIndex() {
        ArrayList<FeatureId> fids = new ArrayList<FeatureId>();
        Iterator it = this.collection.iterator();
        try {
            while (it.hasNext()) {
                SimpleFeature feature = (SimpleFeature)it.next();
                if (!this.filter.evaluate((Object)feature)) continue;
                fids.add(feature.getIdentifier());
            }
            if (this.sort != null && !this.sort.isEmpty()) {
                final SortBy initialOrder = this.sort.get(this.sort.size() - 1);
                Collections.sort(fids, new Comparator<FeatureId>(){

                    @Override
                    public int compare(FeatureId key1, FeatureId key2) {
                        SimpleFeature feature2;
                        SimpleFeature feature1 = SubFeatureList.this.getFeatureMember(key1.getID());
                        int compare = this.compare(feature1, feature2 = SubFeatureList.this.getFeatureMember(key2.getID()), initialOrder);
                        if (compare == 0 && SubFeatureList.this.sort.size() > 1) {
                            for (int i = SubFeatureList.this.sort.size() - 1; compare == 0 && i >= 0; --i) {
                                compare = this.compare(feature1, feature2, SubFeatureList.this.sort.get(i));
                            }
                        }
                        return compare;
                    }

                    protected int compare(SimpleFeature feature1, SimpleFeature feature2, SortBy order) {
                        PropertyName name = order.getPropertyName();
                        Comparable value1 = (Comparable)name.evaluate((Object)feature1);
                        Comparable value2 = (Comparable)name.evaluate((Object)feature2);
                        if (order.getSortOrder() == SortOrder.ASCENDING) {
                            return value1.compareTo(value2);
                        }
                        return value2.compareTo(value1);
                    }
                });
            }
        }
        finally {
            this.collection.close(it);
        }
        return fids;
    }

    @Override
    public boolean add(SimpleFeature feature) {
        boolean added = this.collection.add(feature);
        if (added) {
            this.index().add(feature.getIdentifier());
        }
        return true;
    }

    public int indexOf(SimpleFeature feature) {
        return this.index().indexOf(feature.getIdentifier());
    }

    public int lastIndexOf(SimpleFeature feature) {
        return this.index().lastIndexOf(feature.getIdentifier());
    }

    @Override
    public SimpleFeatureCollection subList(Filter subfilter) {
        if (this.filter.equals(Filter.INCLUDE)) {
            return this;
        }
        if (this.filter.equals(Filter.EXCLUDE)) {
            // empty if block
        }
        return new SubFeatureList(this.collection, (Filter)this.ff.and(this.filter, subfilter), this.sort.get(0));
    }

    @Override
    public SimpleFeature getFeatureMember(String id) throws NoSuchElementException {
        int position = this.index.indexOf(id);
        if (position == -1) {
            throw new NoSuchElementException(id);
        }
        if (this.collection instanceof RandomFeatureAccess) {
            RandomFeatureAccess random = (RandomFeatureAccess)this.collection;
            random.getFeatureMember(id);
        }
        return this.get(position);
    }

    @Override
    public SimpleFeature removeFeatureMember(String id) {
        int position = this.index.indexOf(this.ff.featureId(id));
        if (position == -1) {
            throw new NoSuchElementException(id);
        }
        if (this.collection instanceof RandomFeatureAccess) {
            RandomFeatureAccess random = (RandomFeatureAccess)this.collection;
            if (this.index != null) {
                this.index.remove(id);
            }
            return random.removeFeatureMember(id);
        }
        return this.remove(position);
    }

    public SimpleFeature remove(int position) {
        if (this.collection instanceof RandomFeatureAccess) {
            RandomFeatureAccess random = (RandomFeatureAccess)this.collection;
            FeatureId fid = this.index().get(position);
            return random.removeFeatureMember(fid.getID());
        }
        Iterator<SimpleFeature> it = this.iterator();
        try {
            int i = 0;
            while (it.hasNext()) {
                SimpleFeature feature = it.next();
                if (i == position) {
                    this.collection.remove(feature);
                    SimpleFeature simpleFeature = feature;
                    return simpleFeature;
                }
                ++i;
            }
            throw new IndexOutOfBoundsException();
        }
        finally {
            this.close(it);
        }
    }

    @Override
    public Iterator<SimpleFeature> openIterator() {
        return new SortedIteratory();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SortedIteratory
    implements Iterator<SimpleFeature> {
        Iterator<FeatureId> iterator;
        String id;

        private SortedIteratory() {
            this.iterator = SubFeatureList.this.index().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator != null && this.iterator.hasNext();
        }

        @Override
        public SimpleFeature next() {
            FeatureId fid = this.iterator.next();
            this.id = fid.getID();
            return SubFeatureList.this.getFeatureMember(this.id);
        }

        @Override
        public void remove() {
            SubFeatureList.this.removeFeatureMember(this.id);
        }
    }
}

