/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.harmonization.occurrence.impl.model.db;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class Utils {
    public static String toJSon(ResultSet resultSet, Long count) throws SQLException {
        StringBuilder json = new StringBuilder();
        json.append("{\"data\":[");
        ResultSetMetaData metaData = resultSet.getMetaData();
        int numberOfColumns = metaData.getColumnCount();
        int row = 0;
        while (resultSet.next()) {
            if (row > 0) {
                json.append(",{");
            } else {
                json.append('{');
            }
            for (int column = 1; column <= numberOfColumns; ++column) {
                if (column > 1) {
                    json.append(',');
                }
                json.append(Utils.quote(metaData.getColumnName(column)));
                json.append(':');
                json.append(Utils.quote(resultSet.getString(column)));
            }
            json.append('}');
            ++row;
        }
        json.append("],\"totalcount\":");
        json.append(count);
        json.append("}");
        return json.toString();
    }

    protected static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }
}

