/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.api;

import gr.i2s.fishgrowth.model.Scenario;
import gr.i2s.fishgrowth.model.ScenarioFull;
import java.io.Serializable;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.data.simulfishgrowthdata.api.ScenarioUtil;
import org.gcube.data.simulfishgrowthdata.util.HibernateUtil;
import org.hibernate.Query;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/ScenarioFull")
public class ScenarioFullUtil {
    private static final String _GET_ALL_ON_OWNERID = "FROM gr.i2s.fishgrowth.model.ScenarioFull s WHERE s.ownerId = :ownerid ORDER BY s.designation ASC";
    private static final String _GET_ALL_ON_OWNERID_COUNT = "SELECT count(*) FROM gr.i2s.fishgrowth.model.ScenarioFull s WHERE s.ownerId = :ownerid";
    private static final Logger logger = LoggerFactory.getLogger(ScenarioFullUtil.class);

    @PUT
    @Consumes(value={"application/json"})
    public Response add(ScenarioFull scenarioFull) throws Exception {
        return new ScenarioUtil().add(new Scenario((Scenario)scenarioFull));
    }

    @POST
    @Consumes(value={"application/json"})
    public Response update(ScenarioFull scenarioFull) throws Exception {
        return new ScenarioUtil().update(new Scenario((Scenario)scenarioFull));
    }

    @DELETE
    @Path(value="/{id}")
    public Response delete(@PathParam(value="id") Long id) throws Exception {
        return new ScenarioUtil().delete(id);
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public ScenarioFull getScenarioFull(@PathParam(value="id") Long id) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            ScenarioFull scenarioFull = (ScenarioFull)session.get(ScenarioFull.class, (Serializable)id);
            session.getTransaction().commit();
            ScenarioFull scenarioFull2 = scenarioFull;
            return scenarioFull2;
        }
        catch (Exception e) {
            logger.error(String.format("Could not retrieve full scenario for [%s]", id), (Throwable)e);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        finally {
            HibernateUtil.closeSession((Session)session);
        }
    }

    @GET
    @Path(value="/all/{ownerId}/{start}/{end}")
    public List<?> getScenarioFulls(@PathParam(value="ownerId") String ownerId, @PathParam(value="start") Integer start, @PathParam(value="end") Integer end) throws Exception {
        List list;
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("reading %s for %s start %s end %s", "ScenarioFull", ownerId, start, end));
        }
        Session session = null;
        try {
            logger.trace(String.format("start getScenarioFulls with ownerid [%s]", ownerId));
            session = HibernateUtil.openSession();
            logger.trace(String.format("session [%s]", session));
            session.beginTransaction();
            Query q = session.createQuery(_GET_ALL_ON_OWNERID).setParameter("ownerid", (Object)ownerId);
            if (start > 0) {
                q.setFirstResult(start.intValue());
            }
            if (end > 0) {
                if (end < start) {
                    end = start + 1;
                }
                q.setMaxResults(end - start);
            }
            List list2 = q.list();
            session.getTransaction().commit();
            logger.trace(String.format("return ScenarioFulls %s", list2));
            list = list2;
        }
        catch (Exception e) {
            try {
                logger.error(String.format("Could not retrieve full scenarios for ownerid[%s]", ownerId), (Throwable)e);
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession((Session)session);
        return list;
    }

    @GET
    @Path(value="/all/{ownerId}")
    public List<?> getScenarioFulls(@PathParam(value="ownerId") String ownerId) throws Exception {
        List list;
        Session session = null;
        try {
            logger.trace(String.format("start getScenarioFulls with ownerid [%s]", ownerId));
            session = HibernateUtil.openSession();
            logger.trace(String.format("session [%s]", session));
            session.beginTransaction();
            Query q = session.createQuery(_GET_ALL_ON_OWNERID).setParameter("ownerid", (Object)ownerId);
            List list2 = q.list();
            session.getTransaction().commit();
            logger.trace(String.format("return ScenarioFulls %s", list2));
            list = list2;
        }
        catch (Exception e) {
            try {
                logger.error(String.format("Could not retrieve full scenarios for ownerid[%s]", ownerId), (Throwable)e);
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession((Session)session);
        return list;
    }

    @GET
    @Path(value="/count/{ownerId}")
    public int getScenarioFullCount(@PathParam(value="ownerId") String ownerId) throws Exception {
        int n;
        Session session = null;
        try {
            logger.trace(String.format("start getScenarioFullCount with ownerid [%s]", ownerId));
            session = HibernateUtil.openSession();
            logger.trace(String.format("session [%s]", session));
            session.beginTransaction();
            Query q = session.createQuery(_GET_ALL_ON_OWNERID_COUNT).setParameter("ownerid", (Object)ownerId);
            Number count = (Number)q.uniqueResult();
            session.getTransaction().commit();
            logger.trace(String.format("return count %s", count));
            n = count.intValue();
        }
        catch (Exception e) {
            try {
                logger.error(String.format("Could not retrieve full scenario count for ownerid[%s]", ownerId), (Throwable)e);
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession((Session)session);
        return n;
    }

    @GET
    @Path(value="/execute/{id}")
    @Produces(value={"application/json"})
    public Scenario executeScenario(@PathParam(value="id") Long id) throws Exception {
        return new ScenarioUtil().executeScenario(id);
    }
}

