/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.api;

import gr.i2s.fishgrowth.model.Scenario;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.data.simulfishgrowthdata.calc.ConsumptionScenarioExecutor;
import org.gcube.data.simulfishgrowthdata.calc.ScenarioExecutor;
import org.gcube.data.simulfishgrowthdata.util.HibernateUtil;
import org.hibernate.Query;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/Scenario")
public class ScenarioUtil {
    private static final String _GET_ALL_ON_OWNERID = "FROM gr.i2s.fishgrowth.model.Scenario s WHERE s.ownerId = :ownerid ORDER BY s.designation ASC";
    private static final Logger logger = LoggerFactory.getLogger(ScenarioUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/json"})
    public Response add(Scenario scenario) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            session.save((Object)scenario);
            session.flush();
            session.getTransaction().commit();
            Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)scenario.getId()).build();
            return response;
        }
        catch (Exception e) {
            logger.error(String.format("Could not add scenario [%s]", scenario), (Throwable)e);
            Response response = Response.status((int)422).entity((Object)e).build();
            return response;
        }
        finally {
            HibernateUtil.closeSession((Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/json"})
    public Response update(Scenario scenario) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            session.update((Object)scenario);
            session.flush();
            session.getTransaction().commit();
            Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)scenario).build();
            return response;
        }
        catch (Exception e) {
            logger.error(String.format("Could not update scenario [%s]", scenario), (Throwable)e);
            Response response = Response.status((int)422).entity((Object)e).build();
            return response;
        }
        finally {
            HibernateUtil.closeSession((Session)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/{id}")
    public Response delete(@PathParam(value="id") Long id) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            Scenario scenario = (Scenario)session.get(Scenario.class, (Serializable)id);
            if (scenario != null) {
                session.delete((Object)scenario);
                session.flush();
            }
            session.getTransaction().commit();
            Response response = Response.status((Response.Status)Response.Status.OK).build();
            return response;
        }
        catch (Exception e) {
            logger.error(String.format("Could not delete scenario [%s]", id), (Throwable)e);
            Response response = Response.status((int)422).entity((Object)e).build();
            return response;
        }
        finally {
            HibernateUtil.closeSession((Session)session);
        }
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Scenario getScenario(@PathParam(value="id") Long id) throws Exception {
        Session session = null;
        try {
            session = HibernateUtil.openSession();
            session.beginTransaction();
            Scenario scenario = (Scenario)session.get(Scenario.class, (Serializable)id);
            session.getTransaction().commit();
            Scenario scenario2 = scenario;
            return scenario2;
        }
        catch (Exception e) {
            logger.error(String.format("Could not retrieve scenario [%s]", id), (Throwable)e);
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        finally {
            HibernateUtil.closeSession((Session)session);
        }
    }

    @GET
    @Path(value="/all/{ownerId}")
    public List<?> getScenarios(@PathParam(value="ownerId") String ownerId) throws Exception {
        List list;
        Session session = null;
        try {
            logger.trace(String.format("start getScenarios", new Object[0]));
            session = HibernateUtil.openSession();
            logger.trace(String.format("session [%s]", session));
            session.beginTransaction();
            Query q = session.createQuery(_GET_ALL_ON_OWNERID).setParameter("ownerid", (Object)ownerId);
            List list2 = q.list();
            session.getTransaction().commit();
            logger.trace(String.format("return Scenarios %s", list2));
            list = list2;
        }
        catch (Exception e) {
            try {
                logger.error(String.format("Could not retrieve scenarios for ownerid [%s]", ownerId), (Throwable)e);
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession((Session)session);
        return list;
    }

    @GET
    @Path(value="/execute/{id}")
    @Produces(value={"application/json"})
    public Scenario executeScenario(@PathParam(value="id") Long id) throws Exception {
        try {
            Scenario scenario = this.getScenario(id);
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("For [%s] I loaded [%s]", id, scenario));
            }
            new ScenarioExecutor(scenario).run();
            return scenario;
        }
        catch (Exception e) {
            logger.error(String.format("Could not execute scenario [%s]", id), (Throwable)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="/execute/consumption/{from}/{to}/{weight}/{count}/{modelid}")
    @Produces(value={"application/json"})
    public String executeConsumptionScenario(@PathParam(value="from") String from, @PathParam(value="to") String to, @PathParam(value="weight") Integer weight, @PathParam(value="count") Integer count, @PathParam(value="modelid") Long modelId) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyMMdd");
        Scenario scenario = new Scenario();
        scenario.setStartDate(df.parse(from));
        scenario.setTargetDate(df.parse(to));
        scenario.setWeight((double)weight.intValue() / 100.0);
        scenario.setFishNo(count.intValue());
        scenario.setModelerId(modelId.longValue());
        ConsumptionScenarioExecutor executor = new ConsumptionScenarioExecutor(scenario);
        executor.run();
        return scenario.getResultsGraphData();
    }
}

