/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.gbifplugin;

import java.util.Collections;
import java.util.Set;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.data.spd.gbifplugin.capabilities.OccurrencesCapabilityImpl;
import org.gcube.data.spd.gbifplugin.search.ResultItemSearch;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.RepositoryInfo;
import org.gcube.data.spd.model.exceptions.StreamBlockingException;
import org.gcube.data.spd.model.exceptions.StreamException;
import org.gcube.data.spd.model.products.ResultItem;
import org.gcube.data.spd.model.util.Capabilities;
import org.gcube.data.spd.plugin.fwk.AbstractPlugin;
import org.gcube.data.spd.plugin.fwk.capabilities.OccurrencesCapability;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GBIFPlugin
extends AbstractPlugin {
    private static Logger logger = LoggerFactory.getLogger(GBIFPlugin.class);
    private OccurrencesCapability occurrencesCapability;
    private String baseURL;

    public void initialize(ServiceEndpoint resource) throws Exception {
        this.baseURL = ((ServiceEndpoint.AccessPoint)resource.profile().accessPoints().iterator().next()).address();
        this.occurrencesCapability = new OccurrencesCapabilityImpl(this.baseURL);
        this.setUseCache(true);
        super.initialize(resource);
    }

    public Set<Capabilities> getSupportedCapabilities() {
        return Collections.singleton(Capabilities.Occurrence);
    }

    public OccurrencesCapability getOccurrencesInterface() {
        return this.occurrencesCapability;
    }

    public String getRepositoryName() {
        return "GBIF";
    }

    public String getDescription() {
        return "A plugin for GBIF interaction";
    }

    public void searchByScientificName(String word, ObjectWriter<ResultItem> writer, Condition ... properties) {
        logger.debug("starting the search for gbifPlugin with word " + word);
        try {
            new ResultItemSearch(this.baseURL, word, properties).search(writer, 200);
        }
        catch (Exception e) {
            logger.debug("searchByScientificName failed", (Throwable)e);
            writer.write((StreamException)new StreamBlockingException("GBIF", word));
        }
    }

    public RepositoryInfo getRepositoryInfo() {
        return new RepositoryInfo("http://www.gbif.org/fileadmin/templates/main/images/logo_leaf.gif", "http://www.gbif.org/", "The Global Biodiversity Information Facility (GBIF) was established by governments in 2001 to encourage free and open access to biodiversity data, via the Internet. Through a global network of countries and organizations, GBIF promotes and facilitates the mobilization, access, discovery and use of information about the occurrence of organisms over time and across the planet");
    }
}

