/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.obisplugin.search;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.exceptions.StreamBlockingException;
import org.gcube.data.spd.model.exceptions.StreamException;
import org.gcube.data.spd.model.products.DataSet;
import org.gcube.data.spd.model.products.Product;
import org.gcube.data.spd.model.products.ResultItem;
import org.gcube.data.spd.model.products.Taxon;
import org.gcube.data.spd.obisplugin.search.DataSetRetreiver;
import org.gcube.data.spd.obisplugin.search.Utils;
import org.gcube.data.spd.obisplugin.search.query.MappingUtils;
import org.gcube.data.spd.obisplugin.search.query.PagedQueryIterator;
import org.gcube.data.spd.obisplugin.search.query.PagedQueryObject;
import org.gcube.data.spd.obisplugin.search.query.QueryByIdentifier;
import org.gcube.data.spd.obisplugin.search.query.QueryCondition;
import org.gcube.data.spd.obisplugin.search.query.QueryCount;
import org.gcube.data.spd.obisplugin.search.query.QueryType;
import org.gcube.data.spd.obisplugin.search.query.ResultType;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultItemSearch {
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
    private static Logger log = LoggerFactory.getLogger(ResultItemSearch.class);
    private List<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
    private String baseURL;
    String searchQuery;

    public ResultItemSearch(String baseURL, String searchQuery, Condition ... conditions) {
        this.baseURL = baseURL;
        this.searchQuery = searchQuery.replaceAll(" ", "%20").trim();
        this.searchQuery = this.searchQuery.substring(0, 1).toUpperCase() + this.searchQuery.substring(1, this.searchQuery.length()).toLowerCase();
        try {
            this.queryConditions = Utils.elaborateConditions(conditions);
        }
        catch (Exception e) {
            log.error("error elaborating conditions", (Throwable)e);
        }
    }

    public void search(ObjectWriter<ResultItem> writer, int limit) {
        PagedQueryObject queryObject = new PagedQueryObject(this.baseURL, ResultType.Occurrence, limit);
        queryObject.setConditions(QueryCondition.cond("scientificname", this.searchQuery));
        queryObject.getConditions().addAll(this.queryConditions);
        try {
            PagedQueryIterator<ResultItem> pagedIterator = new PagedQueryIterator<ResultItem>(queryObject){
                Set<String> alreadyVisited;
                {
                    this.alreadyVisited = new HashSet<String>();
                }

                @Override
                protected ResultItem getObject(Map<String, Object> mappedObject) throws Exception {
                    log.debug("retrieved mapped object");
                    return ResultItemSearch.this.buildResult(mappedObject);
                }

                @Override
                protected boolean useIt(Map<String, Object> mappedObject) {
                    String datasetKey = ((Integer)mappedObject.get("resourceID")).toString();
                    Integer taxonId = (Integer)mappedObject.get("obisID");
                    String key = datasetKey + "|" + taxonId;
                    if (this.alreadyVisited.contains(key)) {
                        return false;
                    }
                    this.alreadyVisited.add(key);
                    return true;
                }
            };
            while (pagedIterator.hasNext() && writer.isAlive()) {
                writer.write(pagedIterator.next());
            }
        }
        catch (Exception e) {
            log.error("error writing resultItems", (Throwable)e);
            writer.write((StreamException)new StreamBlockingException("OBIS"));
        }
    }

    ResultItem buildResult(Map<String, Object> singleObject) throws Exception {
        long start = System.currentTimeMillis();
        Integer taxonId = MappingUtils.getAsInteger(singleObject, "obisID");
        String scientificName = MappingUtils.getAsString(singleObject, "scientificName");
        ResultItem resItem = new ResultItem(taxonId.toString(), scientificName);
        String scientificNameAuthorship = MappingUtils.getAsString(singleObject, "scientificNameAuthorship");
        QueryByIdentifier query = new QueryByIdentifier(this.baseURL, taxonId.toString(), QueryType.Taxon);
        Map<String, Object> singleTaxon = MappingUtils.getObjectMapping(query.build());
        resItem.setScientificNameAuthorship(scientificNameAuthorship);
        resItem.setRank(MappingUtils.getAsString(singleTaxon, "rank_name"));
        resItem.setParent(this.retrieveParentTaxon(MappingUtils.getAsInteger(singleTaxon, "parent_id")));
        DataSet dataset = DataSetRetreiver.get(MappingUtils.getAsInteger(singleObject, "resourceID").toString(), this.baseURL);
        resItem.setDataSet(dataset);
        List<Product> products = this.retrieveProducts(taxonId.toString(), dataset);
        resItem.setProducts(products);
        String credits = "Biodiversity occurrence accessed through OBIS WebService, http://api.iobis.org/, " + format.format(Calendar.getInstance().getTime()) + ")";
        resItem.setCredits(credits);
        log.trace("[Benchmark] time to retrieve ResultItem is " + (System.currentTimeMillis() - start));
        log.debug("found species {} with authorship {}", (Object)scientificName, (Object)scientificNameAuthorship);
        return resItem;
    }

    private Taxon retrieveParentTaxon(Integer parentTaxonId) throws Exception {
        if (parentTaxonId == 0) {
            return null;
        }
        long start = System.currentTimeMillis();
        Integer taxonId = parentTaxonId;
        Taxon previousTaxon = null;
        Taxon taxonToReturn = null;
        do {
            QueryByIdentifier query = new QueryByIdentifier(this.baseURL, taxonId.toString(), QueryType.Taxon);
            Map<String, Object> singleTaxon = MappingUtils.getObjectMapping(query.build());
            Taxon taxon = new Taxon(MappingUtils.getAsInteger(singleTaxon, "id").toString(), MappingUtils.getAsString(singleTaxon, "tname"));
            taxon.setScientificNameAuthorship(MappingUtils.getAsString(singleTaxon, "tauthor"));
            taxon.setRank(MappingUtils.getAsString(singleTaxon, "rank_name"));
            if (previousTaxon != null) {
                previousTaxon.setParent(taxon);
            }
            previousTaxon = taxon;
            taxonId = MappingUtils.getAsInteger(singleTaxon, "parent_id");
            if (taxonToReturn != null) continue;
            taxonToReturn = taxon;
        } while (taxonId > 0);
        log.trace("[Benchmark] time to retrieve taxon is " + (System.currentTimeMillis() - start));
        return taxonToReturn;
    }

    private List<Product> retrieveProducts(String taxonId, DataSet dataset) throws Exception {
        long start = System.currentTimeMillis();
        QueryCount occurrencesQuery = new QueryCount(this.baseURL, ResultType.Occurrence);
        occurrencesQuery.setConditions(QueryCondition.cond("obisid", taxonId), QueryCondition.cond("resourceid", dataset.getId()));
        occurrencesQuery.getConditions().addAll(this.queryConditions);
        String productId = Utils.createProductsKey(Utils.getDataSetAsString(dataset), taxonId, this.queryConditions);
        Product product = new Product(Product.ProductType.Occurrence, productId);
        product.setCount(occurrencesQuery.getCount());
        log.trace("[Benchmark] time to retrieve product is " + (System.currentTimeMillis() - start));
        return Arrays.asList(product);
    }
}

