/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.obisplugin;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.Conditions;
import org.gcube.data.spd.model.RepositoryInfo;
import org.gcube.data.spd.model.products.ResultItem;
import org.gcube.data.spd.model.util.Capabilities;
import org.gcube.data.spd.obisplugin.capabilities.OccurrencesCapabilityImpl;
import org.gcube.data.spd.obisplugin.search.ResultItemSearch;
import org.gcube.data.spd.plugin.fwk.AbstractPlugin;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.capabilities.MappingCapability;
import org.gcube.data.spd.plugin.fwk.capabilities.OccurrencesCapability;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObisPlugin
extends AbstractPlugin {
    protected static final String LOGO_URL = "http://iobis.org/sites/all/themes/corolla/logo.png";
    protected static final String HOME_URL = "http://iobis.org";
    protected static final String DESCRIPTION = "The Ocean Biogeographic information System (OBIS) seeks to absorb, integrate, and assess isolated datasets into a larger, more comprehensive pictures of life in our oceans. The system hopes to stimulate research about our oceans to generate new hypotheses concerning evolutionary processes, species distributions, and roles of organisms in marine systems on a global scale. Created by the Census of Marine Life, OBIS is now part of the Intergovernmental Oceanographic Commission (IOC) of UNESCO, under its International Oceanographic Data and Information Exchange (IODE) programme.";
    protected static final RepositoryInfo REPOSITORY_INFO = new RepositoryInfo("http://iobis.org/sites/all/themes/corolla/logo.png", "http://iobis.org", "The Ocean Biogeographic information System (OBIS) seeks to absorb, integrate, and assess isolated datasets into a larger, more comprehensive pictures of life in our oceans. The system hopes to stimulate research about our oceans to generate new hypotheses concerning evolutionary processes, species distributions, and roles of organisms in marine systems on a global scale. Created by the Census of Marine Life, OBIS is now part of the Intergovernmental Oceanographic Commission (IOC) of UNESCO, under its International Oceanographic Data and Information Exchange (IODE) programme.");
    protected static final String ENTRY_POINT_NAME = "jdbc";
    protected static Logger logger = LoggerFactory.getLogger(ObisPlugin.class);
    protected OccurrencesCapabilityImpl occurrencesInterface;
    protected static final SimpleDateFormat sdf = new SimpleDateFormat();
    private String baseUrl = "http://api.iobis.org/";

    public Set<Capabilities> getSupportedCapabilities() {
        return new HashSet<Capabilities>(){
            {
                this.add(Capabilities.Occurrence);
            }
        };
    }

    public String getRepositoryName() {
        return "OBIS";
    }

    public String getDescription() {
        return "A plugin for OBIS interaction";
    }

    public void initialize(ServiceEndpoint resource) throws Exception {
        this.setUseCache(true);
        this.occurrencesInterface = new OccurrencesCapabilityImpl(this.baseUrl);
    }

    public void shutdown() throws Exception {
    }

    public Set<Conditions> getSupportedProperties() {
        return new HashSet<Conditions>(){
            {
                this.add(Conditions.DATE);
                this.add(Conditions.COORDINATE);
            }
        };
    }

    public void update(ServiceEndpoint resource) throws Exception {
    }

    public void searchByScientificName(String searchTerm, ObjectWriter<ResultItem> writer, Condition ... properties) {
        logger.debug("starting the search for obisPlugin word: " + searchTerm);
        try {
            new ResultItemSearch(this.baseUrl, searchTerm, properties).search(writer, 50);
        }
        catch (Exception e) {
            logger.debug("searchByScientificName failed", (Throwable)e);
        }
    }

    public MappingCapability getMappingInterface() {
        return null;
    }

    public OccurrencesCapability getOccurrencesInterface() {
        return this.occurrencesInterface;
    }

    protected String getObisCredits() {
        StringBuilder credits = new StringBuilder("Intergovernmental Oceanographic Commission (IOC) of UNESCO. The Ocean Biogeographic Information System. Web. http://www.iobis.org. (Consulted on ");
        credits.append(sdf.format(Calendar.getInstance().getTime()));
        credits.append(")");
        return credits.toString();
    }

    public ClassificationCapability getClassificationInterface() {
        return null;
    }

    public RepositoryInfo getRepositoryInfo() {
        return REPOSITORY_INFO;
    }
}

