/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.parser;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.gcube.data.spd.parser.DarwinSimpleRecord;
import org.gcube.data.spd.parser.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NodeList;

public class RecordsIterator
implements Iterator<DarwinSimpleRecord> {
    static Logger logger = LoggerFactory.getLogger(RecordsIterator.class);
    public NodeList sum = null;
    public int start = 0;
    public int count = 0;
    public String pathUrl;
    public String filter;
    public String baseurl;
    public String model;
    public int limit;
    public XMLEventReader eventReader = null;
    public XMLInputFactory ifactory = null;
    public InputStream inputStream = null;
    private boolean complete;

    public RecordsIterator(String baseurl, String filter, String model, int limit, boolean complete) {
        this.baseurl = baseurl;
        this.filter = filter;
        this.model = model;
        this.limit = limit;
        this.complete = complete;
        this.pathUrl = baseurl + "?op=search&start=" + this.start + "&limit=" + limit + "&filter=" + filter + "&model=" + model;
    }

    @Override
    public DarwinSimpleRecord next() {
        DarwinSimpleRecord record = null;
        try {
            record = new DarwinSimpleRecord(this.eventReader, this.complete);
        }
        catch (Exception e) {
            logger.error("Error creating DarwinCore Record from: " + this.pathUrl, (Throwable)e);
        }
        return record;
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.getRecord()) {
                return true;
            }
            if (this.checkSummary()) {
                ++this.count;
                this.pathUrl = this.baseurl + "?op=search&start=" + this.limit * this.count + "&limit=" + this.limit + "&filter=" + this.filter + "&model=" + this.model;
                this.iterator();
                return this.hasNext();
            }
        }
        catch (XMLStreamException e) {
            logger.error("Error getting more records from: " + this.pathUrl, (Throwable)e);
        }
        return false;
    }

    private boolean checkSummary() throws XMLStreamException {
        while (this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.nextEvent();
            if (!Utils.checkStartElement(event, "summary")) continue;
            StartElement element = (StartElement)event;
            Iterator<Attribute> iterator = element.getAttributes();
            while (iterator.hasNext()) {
                int next;
                Attribute attribute = iterator.next();
                QName att = attribute.getName();
                if (!att.toString().equals("next") || (next = Integer.parseInt(attribute.getValue())) <= 0) continue;
                return true;
            }
            break block0;
        }
        return false;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public RecordsIterator iterator() {
        int numberOfRetries = 5;
        long timeToWait = 1000L;
        for (int i = 0; i < 5; ++i) {
            try {
                this.inputStream = URI.create(this.pathUrl).toURL().openStream();
                this.ifactory = XMLInputFactory.newInstance();
                this.eventReader = this.ifactory.createXMLEventReader(this.inputStream);
                break;
            }
            catch (XMLStreamException e) {
                logger.error("XMLStreamException in " + this.pathUrl, (Throwable)e);
                continue;
            }
            catch (FileNotFoundException e) {
                logger.error("FileNotFoundException: " + this.pathUrl, (Throwable)e);
                continue;
            }
            catch (MalformedURLException e) {
                logger.error("MalformedURLException: " + this.pathUrl, (Throwable)e);
                continue;
            }
            catch (IOException e) {
                logger.error("IOException, url: " + this.pathUrl, (Throwable)e);
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this;
    }

    public boolean getRecord() throws XMLStreamException {
        XMLEvent event;
        while (this.eventReader.hasNext() && !Utils.checkStartElement(event = this.eventReader.nextEvent(), "DarwinRecord")) {
            if (Utils.checkEndElement(event, "DarwinRecordSet")) {
                return false;
            }
            if (!Utils.checkEndElement(event, "response")) continue;
            logger.info("No results at url: " + this.pathUrl);
            return false;
        }
        return true;
    }
}

