/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.agent.impl.handlers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.net.io.CopyStreamEvent;
import org.apache.commons.net.io.CopyStreamListener;
import org.apache.commons.vfs2.FileObject;
import org.gcube.datatransfer.agent.impl.context.ServiceContext;
import org.gcube.datatransfer.agent.impl.handlers.Handler;
import org.gcube.datatransfer.agent.impl.handlers.TransferHandler;
import org.gcube.datatransfer.agent.impl.jdo.TransferObject;
import org.gcube.datatransfer.agent.impl.utils.TransferUtils;
import org.gcube.datatransfer.agent.stubs.datatransferagent.DestData;
import org.gcube.datatransfer.agent.stubs.datatransferagent.PostProcessType;
import org.gcube.datatransfer.agent.stubs.datatransferagent.TransferType;
import org.gcube.datatransfer.common.outcome.TransferStatus;

public class LocalFileTransferAsyncHandler
extends TransferHandler {
    public static int bufferSize = 1024000;
    private ExecutorService pool;
    CopyStreamListener listener = new CopyStreamListener(){

        public void bytesTransferred(long arg0, int arg1, long arg2) {
            try {
                ServiceContext.getContext().getDbManager().updateTransferObjectInfo(LocalFileTransferAsyncHandler.this.transferId, arg1);
            }
            catch (Exception e) {
                LocalFileTransferAsyncHandler.this.logger.error((Object)"Error updating DB");
            }
        }

        public void bytesTransferred(CopyStreamEvent arg0) {
        }
    };

    public LocalFileTransferAsyncHandler(String[] inputFiles, String outPath, String transferId, TransferType type, DestData data, int startIndex, int endIndex) {
        this.inputFiles = inputFiles;
        this.timeout = data.getOutUri().getOptions().getTransferTimeout();
        this.outPath = outPath;
        this.transferId = transferId;
        this.transferType = type;
        this.destData = data;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.pool = Executors.newFixedThreadPool(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        for (int i = this.startIndex; i <= this.endIndex; ++i) {
            long startTime = 0L;
            TransferObject transferObj = null;
            try {
                transferObj = TransferUtils.createTransferObjectJDO(this.transferId, this.transferType);
                transferObj.setSourceURI(this.inputFiles[i]);
                FileObject inputFile = TransferUtils.prepareFileObject(this.inputFiles[i]);
                transferObj.setSize(inputFile.getContent().getSize());
                String outputFile = inputFile.getName().getBaseName();
                String relativeOutputFile = this.outPath + File.separator + outputFile;
                this.logger.debug((Object)("Relative Output file " + relativeOutputFile));
                FileObject absoluteOutputFile = ServiceContext.getContext().getLocalFSManager().resolveFile(relativeOutputFile);
                FileObject absolutePath = ServiceContext.getContext().getLocalFSManager().resolveFile(this.outPath);
                absolutePath.createFolder();
                if (absoluteOutputFile.exists() && !this.destData.getOutUri().getOptions().isOverwrite()) {
                    String msg = "the file represented by the URL " + inputFile.getURL().toString() + " cannot be copied cause a file with the same name already exists";
                    this.logger.error((Object)msg);
                    throw new Exception(msg);
                }
                transferObj.setDestURI(absoluteOutputFile.getName().getPath());
                this.logger.debug((Object)("Copying file from URL " + inputFile.getURL() + " to : " + absoluteOutputFile.getName().getPath()));
                startTime = System.currentTimeMillis();
                boolean terminate = false;
                InputStream sourceFileIn = inputFile.getContent().getInputStream();
                OutputStream destinationFileOut = absoluteOutputFile.getContent().getOutputStream();
                Handler handler = new Handler(sourceFileIn, destinationFileOut, inputFile.getContent().getSize(), this.listener);
                try {
                    this.pool.execute(handler);
                    this.pool.shutdown();
                }
                catch (Exception e) {
                    this.pool.shutdownNow();
                    absoluteOutputFile.delete();
                    throw new Exception("Error while executing the transfer");
                }
                terminate = this.pool.awaitTermination(this.timeout, TimeUnit.MILLISECONDS);
                if (terminate) {
                    PostProcessType[] postProcesses = this.destData.getOutUri().getOptions().getPostProcess();
                    if (postProcesses != null) {
                        for (PostProcessType process : postProcesses) {
                            TransferUtils.applyPostProcess(process, absoluteOutputFile, absolutePath, this.destData.getOutUri().getOptions().getConversionType());
                        }
                    }
                    transferObj.setStatus(TransferStatus.DONE.name());
                    transferObj.setOutcome("File succesfully copied to " + absoluteOutputFile);
                    this.logger.debug((Object)("File succesfully copied to " + absoluteOutputFile));
                    ServiceContext.getContext().getDbManager().addTransferObjectCompleted(this.transferId);
                    continue;
                }
                String msg = "Transfer aborted because timeout has elapsed";
                this.logger.error((Object)msg);
                absoluteOutputFile.delete();
                throw new Exception(msg);
            }
            catch (Exception e) {
                e.printStackTrace();
                transferObj.setStatus(TransferStatus.FAILED.name());
                transferObj.setOutcome(e.toString());
                this.errorHappened = true;
                continue;
            }
            finally {
                long endTime = System.currentTimeMillis();
                transferObj.setTransferTime(endTime - startTime);
                this.transferObjs.add(transferObj);
            }
        }
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[bufferSize];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static void copyWithHttpClient(String inputURI, String outPutUri) throws Exception {
        HttpClient client = new HttpClient();
        GetMethod get = new GetMethod(inputURI);
        int status = client.executeMethod((HttpMethod)get);
        InputStream is = get.getResponseBodyAsStream();
        FileOutputStream fos = new FileOutputStream(outPutUri);
        LocalFileTransferAsyncHandler.copyLarge(is, fos);
        fos.close();
    }
}

