/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.model;

import java.beans.ConstructorProperties;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.transfer.model.options.DirectTransferOptions;
import org.gcube.data.transfer.model.options.HttpDownloadOptions;
import org.gcube.data.transfer.model.options.TransferOptions;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class TransferCapabilities {
    @XmlID
    private String hostName;
    @XmlElementWrapper
    @XmlElementRefs(value={@XmlElementRef(type=DirectTransferOptions.class), @XmlElementRef(type=HttpDownloadOptions.class)})
    private Set<TransferOptions> availableMeans;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.availableMeans != null) {
            for (TransferOptions opt : this.availableMeans) {
                result = 31 * result + (opt == null ? 0 : opt.hashCode());
            }
        }
        result = 31 * result + (this.hostName == null ? 0 : this.hostName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransferCapabilities other = (TransferCapabilities)obj;
        if (this.availableMeans == null || this.availableMeans.isEmpty()) {
            if (other.availableMeans != null && !other.availableMeans.isEmpty()) {
                return false;
            }
            if (this.availableMeans != null && !this.availableMeans.isEmpty()) {
                if (other.availableMeans == null || other.availableMeans.isEmpty()) {
                    return false;
                }
                if (this.availableMeans.size() != other.availableMeans.size()) {
                    return false;
                }
                for (TransferOptions opt : this.availableMeans) {
                    if (other.availableMeans.contains(opt)) continue;
                    return false;
                }
            }
        }
        return !(this.hostName == null ? other.hostName != null : !this.hostName.equals(other.hostName));
    }

    public String getHostName() {
        return this.hostName;
    }

    public Set<TransferOptions> getAvailableMeans() {
        return this.availableMeans;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setAvailableMeans(Set<TransferOptions> availableMeans) {
        this.availableMeans = availableMeans;
    }

    public String toString() {
        return "TransferCapabilities(hostName=" + this.getHostName() + ", availableMeans=" + this.getAvailableMeans() + ")";
    }

    public TransferCapabilities() {
    }

    @ConstructorProperties(value={"hostName", "availableMeans"})
    public TransferCapabilities(String hostName, Set<TransferOptions> availableMeans) {
        this.hostName = hostName;
        this.availableMeans = availableMeans;
    }
}

