/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.model;

import java.beans.ConstructorProperties;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.transfer.model.TransferRequest;
import org.gcube.data.transfer.model.utils.DateWrapper;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class TransferTicket
extends TransferRequest {
    @XmlElement
    private Status status;
    @XmlElement
    private long transferredBytes;
    @XmlElement
    private double percent;
    @XmlElement
    private long averageTransferSpeed;
    @XmlElement
    private DateWrapper submissionTime;
    @XmlElement
    private String destinationFileName;
    @XmlElement
    private String message;

    public TransferTicket(TransferRequest request, Status status, long transferredBytes, double percent, long averageTransferSpeed, DateWrapper submissionTime, String destinationFileName, String message) {
        super(request.getId(), request.getSettings(), request.getDestinationSettings(), request.getPluginInvocations());
        this.status = status;
        this.transferredBytes = transferredBytes;
        this.percent = percent;
        this.averageTransferSpeed = averageTransferSpeed;
        this.submissionTime = submissionTime;
        this.destinationFileName = destinationFileName;
    }

    public TransferTicket(TransferRequest request) {
        super(request.getId(), request.getSettings(), request.getDestinationSettings(), request.getPluginInvocations());
        this.status = Status.PENDING;
        this.transferredBytes = 0L;
        this.averageTransferSpeed = 0L;
        this.destinationFileName = "/dev/null";
        this.percent = 0.0;
        this.submissionTime = DateWrapper.getInstance();
        this.message = "";
    }

    public Status getStatus() {
        return this.status;
    }

    public long getTransferredBytes() {
        return this.transferredBytes;
    }

    public double getPercent() {
        return this.percent;
    }

    public long getAverageTransferSpeed() {
        return this.averageTransferSpeed;
    }

    public DateWrapper getSubmissionTime() {
        return this.submissionTime;
    }

    public String getDestinationFileName() {
        return this.destinationFileName;
    }

    public String getMessage() {
        return this.message;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setTransferredBytes(long transferredBytes) {
        this.transferredBytes = transferredBytes;
    }

    public void setPercent(double percent) {
        this.percent = percent;
    }

    public void setAverageTransferSpeed(long averageTransferSpeed) {
        this.averageTransferSpeed = averageTransferSpeed;
    }

    public void setSubmissionTime(DateWrapper submissionTime) {
        this.submissionTime = submissionTime;
    }

    public void setDestinationFileName(String destinationFileName) {
        this.destinationFileName = destinationFileName;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String toString() {
        return "TransferTicket(status=" + (Object)((Object)this.getStatus()) + ", transferredBytes=" + this.getTransferredBytes() + ", percent=" + this.getPercent() + ", averageTransferSpeed=" + this.getAverageTransferSpeed() + ", submissionTime=" + this.getSubmissionTime() + ", destinationFileName=" + this.getDestinationFileName() + ", message=" + this.getMessage() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransferTicket)) {
            return false;
        }
        TransferTicket other = (TransferTicket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        if (this.getTransferredBytes() != other.getTransferredBytes()) {
            return false;
        }
        if (Double.compare(this.getPercent(), other.getPercent()) != 0) {
            return false;
        }
        if (this.getAverageTransferSpeed() != other.getAverageTransferSpeed()) {
            return false;
        }
        DateWrapper this$submissionTime = this.getSubmissionTime();
        DateWrapper other$submissionTime = other.getSubmissionTime();
        if (this$submissionTime == null ? other$submissionTime != null : !((Object)this$submissionTime).equals(other$submissionTime)) {
            return false;
        }
        String this$destinationFileName = this.getDestinationFileName();
        String other$destinationFileName = other.getDestinationFileName();
        if (this$destinationFileName == null ? other$destinationFileName != null : !this$destinationFileName.equals(other$destinationFileName)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransferTicket;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 0 : ((Object)((Object)$status)).hashCode());
        long $transferredBytes = this.getTransferredBytes();
        result = result * 59 + (int)($transferredBytes >>> 32 ^ $transferredBytes);
        long $percent = Double.doubleToLongBits(this.getPercent());
        result = result * 59 + (int)($percent >>> 32 ^ $percent);
        long $averageTransferSpeed = this.getAverageTransferSpeed();
        result = result * 59 + (int)($averageTransferSpeed >>> 32 ^ $averageTransferSpeed);
        DateWrapper $submissionTime = this.getSubmissionTime();
        result = result * 59 + ($submissionTime == null ? 0 : ((Object)$submissionTime).hashCode());
        String $destinationFileName = this.getDestinationFileName();
        result = result * 59 + ($destinationFileName == null ? 0 : $destinationFileName.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 0 : $message.hashCode());
        return result;
    }

    public TransferTicket() {
    }

    @ConstructorProperties(value={"status", "transferredBytes", "percent", "averageTransferSpeed", "submissionTime", "destinationFileName", "message"})
    public TransferTicket(Status status, long transferredBytes, double percent, long averageTransferSpeed, DateWrapper submissionTime, String destinationFileName, String message) {
        this.status = status;
        this.transferredBytes = transferredBytes;
        this.percent = percent;
        this.averageTransferSpeed = averageTransferSpeed;
        this.submissionTime = submissionTime;
        this.destinationFileName = destinationFileName;
        this.message = message;
    }

    @XmlEnum
    public static enum Status {
        PENDING,
        WAITING,
        TRANSFERRING,
        SUCCESS,
        ERROR,
        STOPPED;

    }
}

