/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.service.transfers;

import java.util.UUID;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.data.transfer.model.TransferRequest;
import org.gcube.data.transfer.model.TransferTicket;
import org.gcube.data.transfer.service.transfers.engine.RequestManager;
import org.gcube.data.transfer.service.transfers.engine.TicketManager;
import org.gcube.data.transfer.service.transfers.engine.faults.TicketNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="Requests")
public class Requests {
    private static final Logger log = LoggerFactory.getLogger(Requests.class);
    @Inject
    RequestManager requests;
    @Inject
    TicketManager tickets;

    @POST
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml"})
    public TransferTicket submitRequest(@NotNull TransferRequest theRequest) {
        log.debug("Received transfer request : " + theRequest);
        theRequest.setId(UUID.randomUUID().toString());
        boolean inserted = this.requests.put(theRequest);
        log.debug("Successfully inserted " + inserted);
        if (!inserted) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        try {
            return this.tickets.get(theRequest.getId());
        }
        catch (TicketNotFoundException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

