/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.scheduler.is;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jdo.Extent;
import javax.jdo.Query;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERuntimeResourceQuery;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.resources.runtime.AccessPoint;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.datatransfer.scheduler.db.DataTransferDBManager;
import org.gcube.datatransfer.scheduler.db.model.Agent;
import org.gcube.datatransfer.scheduler.db.model.AgentStatistics;
import org.gcube.datatransfer.scheduler.db.model.DataSource;
import org.gcube.datatransfer.scheduler.db.model.DataStorage;

public class ISManager {
    private static final UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();
    public String type;
    public DataTransferDBManager dbManager;
    public String scope;
    GCUBELog logger = new GCUBELog(ISManager.class);

    public ISManager(String type, DataTransferDBManager dbManager, String scope) {
        this.dbManager = dbManager;
        this.scope = scope;
        this.type = type;
    }

    public void updateObjsInDB() {
        int newContentInDB = 0;
        int oldContentInDB = 0;
        String typeOfISManager = "";
        List<String> resultsFromIS = this.getObjsFromIS();
        if (resultsFromIS == null) {
            return;
        }
        String delimiter = "--";
        for (String tmpResult : resultsFromIS) {
            String idOfObjInDB;
            String[] tmpSplitResult = tmpResult.split(delimiter);
            String resultIdOfIS = tmpSplitResult[0];
            if (this.checkIfObjExistsInDB_ById(resultIdOfIS) != null) {
                idOfObjInDB = this.checkIfObjExistsInDB_ById(resultIdOfIS);
                this.updateSpecificObjInDB(tmpSplitResult, idOfObjInDB);
                continue;
            }
            idOfObjInDB = this.setObjToDB(tmpSplitResult);
            if (idOfObjInDB == null) {
                this.logger.debug((Object)"ISManager - updateObjsInDB - Error in storing the new obj in DB");
                continue;
            }
            if (idOfObjInDB.compareTo("lessParameters") == 0) continue;
            ++newContentInDB;
            if (this.type.compareTo("Agent") != 0) continue;
            Extent resultExtentSt = null;
            boolean exists = false;
            resultExtentSt = this.dbManager.getPersistenceManager().getExtent(AgentStatistics.class, true);
            for (AgentStatistics obj : resultExtentSt) {
                if (obj.getAgentIdOfIS().compareTo(resultIdOfIS) != 0) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            AgentStatistics agentStatistics = new AgentStatistics();
            agentStatistics.setAgentIdOfIS(resultIdOfIS);
            try {
                this.dbManager.storeAgentStatistics(agentStatistics);
            }
            catch (Exception e) {
                this.logger.error((Object)"ISManager.setObjToDB - Exception in storing the AgentStatistics");
                e.printStackTrace();
            }
        }
        try {
            Extent resultExtent = null;
            if (this.type.compareTo("Agent") == 0) {
                resultExtent = this.dbManager.getPersistenceManager().getExtent(Agent.class, true);
            } else if (this.type.compareTo("DataSource") == 0) {
                resultExtent = this.dbManager.getPersistenceManager().getExtent(DataSource.class, true);
            } else if (this.type.compareTo("DataStorage") == 0) {
                resultExtent = this.dbManager.getPersistenceManager().getExtent(DataStorage.class, true);
            } else {
                this.logger.debug((Object)"ISManager - updateObjsInDB - Error - there is no class with this name");
            }
            Iterator iter = resultExtent.iterator();
            String idOfObjInDB = null;
            String idOfObjOfIS = null;
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (this.type.compareTo("Agent") == 0) {
                    idOfObjInDB = ((Agent)obj).getAgentId();
                    idOfObjOfIS = ((Agent)obj).getAgentIdOfIS();
                } else if (this.type.compareTo("DataSource") == 0) {
                    idOfObjInDB = ((DataSource)obj).getDataSourceId();
                    idOfObjOfIS = ((DataSource)obj).getDataSourceIdOfIS();
                } else if (this.type.compareTo("DataStorage") == 0) {
                    idOfObjInDB = ((DataStorage)obj).getDataStorageId();
                    idOfObjOfIS = ((DataStorage)obj).getDataStorageIdOfIS();
                } else {
                    this.logger.debug((Object)"ISManager - updateObjsInDB - Error - there is no class with this name");
                }
                if (idOfObjInDB.endsWith("datastorageSM") || this.checkIfObjExistsInIS_ById(idOfObjOfIS)) continue;
                Long number = 0L;
                try {
                    Query q;
                    if (this.type.compareTo("Agent") == 0) {
                        q = this.dbManager.getPersistenceManager().newQuery(Agent.class);
                        q.setFilter("agentId == \"" + idOfObjInDB + "\"");
                        number = q.deletePersistentAll();
                    } else if (this.type.compareTo("DataSource") == 0) {
                        q = this.dbManager.getPersistenceManager().newQuery(DataSource.class);
                        q.setFilter("dataSourceId == \"" + idOfObjInDB + "\"");
                        number = q.deletePersistentAll();
                    } else if (this.type.compareTo("DataStorage") == 0) {
                        q = this.dbManager.getPersistenceManager().newQuery(DataStorage.class);
                        q.setFilter("dataStorageId == \"" + idOfObjInDB + "\"");
                        number = q.deletePersistentAll();
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)("ISManager - updateObjsInDB - Error in deleting the existed obj in DB - idOfObjInDB=" + idOfObjInDB));
                    e.printStackTrace();
                    return;
                }
                ++oldContentInDB;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.type.compareTo("DataSource") == 0) {
            typeOfISManager = new String("for DataSources");
        } else if (this.type.compareTo("Agent") == 0) {
            typeOfISManager = new String("for Agents");
        } else if (this.type.compareTo("DataStorage") == 0) {
            typeOfISManager = new String("for DataStorages");
        }
        this.logger.debug((Object)("ISManager.updateObjsInDB (" + typeOfISManager + "):\nnew UP-Nodes For Storing in DB=" + newContentInDB + " - Nodes that do not exist anymore in IS=" + oldContentInDB));
    }

    public List<String> getObjsFromIS() {
        ArrayList<String> agentsFromIS = new ArrayList<String>();
        ArrayList<String> dataSourcesFromIS = new ArrayList<String>();
        ArrayList<String> dataStoragesFromIS = new ArrayList<String>();
        if (this.type.compareTo("Agent") == 0) {
            try {
                ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
                GCUBERIQuery RIquery = (GCUBERIQuery)client.getQuery(GCUBERIQuery.class);
                RIquery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ServiceName", "agent-service")});
                for (GCUBERunningInstance instance : client.execute((ISQuery)RIquery, GCUBEScope.getScope((String)this.scope))) {
                    String tmpAgent = new String();
                    tmpAgent = instance.getID() + "--" + instance.getServiceName() + "--" + instance.getAccessPoint().getEndpoint("gcube/datatransfer/agent/DataTransferAgent").getAddress().getHost() + "--" + instance.getAccessPoint().getEndpoint("gcube/datatransfer/agent/DataTransferAgent").getAddress().getPort() + "--";
                    agentsFromIS.add(tmpAgent);
                }
            }
            catch (RuntimeException e) {
                this.logger.error((Object)"ISManager.getObjsFromIS(agents) - RuntimeException....");
                e.printStackTrace();
            }
            catch (Exception e) {
                this.logger.error((Object)"ISManager.getObjsFromIS(agents) - exception....");
                e.printStackTrace();
            }
            return agentsFromIS;
        }
        if (this.type.compareTo("DataSource") == 0) {
            try {
                ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
                GCUBERuntimeResourceQuery RRquery = (GCUBERuntimeResourceQuery)client.getQuery(GCUBERuntimeResourceQuery.class);
                RRquery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Category", "DataSource")});
                for (GCUBERuntimeResource resource : client.execute((ISQuery)RRquery, GCUBEScope.getScope((String)this.scope))) {
                    String tmpDataSource = "";
                    tmpDataSource = tmpDataSource.concat(resource.getID() + "--" + resource.getName() + "--" + resource.getDescription() + "--" + ((AccessPoint)resource.getAccessPoints().get(0)).getEndpoint() + "--" + ((AccessPoint)resource.getAccessPoints().get(0)).getUsername() + "--" + ((AccessPoint)resource.getAccessPoints().get(0)).getPassword() + "--" + ((AccessPoint)resource.getAccessPoints().get(0)).getProperty("folder") + "--");
                    dataSourcesFromIS.add(tmpDataSource);
                }
            }
            catch (RuntimeException e) {
                this.logger.error((Object)"ISManager.getObjsFromIS(datasources) - RuntimeException....");
                e.printStackTrace();
            }
            catch (Exception e) {
                this.logger.error((Object)"ISManager.getObjsFromIS(datasources) - exception....");
                e.printStackTrace();
            }
            return dataSourcesFromIS;
        }
        if (this.type.compareTo("DataStorage") == 0) {
            try {
                ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
                GCUBERuntimeResourceQuery RRquery = (GCUBERuntimeResourceQuery)client.getQuery(GCUBERuntimeResourceQuery.class);
                RRquery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Category", "DataStorage")});
                for (GCUBERuntimeResource resource : client.execute((ISQuery)RRquery, GCUBEScope.getScope((String)this.scope))) {
                    String tmpDataStorage = "";
                    tmpDataStorage = tmpDataStorage.concat(resource.getID() + "--" + resource.getName() + "--" + resource.getDescription() + "--" + ((AccessPoint)resource.getAccessPoints().get(0)).getEndpoint() + "--" + ((AccessPoint)resource.getAccessPoints().get(0)).getUsername() + "--" + ((AccessPoint)resource.getAccessPoints().get(0)).getPassword() + "--" + "--");
                    dataStoragesFromIS.add(tmpDataStorage);
                }
            }
            catch (RuntimeException e) {
                this.logger.error((Object)"ISManager.getObjsFromIS(datasources) - RuntimeException....");
                e.printStackTrace();
            }
            catch (Exception e) {
                this.logger.error((Object)"ISManager.getObjsFromIS(datasources) - exception....");
                e.printStackTrace();
            }
            return dataStoragesFromIS;
        }
        return null;
    }

    public boolean checkIfObjExistsInIS_ById(String id) {
        if (this.type.compareTo("Agent") == 0) {
            try {
                ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
                GCUBERIQuery RIquery = (GCUBERIQuery)client.getQuery(GCUBERIQuery.class);
                RIquery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ServiceName", "agent-service")});
                for (GCUBERunningInstance instance : client.execute((ISQuery)RIquery, GCUBEScope.getScope((String)this.scope))) {
                    String instanceId = instance.getID();
                    if (instanceId.compareTo(id) != 0) continue;
                    return true;
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"ISManager.checkIfObjExistsInIS_ById - exception");
                e.printStackTrace();
            }
            return false;
        }
        if (this.type.compareTo("DataSource") == 0) {
            try {
                ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
                GCUBERuntimeResourceQuery RRquery = (GCUBERuntimeResourceQuery)client.getQuery(GCUBERuntimeResourceQuery.class);
                RRquery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Category", "DataSource")});
                for (GCUBERuntimeResource resource : client.execute((ISQuery)RRquery, GCUBEScope.getScope((String)this.scope))) {
                    String resourceId = resource.getID();
                    if (resourceId.compareTo(id) != 0) continue;
                    return true;
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"ISManager.checkIfObjExistsInIS_ById - exception");
                e.printStackTrace();
            }
            return false;
        }
        if (this.type.compareTo("DataStorage") == 0) {
            try {
                ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
                GCUBERuntimeResourceQuery RRquery = (GCUBERuntimeResourceQuery)client.getQuery(GCUBERuntimeResourceQuery.class);
                RRquery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//Category", "DataStorage")});
                for (GCUBERuntimeResource resource : client.execute((ISQuery)RRquery, GCUBEScope.getScope((String)this.scope))) {
                    String resourceId = resource.getID();
                    if (resourceId.compareTo(id) != 0) continue;
                    return true;
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"ISManager.checkIfObjExistsInIS_ById - exception");
                e.printStackTrace();
            }
            return false;
        }
        return false;
    }

    public String checkIfObjExistsInDB_ById(String id) {
        if (this.type.compareTo("Agent") == 0) {
            try {
                Extent agentExtent = this.dbManager.getPersistenceManager().getExtent(Agent.class, true);
                for (Object obj : agentExtent) {
                    String tmpId = ((Agent)obj).getAgentIdOfIS();
                    if (tmpId == null || tmpId.compareTo(id) != 0) continue;
                    return ((Agent)obj).getAgentId();
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"ISManager.checkIfObjExistsInDB_ById(for agents) - exception");
                e.printStackTrace();
            }
            return null;
        }
        if (this.type.compareTo("DataSource") == 0) {
            try {
                Extent sourceExtent = this.dbManager.getPersistenceManager().getExtent(DataSource.class, true);
                for (Object obj : sourceExtent) {
                    String tmpId = ((DataSource)obj).getDataSourceIdOfIS();
                    if (tmpId == null || tmpId.compareTo(id) != 0) continue;
                    return ((DataSource)obj).getDataSourceId();
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"ISManager.checkIfObjExistsInDB_ById(for datasources) - exception");
                e.printStackTrace();
            }
            return null;
        }
        if (this.type.compareTo("DataStorage") == 0) {
            try {
                Extent sourceExtent = this.dbManager.getPersistenceManager().getExtent(DataStorage.class, true);
                for (Object obj : sourceExtent) {
                    String tmpId = ((DataStorage)obj).getDataStorageIdOfIS();
                    if (tmpId == null || tmpId.compareTo(id) != 0) continue;
                    return ((DataStorage)obj).getDataStorageId();
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"ISManager.checkIfObjExistsInDB_ById(for datastorages) - exception");
                e.printStackTrace();
            }
            return null;
        }
        return null;
    }

    public String checkIfObjExistsInDB_ByHostname(String hostname) {
        if (this.type.compareTo("Agent") == 0) {
            try {
                Extent agentExtent = this.dbManager.getPersistenceManager().getExtent(Agent.class, true);
                for (Object obj : agentExtent) {
                    String host = ((Agent)obj).getHost();
                    if (host.compareTo(hostname) != 0) continue;
                    return ((Agent)obj).getAgentId();
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"ISManager.checkIfObjExistsInDB_ByHostname(for agents) - exception");
                e.printStackTrace();
            }
            return null;
        }
        if (this.type.compareTo("DataSource") == 0) {
            try {
                Extent sourceExtent = this.dbManager.getPersistenceManager().getExtent(DataSource.class, true);
                for (Object obj : sourceExtent) {
                    String host = ((DataSource)obj).getEndpoint();
                    if (host.compareTo(hostname) != 0) continue;
                    return ((DataSource)obj).getDataSourceId();
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"ISManager.checkIfObjExistsInDB_ByHostname(for datasources) - exception");
                e.printStackTrace();
            }
            return null;
        }
        if (this.type.compareTo("DataStorage") == 0) {
            return null;
        }
        return null;
    }

    public void updateSpecificObjInDB(String[] input, String id) {
        if (this.type.compareTo("Agent") == 0) {
            if (input.length < 4) {
                this.logger.debug((Object)"ISManager.updateSpecificObjInDB - Error - the given string for Agent has less than 4 parameters");
            }
            String agentIdOfIs = input[0];
            String host = input[2];
            int port = Integer.valueOf(input[3]);
            try {
                this.dbManager.updateEverythingInAgent(id, agentIdOfIs, host, port);
            }
            catch (Exception e) {
                this.logger.error((Object)("ISManager.updateSpecificObjInDB - Exception in updating the specific Agent with id=" + id));
                e.printStackTrace();
                return;
            }
        }
        if (this.type.compareTo("DataSource") == 0) {
            if (input.length < 7) {
                this.logger.debug((Object)"ISManager.updateSpecificObjInDB - Error - the given string for DataSource has less than 6 parameters");
            }
            String dataSourceIdOfIS = input[0];
            String dataSourceName = input[1];
            String description = input[2];
            String endpoint = input[3];
            String username = input[4];
            String pass = input[5];
            String folder = input[6];
            try {
                this.dbManager.updateEverythingInSource(id, dataSourceIdOfIS, dataSourceName, description, endpoint, username, pass, folder);
            }
            catch (Exception e) {
                this.logger.error((Object)("ISManager.updateSpecificObjInDB - Exception in updating the specific DataSource with id=" + id));
                e.printStackTrace();
                return;
            }
        }
        if (this.type.compareTo("DataStorage") == 0) {
            if (input.length < 6) {
                this.logger.debug((Object)"ISManager.updateSpecificObjInDB - Error - the given string for DataStorage has less than 6 parameters");
            }
            String dataStorageIdOfIS = input[0];
            String dataStorageName = input[1];
            String description = input[2];
            String endpoint = input[3];
            String username = input[4];
            String pass = input[5];
            try {
                this.dbManager.updateEverythingInStorage(id, dataStorageIdOfIS, dataStorageName, description, endpoint, username, pass);
            }
            catch (Exception e) {
                this.logger.error((Object)("ISManager.updateSpecificObjInDB - Exception in updating the specific DataStorage with id=" + id));
                e.printStackTrace();
                return;
            }
        }
    }

    public String setObjToDB(String[] input) {
        String id = uuidgen.nextUUID();
        if (this.type.compareTo("Agent") == 0) {
            if (input.length < 4) {
                return "lessParameters";
            }
            Agent agentDB = new Agent();
            agentDB.setAgentId(id);
            agentDB.setAgentIdOfIS(input[0]);
            agentDB.setHost(input[2]);
            agentDB.setPort(Integer.valueOf(input[3]).intValue());
            try {
                this.dbManager.storeAgent(agentDB);
            }
            catch (Exception e) {
                this.logger.error((Object)"ISManager.setObjToDB - Exception in storing the Agent");
                e.printStackTrace();
                return null;
            }
            return id;
        }
        if (this.type.compareTo("DataSource") == 0) {
            if (input.length < 7) {
                return "lessParameters";
            }
            DataSource dataSource = new DataSource();
            dataSource.setDataSourceId(id);
            dataSource.setDataSourceIdOfIS(input[0]);
            dataSource.setDataSourceName(input[1]);
            dataSource.setDescription(input[2]);
            dataSource.setEndpoint(input[3]);
            dataSource.setUsername(input[4]);
            dataSource.setPass(input[5]);
            dataSource.setFolder(input[6]);
            try {
                this.dbManager.storeSource(dataSource);
            }
            catch (Exception e) {
                this.logger.error((Object)"ISManager.setObjToDB - Exception in storing the DataSource");
                e.printStackTrace();
                return null;
            }
            return id;
        }
        if (this.type.compareTo("DataStorage") == 0) {
            DataStorage storageDB = new DataStorage();
            if (input.length < 6) {
                return "lessParameters";
            }
            storageDB.setType("RemoteNode");
            storageDB.setDataStorageId(id);
            storageDB.setDataStorageIdOfIS(input[0]);
            storageDB.setDataStorageName(input[1]);
            storageDB.setDescription(input[2]);
            storageDB.setEndpoint(input[3]);
            storageDB.setUsername(input[4]);
            storageDB.setPass(input[5]);
            try {
                this.dbManager.storeStorage(storageDB);
            }
            catch (Exception e) {
                this.logger.error((Object)"ISManager.setObjToDB - Exception in storing the DataStorage");
                e.printStackTrace();
                return null;
            }
            return id;
        }
        return null;
    }

    public String checkIfObjExistsInIS_ByHostname(String host) {
        if (this.type.compareTo("Agent") == 0) {
            try {
                ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
                GCUBERIQuery RIquery = (GCUBERIQuery)client.getQuery(GCUBERIQuery.class);
                RIquery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ServiceName", "agent-service")});
                for (GCUBERunningInstance instance : client.execute((ISQuery)RIquery, GCUBEScope.getScope((String)this.scope))) {
                    if (instance.getAccessPoint().getEndpoint("gcube/datatransfer/agent/DataTransferAgent").getAddress().getHost().compareTo(host) != 0) continue;
                    return instance.getID();
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"ISManager.checkIfObjExistsInIS_ByHostname - exception");
                e.printStackTrace();
            }
            return null;
        }
        if (this.type.compareTo("DataSource") == 0) {
            DataSource sourceDB = new DataSource();
            return null;
        }
        if (this.type.compareTo("DataStorage") == 0) {
            DataStorage storageDB = new DataStorage();
            return null;
        }
        return null;
    }
}

