/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransfer.scheduler.library;

import com.thoughtworks.xstream.XStream;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.AsyncProxyDelegate;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.datatransfer.scheduler.library.fws.ManagementServiceJAXWSStubs;
import org.gcube.datatransfer.scheduler.library.outcome.CallingManagementResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementLibrary {
    private final AsyncProxyDelegate<ManagementServiceJAXWSStubs> delegate;
    Logger logger = LoggerFactory.getLogger((String)this.getClass().toString());

    public ManagementLibrary(ProxyDelegate<ManagementServiceJAXWSStubs> config) {
        this.delegate = new AsyncProxyDelegate(config);
    }

    public CallingManagementResult getAllTransfersInfo(String nameOfClient) {
        final String message = nameOfClient;
        Call<ManagementServiceJAXWSStubs, String> call = new Call<ManagementServiceJAXWSStubs, String>(){

            public String call(ManagementServiceJAXWSStubs endpoint) throws Exception {
                return endpoint.getAllTransfersInfo(message);
            }
        };
        String result = null;
        try {
            result = (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            this.logger.error("getAllTransfersInfo - Exception when calling endpoint.getAllTransfersInfo(message)");
            e.printStackTrace();
        }
        if (result == null) {
            return null;
        }
        String tmpMsg = result;
        tmpMsg.replaceAll("&lt;", "<");
        tmpMsg = tmpMsg.replaceAll("&gt;", ">");
        XStream xstream = new XStream();
        CallingManagementResult callingManagementResult = new CallingManagementResult();
        callingManagementResult = (CallingManagementResult)xstream.fromXML(tmpMsg);
        return callingManagementResult;
    }

    public String getObjectsFromIS(String type) {
        final String typeOfObj = type;
        if (typeOfObj.compareTo("Agent") != 0 && typeOfObj.compareTo("DataSource") != 0 && typeOfObj.compareTo("DataStorage") != 0) {
            this.logger.debug("getObjectsFromIS - input tupe != 'Agent','DataSource','DataStorage' --- input type=" + typeOfObj);
            return null;
        }
        Call<ManagementServiceJAXWSStubs, String> call = new Call<ManagementServiceJAXWSStubs, String>(){

            public String call(ManagementServiceJAXWSStubs endpoint) throws Exception {
                return endpoint.getObjectsFromIS(typeOfObj);
            }
        };
        String result = null;
        try {
            result = (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            this.logger.error("getObjectsFromIS - Exception when calling endpoint.getObjectsFromIS(message)");
            e.printStackTrace();
        }
        return result;
    }

    public String existAgentInIS(String agent) {
        final String message = agent;
        Call<ManagementServiceJAXWSStubs, String> call = new Call<ManagementServiceJAXWSStubs, String>(){

            public String call(ManagementServiceJAXWSStubs endpoint) throws Exception {
                return endpoint.existAgentInIS(message);
            }
        };
        String result = null;
        try {
            result = (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            this.logger.error("existAgentInIS - Exception when calling endpoint.getAllTransfersInfo(message)");
            e.printStackTrace();
        }
        return result;
    }

    public String existAgentInDB(String agent) {
        final String message = agent;
        Call<ManagementServiceJAXWSStubs, String> call = new Call<ManagementServiceJAXWSStubs, String>(){

            public String call(ManagementServiceJAXWSStubs endpoint) throws Exception {
                return endpoint.existAgentInDB(message);
            }
        };
        String result = null;
        try {
            result = (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            this.logger.error("existAgentInDB - Exception when calling endpoint.existAgentInDB(message)");
            e.printStackTrace();
        }
        return result;
    }

    public String getAgentStatistics() {
        String nothing = "";
        Call<ManagementServiceJAXWSStubs, String> call = new Call<ManagementServiceJAXWSStubs, String>(){

            public String call(ManagementServiceJAXWSStubs endpoint) throws Exception {
                return endpoint.getAgentStatistics("");
            }
        };
        String result = null;
        try {
            result = (String)this.delegate.make((Call)call);
        }
        catch (Exception e) {
            this.logger.error("getAgentStatistics - Exception when calling endpoint.getAgentStatistics(message)");
            e.printStackTrace();
        }
        return result;
    }
}

