/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.common;

import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.gcube.data.transfer.common.HttpFileSystemConfBuilderPatched;

public class Utils {
    protected static FileSystemOptions createDefaultOptions(String URI, int connectiontimeout) {
        FileSystemOptions opts = new FileSystemOptions();
        if (URI.startsWith("ftp://")) {
            FtpFileSystemConfigBuilder.getInstance().setUserDirIsRoot(opts, true);
            FtpFileSystemConfigBuilder.getInstance().setSoTimeout(opts, Integer.valueOf(connectiontimeout));
            FtpFileSystemConfigBuilder.getInstance().setDataTimeout(opts, Integer.valueOf(connectiontimeout));
            return opts;
        }
        if (URI.startsWith("sftp://")) {
            SftpFileSystemConfigBuilder.getInstance().setUserDirIsRoot(opts, true);
            SftpFileSystemConfigBuilder.getInstance().setTimeout(opts, Integer.valueOf(connectiontimeout));
            return opts;
        }
        if (!URI.startsWith("s3://")) {
            if (URI.startsWith("http://") || URI.startsWith("https://")) {
                HttpFileSystemConfBuilderPatched.getInstance().setTimeout(opts, connectiontimeout);
                HttpFileSystemConfBuilderPatched.getInstance().setFollowRedirect(opts, true);
                return opts;
            }
            if (URI.startsWith("smp://")) {
                return opts;
            }
        }
        return null;
    }
}

