/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.server.response;

import java.io.InputStream;
import java.util.Calendar;
import javax.xml.namespace.QName;
import net.opengis.ows.x11.DomainMetadataType;
import net.opengis.ows.x11.LanguageStringType;
import net.opengis.wps.x100.DataInputsType;
import net.opengis.wps.x100.DocumentOutputDefinitionType;
import net.opengis.wps.x100.ExecuteResponseDocument;
import net.opengis.wps.x100.OutputDefinitionType;
import net.opengis.wps.x100.OutputDescriptionType;
import net.opengis.wps.x100.ProcessDescriptionType;
import net.opengis.wps.x100.StatusType;
import org.apache.xmlbeans.XmlCursor;
import org.n52.wps.commons.WPSConfig;
import org.n52.wps.io.data.IBBOXData;
import org.n52.wps.io.data.IData;
import org.n52.wps.server.CapabilitiesConfiguration;
import org.n52.wps.server.ExceptionReport;
import org.n52.wps.server.RepositoryManager;
import org.n52.wps.server.WebProcessingService;
import org.n52.wps.server.database.DatabaseFactory;
import org.n52.wps.server.request.ExecuteRequest;
import org.n52.wps.server.response.OutputDataItem;
import org.n52.wps.server.response.RawData;
import org.n52.wps.util.XMLBeansHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteResponseBuilder {
    private String identifier;
    private DataInputsType dataInputs;
    private ExecuteRequest request;
    private ExecuteResponseDocument doc;
    private RawData rawDataHandler = null;
    private ProcessDescriptionType description;
    private static Logger LOGGER = LoggerFactory.getLogger(ExecuteResponseBuilder.class);
    private Calendar creationTime;

    public ExecuteResponseBuilder(ExecuteRequest request) throws ExceptionReport {
        this.request = request;
        this.doc = ExecuteResponseDocument.Factory.newInstance();
        this.doc.addNewExecuteResponse();
        XmlCursor c = this.doc.newCursor();
        c.toFirstChild();
        c.toLastAttribute();
        c.setAttributeText(new QName("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation"), "http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsExecute_response.xsd");
        this.doc.getExecuteResponse().setServiceInstance(CapabilitiesConfiguration.ENDPOINT_URL + "?REQUEST=GetCapabilities&SERVICE=WPS");
        this.doc.getExecuteResponse().setLang(WebProcessingService.DEFAULT_LANGUAGE);
        this.doc.getExecuteResponse().setService("WPS");
        this.doc.getExecuteResponse().setVersion("1.0.0");
        this.identifier = request.getExecute().getIdentifier().getStringValue().trim();
        ExecuteResponseDocument.ExecuteResponse responseElem = this.doc.getExecuteResponse();
        responseElem.addNewProcess().addNewIdentifier().setStringValue(this.identifier);
        this.description = RepositoryManager.getInstance().getProcessDescription(this.identifier);
        if (this.description == null) {
            throw new RuntimeException("Error while accessing the process description for " + this.identifier);
        }
        responseElem.getProcess().setTitle(this.description.getTitle());
        responseElem.getProcess().setProcessVersion(this.description.getProcessVersion());
        this.creationTime = Calendar.getInstance();
    }

    public void update() throws ExceptionReport {
        ExecuteResponseDocument.ExecuteResponse responseElem = this.doc.getExecuteResponse();
        if (responseElem.getStatus().isSetProcessSucceeded()) {
            if (new Boolean(WPSConfig.getInstance().getWPSConfig().getServer().getIncludeDataInputsInResponse()).booleanValue()) {
                this.dataInputs = this.request.getExecute().getDataInputs();
                responseElem.setDataInputs(this.dataInputs);
            }
            responseElem.addNewProcessOutputs();
            if (this.request.getExecute().isSetResponseForm()) {
                OutputDescriptionType[] outputDescs = this.description.getProcessOutputs().getOutputArray();
                if (this.request.isRawData()) {
                    OutputDefinitionType rawDataOutput = this.request.getExecute().getResponseForm().getRawDataOutput();
                    String id = rawDataOutput.getIdentifier().getStringValue();
                    OutputDescriptionType desc = XMLBeansHelper.findOutputByID(id, outputDescs);
                    if (desc.isSetComplexOutput()) {
                        String encoding = ExecuteResponseBuilder.getEncoding(desc, rawDataOutput);
                        String schema = ExecuteResponseBuilder.getSchema(desc, rawDataOutput);
                        String responseMimeType = this.getMimeType(rawDataOutput);
                        this.generateComplexDataOutput(id, false, true, schema, responseMimeType, encoding, null);
                    } else if (desc.isSetLiteralOutput()) {
                        String mimeType = null;
                        String schema = null;
                        String encoding = null;
                        DomainMetadataType dataType = desc.getLiteralOutput().getDataType();
                        String reference = dataType != null ? dataType.getReference() : null;
                        this.generateLiteralDataOutput(id, this.doc, true, reference, schema, mimeType, encoding, desc.getTitle());
                    } else if (desc.isSetBoundingBoxOutput()) {
                        this.generateBBOXOutput(id, this.doc, true, desc.getTitle());
                    }
                    return;
                }
                for (int i = 0; i < this.request.getExecute().getResponseForm().getResponseDocument().getOutputArray().length; ++i) {
                    String encoding;
                    String schema;
                    String mimeType;
                    DocumentOutputDefinitionType definition = this.request.getExecute().getResponseForm().getResponseDocument().getOutputArray(i);
                    DocumentOutputDefinitionType documentDef = this.request.getExecute().getResponseForm().getResponseDocument().getOutputArray(i);
                    String responseID = definition.getIdentifier().getStringValue();
                    OutputDescriptionType desc = XMLBeansHelper.findOutputByID(responseID, outputDescs);
                    if (desc == null) {
                        throw new ExceptionReport("Could not find the output id " + responseID, "InvalidParameterValue");
                    }
                    if (desc.isSetComplexOutput()) {
                        mimeType = this.getMimeType((OutputDefinitionType)definition);
                        schema = ExecuteResponseBuilder.getSchema(desc, (OutputDefinitionType)definition);
                        encoding = ExecuteResponseBuilder.getEncoding(desc, (OutputDefinitionType)definition);
                        this.generateComplexDataOutput(responseID, documentDef.getAsReference(), false, schema, mimeType, encoding, desc.getTitle());
                        continue;
                    }
                    if (desc.isSetLiteralOutput()) {
                        mimeType = null;
                        schema = null;
                        encoding = null;
                        DomainMetadataType dataType = desc.getLiteralOutput().getDataType();
                        String reference = dataType != null ? dataType.getReference() : null;
                        this.generateLiteralDataOutput(responseID, this.doc, false, reference, schema, mimeType, encoding, desc.getTitle());
                        continue;
                    }
                    if (desc.isSetBoundingBoxOutput()) {
                        this.generateBBOXOutput(responseID, this.doc, false, desc.getTitle());
                        continue;
                    }
                    throw new ExceptionReport("Requested type not supported: BBOX", "InvalidParameterValue");
                }
            } else {
                LOGGER.info("OutputDefinitions are not stated explicitly in request");
                ProcessDescriptionType description = RepositoryManager.getInstance().getProcessDescription(this.request.getExecute().getIdentifier().getStringValue());
                if (description == null) {
                    throw new RuntimeException("Error while accessing the process description for " + this.request.getExecute().getIdentifier().getStringValue());
                }
                OutputDescriptionType[] d = description.getProcessOutputs().getOutputArray();
                for (int i = 0; i < d.length; ++i) {
                    if (d[i].isSetComplexOutput()) {
                        String schema = d[i].getComplexOutput().getDefault().getFormat().getSchema();
                        String encoding = d[i].getComplexOutput().getDefault().getFormat().getEncoding();
                        String mimeType = d[i].getComplexOutput().getDefault().getFormat().getMimeType();
                        this.generateComplexDataOutput(d[i].getIdentifier().getStringValue(), false, false, schema, mimeType, encoding, d[i].getTitle());
                        continue;
                    }
                    if (!d[i].isSetLiteralOutput()) continue;
                    this.generateLiteralDataOutput(d[i].getIdentifier().getStringValue(), this.doc, false, d[i].getLiteralOutput().getDataType().getReference(), null, null, null, d[i].getTitle());
                }
            }
        } else if (this.request.isStoreResponse()) {
            responseElem.setStatusLocation(DatabaseFactory.getDatabase().generateRetrieveResultURL(this.request.getUniqueId().toString()));
        }
    }

    private static String getSchema(OutputDescriptionType desc, OutputDefinitionType def) {
        String schema = null;
        if (def != null) {
            schema = def.getSchema();
        }
        return schema;
    }

    private static String getEncoding(OutputDescriptionType desc, OutputDefinitionType def) {
        String encoding = null;
        if (def != null) {
            encoding = def.getEncoding();
        }
        return encoding;
    }

    public String getMimeType() {
        return this.getMimeType(null);
    }

    public String getMimeType(OutputDefinitionType def) {
        String mimeType = "";
        OutputDescriptionType[] outputDescs = this.description.getProcessOutputs().getOutputArray();
        boolean isResponseForm = this.request.getExecute().isSetResponseForm();
        String inputID = "";
        if (def != null) {
            inputID = def.getIdentifier().getStringValue();
        } else if (isResponseForm) {
            if (this.request.getExecute().getResponseForm().isSetRawDataOutput()) {
                inputID = this.request.getExecute().getResponseForm().getRawDataOutput().getIdentifier().getStringValue();
            } else if (this.request.getExecute().getResponseForm().isSetResponseDocument()) {
                inputID = this.request.getExecute().getResponseForm().getResponseDocument().getOutputArray(0).getIdentifier().getStringValue();
            }
        }
        OutputDescriptionType outputDes = null;
        for (OutputDescriptionType tmpOutputDes : outputDescs) {
            if (!inputID.equalsIgnoreCase(tmpOutputDes.getIdentifier().getStringValue())) continue;
            outputDes = tmpOutputDes;
            break;
        }
        if (isResponseForm) {
            if (this.request.isRawData()) {
                mimeType = this.request.getExecute().getResponseForm().getRawDataOutput().getMimeType();
            } else if (outputDes.isSetLiteralOutput()) {
                mimeType = "text/plain";
            } else if (outputDes.isSetBoundingBoxOutput()) {
                mimeType = "text/xml";
            } else if (def != null) {
                mimeType = def.getMimeType();
            } else if (outputDes.isSetComplexOutput()) {
                mimeType = outputDes.getComplexOutput().getDefault().getFormat().getMimeType();
                LOGGER.warn("Using default mime type: " + mimeType + " for input: " + inputID);
            }
        }
        if (mimeType == null) {
            if (outputDes.isSetLiteralOutput()) {
                mimeType = "text/plain";
            } else if (outputDes.isSetBoundingBoxOutput()) {
                mimeType = "text/xml";
            } else if (outputDes.isSetComplexOutput()) {
                mimeType = outputDes.getComplexOutput().getDefault().getFormat().getMimeType();
                LOGGER.warn("Using default mime type: " + mimeType + " for input: " + inputID);
            }
        }
        return mimeType;
    }

    private void generateComplexDataOutput(String responseID, boolean asReference, boolean rawData, String schema, String mimeType, String encoding, LanguageStringType title) throws ExceptionReport {
        IData obj = (IData)this.request.getAttachedResult().get(responseID);
        if (rawData) {
            this.rawDataHandler = new RawData(obj, responseID, schema, encoding, mimeType, this.identifier, this.description);
        } else {
            OutputDataItem handler = new OutputDataItem(obj, responseID, schema, encoding, mimeType, title, this.identifier, this.description);
            if (asReference) {
                handler.updateResponseAsReference(this.doc, this.request.getUniqueId().toString(), mimeType);
            } else {
                handler.updateResponseForInlineComplexData(this.doc);
            }
        }
    }

    private void generateLiteralDataOutput(String responseID, ExecuteResponseDocument res, boolean rawData, String dataTypeReference, String schema, String mimeType, String encoding, LanguageStringType title) throws ExceptionReport {
        IData obj = (IData)this.request.getAttachedResult().get(responseID);
        if (rawData) {
            this.rawDataHandler = new RawData(obj, responseID, schema, encoding, mimeType, this.identifier, this.description);
        } else {
            OutputDataItem handler = new OutputDataItem(obj, responseID, schema, encoding, mimeType, title, this.identifier, this.description);
            handler.updateResponseForLiteralData(res, dataTypeReference);
        }
    }

    private void generateBBOXOutput(String responseID, ExecuteResponseDocument res, boolean rawData, LanguageStringType title) throws ExceptionReport {
        IBBOXData obj = (IBBOXData)this.request.getAttachedResult().get(responseID);
        if (rawData) {
            this.rawDataHandler = new RawData((IData)obj, responseID, null, null, null, this.identifier, this.description);
        } else {
            OutputDataItem handler = new OutputDataItem((IData)obj, responseID, null, null, null, title, this.identifier, this.description);
            handler.updateResponseForBBOXData(res, obj);
        }
    }

    public InputStream getAsStream() throws ExceptionReport {
        if (this.request.isRawData() && this.rawDataHandler != null) {
            return this.rawDataHandler.getAsStream();
        }
        if (this.request.isStoreResponse()) {
            String id = this.request.getUniqueId().toString();
            String statusLocation = DatabaseFactory.getDatabase().generateRetrieveResultURL(id);
            this.doc.getExecuteResponse().setStatusLocation(statusLocation);
        }
        try {
            return this.doc.newInputStream(XMLBeansHelper.getXmlOptions());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setStatus(StatusType status) {
        status.setCreationTime(this.creationTime);
        this.doc.getExecuteResponse().setStatus(status);
    }
}

