/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.server.request;

import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.n52.wps.server.ExceptionReport;
import org.n52.wps.server.response.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public abstract class Request
implements Callable<Response> {
    protected CaseInsensitiveMap map = null;
    protected Document doc = null;
    protected static Logger LOGGER = LoggerFactory.getLogger(Request.class);
    protected UUID id = null;
    public static final String SUPPORTED_VERSION = "1.0.0";
    public static final String[] SUPPORTED_LANGUAGES = new String[]{"en-US"};

    public Request(CaseInsensitiveMap map) throws ExceptionReport {
        this.map = map;
    }

    public Request(Document doc) throws ExceptionReport {
        this.doc = doc;
    }

    public Document getDocument() {
        return this.doc;
    }

    public CaseInsensitiveMap getMap() {
        return this.map;
    }

    public static String getMapValue(String key, CaseInsensitiveMap map, boolean required) throws ExceptionReport {
        if (map.containsKey((Object)key)) {
            return ((String[])map.get((Object)key))[0];
        }
        if (!required) {
            LOGGER.warn("Parameter <" + key + "> not found.");
            return null;
        }
        throw new ExceptionReport("Parameter <" + key + "> not specified.", "MissingParameterValue", key);
    }

    public static String getMapValue(String key, CaseInsensitiveMap map, boolean required, String[] supportedValues) throws ExceptionReport {
        if (map.containsKey((Object)key)) {
            String value = ((String[])map.get((Object)key))[0];
            for (String string : supportedValues) {
                if (!string.equalsIgnoreCase(value)) continue;
                return value;
            }
            throw new ExceptionReport("Invalid value for parameter <" + key + ">.", "InvalidParameterValue", key);
        }
        if (!required) {
            LOGGER.warn("Parameter <" + key + "> not found.");
            return null;
        }
        throw new ExceptionReport("Parameter <" + key + "> not specified.", "MissingParameterValue", key);
    }

    public static String[] getMapArray(String key, CaseInsensitiveMap map, boolean required) throws ExceptionReport {
        if (map.containsKey((Object)key)) {
            return (String[])map.get((Object)key);
        }
        if (!required) {
            LOGGER.warn("Parameter <" + key + "> not found.");
            return null;
        }
        throw new ExceptionReport("Parameter <" + key + "> not specified.", "MissingParameterValue", key);
    }

    protected String getMapValue(String key, boolean required) throws ExceptionReport {
        return Request.getMapValue(key, this.map, required);
    }

    protected String getMapValue(String key, boolean required, String[] supportedValues) throws ExceptionReport {
        return Request.getMapValue(key, this.map, required, supportedValues);
    }

    protected String[] getMapArray(String key, boolean required) throws ExceptionReport {
        return Request.getMapArray(key, this.map, required);
    }

    protected String[] getRequestedVersions(boolean mandatory) throws ExceptionReport {
        return this.getMapArray("version", mandatory);
    }

    public boolean requireVersion(String version, boolean mandatory) throws ExceptionReport {
        String[] versions = this.getRequestedVersions(mandatory);
        if (mandatory && versions == null) {
            throw new ExceptionReport("Parameter <version> not specified.", "MissingParameterValue", "version");
        }
        if (versions == null && !mandatory) {
            return true;
        }
        for (String v : versions) {
            if (!v.trim().equals(version)) continue;
            return true;
        }
        return false;
    }

    public static String accumulateString(String[] strings) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < strings.length; ++i) {
            String s = strings[i];
            if (i != strings.length - 1) {
                sb.append(s + ", ");
                continue;
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public UUID getUniqueId() {
        if (this.id == null) {
            this.id = UUID.randomUUID();
        }
        return this.id;
    }

    public static void checkLanguageSupported(String language) throws ExceptionReport {
        for (String supportedLanguage : SUPPORTED_LANGUAGES) {
            if (!supportedLanguage.equals(language)) continue;
            return;
        }
        throw new ExceptionReport("The requested language " + language + " is not supported", "InvalidParameterValue", "language");
    }

    public abstract Object getAttachedResult();

    @Override
    public abstract Response call() throws ExceptionReport;

    public abstract boolean validate() throws ExceptionReport;
}

