/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.server.response;

import java.util.ArrayList;
import net.opengis.wps.x100.ComplexDataDescriptionType;
import net.opengis.wps.x100.OutputDescriptionType;
import net.opengis.wps.x100.ProcessDescriptionType;
import org.n52.wps.io.GeneratorFactory;
import org.n52.wps.io.IGenerator;
import org.n52.wps.io.data.IData;
import org.n52.wps.server.ExceptionReport;
import org.n52.wps.server.RepositoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResponseData {
    private static Logger LOGGER = LoggerFactory.getLogger(ResponseData.class);
    protected IData obj = null;
    protected String id;
    protected String schema;
    protected String encoding;
    protected String mimeType;
    protected IGenerator generator = null;
    protected String algorithmIdentifier = null;
    protected ProcessDescriptionType description = null;

    /*
     * WARNING - void declaration
     */
    public ResponseData(IData obj, String id, String schema, String encoding, String mimeType, String algorithmIdentifier, ProcessDescriptionType description) throws ExceptionReport {
        OutputDescriptionType[] describeProcessOutput;
        this.obj = obj;
        this.id = id;
        this.algorithmIdentifier = algorithmIdentifier;
        this.description = description;
        this.encoding = encoding;
        OutputDescriptionType outputType = null;
        for (OutputDescriptionType tempOutputType : describeProcessOutput = description.getProcessOutputs().getOutputArray()) {
            if (!tempOutputType.getIdentifier().getStringValue().equalsIgnoreCase(id)) continue;
            outputType = tempOutputType;
        }
        String finalSchema = null;
        String finalMimeType = null;
        String finalEncoding = null;
        if (outputType.isSetComplexOutput()) {
            if (mimeType != null) {
                ComplexDataDescriptionType format = null;
                String defaultMimeType = outputType.getComplexOutput().getDefault().getFormat().getMimeType();
                boolean canUseDefault = false;
                if (defaultMimeType.equalsIgnoreCase(mimeType)) {
                    ComplexDataDescriptionType complexDataDescriptionType = outputType.getComplexOutput().getDefault().getFormat();
                    if (schema != null && encoding == null && schema.equalsIgnoreCase(complexDataDescriptionType.getSchema())) {
                        canUseDefault = true;
                        format = complexDataDescriptionType;
                    }
                    if (schema == null && encoding != null && encoding.equalsIgnoreCase(complexDataDescriptionType.getEncoding())) {
                        canUseDefault = true;
                        format = complexDataDescriptionType;
                    }
                    if (schema != null && encoding != null && schema.equalsIgnoreCase(complexDataDescriptionType.getSchema()) && encoding.equalsIgnoreCase(complexDataDescriptionType.getEncoding())) {
                        canUseDefault = true;
                        format = complexDataDescriptionType;
                    }
                    if (schema == null && encoding == null) {
                        canUseDefault = true;
                        format = complexDataDescriptionType;
                    }
                }
                if (!canUseDefault) {
                    ComplexDataDescriptionType[] complexDataDescriptionTypeArray;
                    for (ComplexDataDescriptionType potenitalFormat : complexDataDescriptionTypeArray = outputType.getComplexOutput().getSupported().getFormatArray()) {
                        if (!potenitalFormat.getMimeType().equalsIgnoreCase(mimeType)) continue;
                        if (schema != null && encoding == null && schema.equalsIgnoreCase(potenitalFormat.getSchema())) {
                            format = potenitalFormat;
                        }
                        if (schema == null && encoding != null && (encoding.equalsIgnoreCase(potenitalFormat.getEncoding()) || potenitalFormat.getEncoding() == null)) {
                            format = potenitalFormat;
                        }
                        if (schema != null && encoding != null && schema.equalsIgnoreCase(potenitalFormat.getSchema()) && (encoding.equalsIgnoreCase(potenitalFormat.getEncoding()) || potenitalFormat.getEncoding() == null)) {
                            format = potenitalFormat;
                        }
                        if (schema != null || encoding != null) continue;
                        format = potenitalFormat;
                    }
                }
                if (format == null) {
                    throw new ExceptionReport("Could not determine output format", "InvalidParameterValue");
                }
                finalMimeType = format.getMimeType();
                if (format.isSetEncoding()) {
                    finalEncoding = format.getEncoding();
                }
                if (format.isSetSchema()) {
                    finalSchema = format.getSchema();
                }
            } else if (mimeType == null && encoding == null && schema == null) {
                finalSchema = outputType.getComplexOutput().getDefault().getFormat().getSchema();
                finalMimeType = outputType.getComplexOutput().getDefault().getFormat().getMimeType();
                finalEncoding = outputType.getComplexOutput().getDefault().getFormat().getEncoding();
            } else if (mimeType == null) {
                int potenitalFormat;
                int n;
                ComplexDataDescriptionType[] complexDataDescriptionTypeArray;
                ComplexDataDescriptionType[] formats;
                int found;
                if (encoding != null && schema == null) {
                    ComplexDataDescriptionType encodingFormat = null;
                    String defaultEncoding = outputType.getComplexOutput().getDefault().getFormat().getEncoding();
                    found = 0;
                    Object var16_23 = null;
                    if (defaultEncoding.equalsIgnoreCase(encoding)) {
                        String string = outputType.getComplexOutput().getDefault().getFormat().getEncoding();
                        encodingFormat = outputType.getComplexOutput().getDefault().getFormat();
                        ++found;
                    } else {
                        complexDataDescriptionTypeArray = formats = outputType.getComplexOutput().getSupported().getFormatArray();
                        n = complexDataDescriptionTypeArray.length;
                        for (potenitalFormat = 0; potenitalFormat < n; ++potenitalFormat) {
                            ComplexDataDescriptionType tempFormat3 = complexDataDescriptionTypeArray[potenitalFormat];
                            if (!tempFormat3.getEncoding().equalsIgnoreCase(encoding)) continue;
                            String string = tempFormat3.getEncoding();
                            encodingFormat = tempFormat3;
                            ++found;
                        }
                    }
                    if (found == 1) {
                        void var16_27;
                        finalEncoding = var16_27;
                        finalMimeType = encodingFormat.getMimeType();
                        if (encodingFormat.isSetSchema()) {
                            finalSchema = encodingFormat.getSchema();
                        }
                    } else {
                        throw new ExceptionReport("Request incomplete. Could not determine a suitable input format based on the given input [mime Type missing and given encoding not unique]", "MissingParameterValue");
                    }
                }
                if (schema != null && encoding == null) {
                    ComplexDataDescriptionType schemaFormat = null;
                    String defaultSchema = outputType.getComplexOutput().getDefault().getFormat().getSchema();
                    found = 0;
                    Object var16_28 = null;
                    if (defaultSchema.equalsIgnoreCase(schema)) {
                        String string = outputType.getComplexOutput().getDefault().getFormat().getSchema();
                        schemaFormat = outputType.getComplexOutput().getDefault().getFormat();
                        ++found;
                    } else {
                        complexDataDescriptionTypeArray = formats = outputType.getComplexOutput().getSupported().getFormatArray();
                        n = complexDataDescriptionTypeArray.length;
                        for (potenitalFormat = 0; potenitalFormat < n; ++potenitalFormat) {
                            ComplexDataDescriptionType tempFormat = complexDataDescriptionTypeArray[potenitalFormat];
                            if (!tempFormat.getEncoding().equalsIgnoreCase(schema)) continue;
                            String string = tempFormat.getSchema();
                            schemaFormat = tempFormat;
                            ++found;
                        }
                    }
                    if (found == 1) {
                        void var16_32;
                        finalSchema = var16_32;
                        finalMimeType = schemaFormat.getMimeType();
                        if (schemaFormat.isSetEncoding()) {
                            finalEncoding = schemaFormat.getEncoding();
                        }
                    } else {
                        throw new ExceptionReport("Request incomplete. Could not determine a suitable input format based on the given input [mime Type missing and given schema not unique]", "MissingParameterValue");
                    }
                }
                if (encoding != null && schema != null) {
                    String defaultEncoding = outputType.getComplexOutput().getDefault().getFormat().getEncoding();
                    ArrayList<ComplexDataDescriptionType> foundEncodingList = new ArrayList<ComplexDataDescriptionType>();
                    if (defaultEncoding.equalsIgnoreCase(encoding)) {
                        foundEncodingList.add(outputType.getComplexOutput().getDefault().getFormat());
                    } else {
                        ComplexDataDescriptionType[] formats2;
                        for (ComplexDataDescriptionType tempFormat2 : formats2 = outputType.getComplexOutput().getSupported().getFormatArray()) {
                            if (!tempFormat2.getEncoding().equalsIgnoreCase(encoding)) continue;
                            foundEncodingList.add(tempFormat2);
                        }
                        ArrayList<ComplexDataDescriptionType> arrayList = new ArrayList<ComplexDataDescriptionType>();
                        String defaultSchema = outputType.getComplexOutput().getDefault().getFormat().getSchema();
                        if (defaultSchema.equalsIgnoreCase(schema)) {
                            arrayList.add(outputType.getComplexOutput().getDefault().getFormat());
                        } else {
                            for (ComplexDataDescriptionType tempFormat : formats2 = outputType.getComplexOutput().getSupported().getFormatArray()) {
                                if (!tempFormat.getEncoding().equalsIgnoreCase(schema)) continue;
                                arrayList.add(tempFormat);
                            }
                        }
                        ComplexDataDescriptionType foundCommonFormat = null;
                        for (ComplexDataDescriptionType encodingFormat : foundEncodingList) {
                            for (ComplexDataDescriptionType schemaFormat : arrayList) {
                                if (!encodingFormat.equals(schemaFormat)) continue;
                                foundCommonFormat = encodingFormat;
                            }
                        }
                        if (foundCommonFormat != null) {
                            mimeType = foundCommonFormat.getMimeType();
                            if (foundCommonFormat.isSetEncoding()) {
                                finalEncoding = foundCommonFormat.getEncoding();
                            }
                            if (foundCommonFormat.isSetSchema()) {
                                finalSchema = foundCommonFormat.getSchema();
                            }
                        } else {
                            throw new ExceptionReport("Request incomplete. Could not determine a suitable input format based on the given input [mime Type missing and given encoding and schema are not unique]", "MissingParameterValue");
                        }
                    }
                }
            }
        }
        this.schema = finalSchema;
        if (this.encoding == null) {
            this.encoding = finalEncoding;
        }
        this.mimeType = finalMimeType;
    }

    protected void prepareGenerator() throws ExceptionReport {
        Class algorithmOutput = RepositoryManager.getInstance().getOutputDataTypeForAlgorithm(this.algorithmIdentifier, this.id);
        LOGGER.debug("Looking for matching Generator: schema: {}, mimeType {}, encoding: {}", new Object[]{this.schema, this.mimeType, this.encoding});
        GeneratorFactory factory = GeneratorFactory.getInstance();
        this.generator = factory.getGenerator(this.schema, this.mimeType, this.encoding, algorithmOutput);
        if (this.generator != null) {
            LOGGER.info("Using generator " + this.generator.getClass().getName() + " for Schema: " + this.schema);
        }
        if (this.generator == null) {
            throw new ExceptionReport("Could not find an appropriate generator based on given mimetype/schema/encoding for output", "NoApplicableCode");
        }
    }
}

