/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.interfaces.ComputationalAgent;
import org.gcube.dataanalysis.ecoengine.processing.factories.ClusterersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.EvaluatorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.GeneratorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.ModelersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.TransducerersFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.infrastructure.DatabaseInfo;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.infrastructure.InfrastructureDialoguer;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.infrastructure.TableCoherenceChecker;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.IClusterer;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.IEvaluator;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.IGenerator;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.IModeller;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.ITransducer;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.ConfigurationManager;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.InputsManager;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.OutputsManager;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.TokenManager;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.dataspace.ComputationData;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.dataspace.DataspaceManager;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.dataspace.StoredData;
import org.hibernate.SessionFactory;
import org.n52.wps.algorithm.annotation.Execute;
import org.n52.wps.server.AbstractAnnotatedAlgorithm;
import org.n52.wps.server.database.DatabaseFactory;
import org.slf4j.LoggerFactory;

public class AbstractEcologicalEngineMapper
extends AbstractAnnotatedAlgorithm {
    public LinkedHashMap<String, Object> inputs = new LinkedHashMap();
    public LinkedHashMap<String, Object> outputs = new LinkedHashMap();
    public LinkedHashMap<String, Long> times = new LinkedHashMap();
    public String startTime;
    public String endTime;
    public static HashMap<String, DatabaseInfo> databaseParametersMemoryCache = new HashMap();
    public static HashMap<String, String> runningcomputations = new HashMap();
    ComputationalAgent agent;
    public String wpsExternalID = null;
    ComputationData currentComputation;
    public AlgorithmConfiguration config;
    public InfrastructureDialoguer infrastructureDialoguer;
    long statusInterrupt = 0L;
    float previousStatus = -3.0f;

    public void setWpsExternalID(String wpsExternalID) {
        this.wpsExternalID = wpsExternalID;
    }

    public static synchronized void addComputation(String session, String user) {
        runningcomputations.put(session, user);
    }

    public static synchronized void removeComputation(String session) {
        runningcomputations.remove(session);
    }

    public static synchronized int getRuningComputations() {
        return runningcomputations.size();
    }

    public static synchronized String displayRunningComputations() {
        return runningcomputations.toString();
    }

    public void waitForResources() throws Exception {
        while (AbstractEcologicalEngineMapper.getRuningComputations() > ConfigurationManager.getMaxComputations()) {
            Thread.sleep(20000L);
            AnalysisLogger.getLogger().debug((Object)("Waiting for resources to be available: " + AbstractEcologicalEngineMapper.displayRunningComputations()));
        }
    }

    public static synchronized DatabaseInfo getDatabaseInfo(String scope) {
        return databaseParametersMemoryCache.get(scope);
    }

    public static synchronized void addDatabaseInfo(String scope, DatabaseInfo info) {
        databaseParametersMemoryCache.put(scope, info);
    }

    public ComputationalAgent getComputationalAgent(String algorithmName) throws Exception {
        AnalysisLogger.getLogger().debug((Object)("Searching for Agents.. " + algorithmName));
        List agents = new ArrayList();
        if (this instanceof ITransducer) {
            agents = TransducerersFactory.getTransducerers((AlgorithmConfiguration)this.config);
        } else if (this instanceof IClusterer) {
            agents = ClusterersFactory.getClusterers((AlgorithmConfiguration)this.config);
        } else if (this instanceof IEvaluator) {
            agents = EvaluatorsFactory.getEvaluators((AlgorithmConfiguration)this.config);
        } else if (this instanceof IGenerator) {
            agents = GeneratorsFactory.getGenerators((AlgorithmConfiguration)this.config);
        } else if (this instanceof IModeller) {
            agents = ModelersFactory.getModelers((AlgorithmConfiguration)this.config);
        }
        if (agents != null && agents.size() > 0 && agents.get(0) != null) {
            AnalysisLogger.getLogger().debug((Object)("Found " + agents.size() + " Agents for " + algorithmName));
            ComputationalAgent agent = (ComputationalAgent)agents.get(0);
            agent.setConfiguration(this.config);
            return agent;
        }
        return null;
    }

    public List<StatisticalType> getInputParameters(String algorithmName) throws Exception {
        AnalysisLogger.getLogger().debug((Object)("Searching for Agents Inputs.. " + algorithmName));
        ArrayList<StatisticalType> parameters = new ArrayList();
        if (this instanceof ITransducer) {
            parameters = TransducerersFactory.getTransducerParameters((AlgorithmConfiguration)this.config, (String)algorithmName);
        } else if (this instanceof IClusterer) {
            parameters = ClusterersFactory.getClustererParameters((String)this.config.getConfigPath(), (String)algorithmName);
        } else if (this instanceof IEvaluator) {
            parameters = EvaluatorsFactory.getEvaluatorParameters((String)this.config.getConfigPath(), (String)algorithmName);
        } else if (this instanceof IGenerator) {
            parameters = GeneratorsFactory.getAlgorithmParameters((String)this.config.getConfigPath(), (String)algorithmName);
        } else if (this instanceof IModeller) {
            parameters = ModelersFactory.getModelParameters((String)this.config.getConfigPath(), (String)algorithmName);
        }
        if (parameters != null) {
            AnalysisLogger.getLogger().debug((Object)("Found " + parameters.size() + " Parameters for " + algorithmName));
            return parameters;
        }
        return null;
    }

    public StatisticalType getOutput(String algorithmName) throws Exception {
        AnalysisLogger.getLogger().debug((Object)("Searching for Agents Inputs.. " + algorithmName));
        StatisticalType output = null;
        if (this instanceof ITransducer) {
            output = TransducerersFactory.getTransducerOutput((AlgorithmConfiguration)this.config, (String)algorithmName);
        } else if (this instanceof IClusterer) {
            output = ClusterersFactory.getClustererOutput((String)this.config.getConfigPath(), (String)algorithmName);
        } else if (this instanceof IEvaluator) {
            output = EvaluatorsFactory.getEvaluatorOutput((String)this.config.getConfigPath(), (String)algorithmName);
        } else if (this instanceof IGenerator) {
            output = GeneratorsFactory.getAlgorithmOutput((String)this.config.getConfigPath(), (String)algorithmName);
        } else if (this instanceof IModeller) {
            output = ModelersFactory.getModelOutput((String)this.config.getConfigPath(), (String)algorithmName);
        }
        if (output != null) {
            AnalysisLogger.getLogger().debug((Object)("Found " + output + " for " + algorithmName));
            return output;
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTemporaryTables(List<String> generatedInputTables) throws Exception {
        if (generatedInputTables != null && generatedInputTables.size() > 0) {
            SessionFactory dbConnection = null;
            try {
                dbConnection = DatabaseUtils.initDBSession((AlgorithmConfiguration)this.config);
                for (String table : generatedInputTables) {
                    if (table != null) {
                        if (TableCoherenceChecker.isSystemTable(table)) continue;
                        AnalysisLogger.getLogger().debug((Object)("Dropping Temporary Table: " + table));
                        try {
                            org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory.executeSQLUpdate((String)("drop table " + table), (SessionFactory)dbConnection);
                        }
                        catch (Exception e) {
                            AnalysisLogger.getLogger().debug((Object)("Could not drop Temporary Table: " + table));
                        }
                        continue;
                    }
                    AnalysisLogger.getLogger().debug((Object)("Could not drop Temporary Table: " + table + " table is null"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                AnalysisLogger.getLogger().debug((Object)e);
            }
            finally {
                DatabaseUtils.closeDBConnection((SessionFactory)dbConnection);
            }
        }
    }

    public static void deleteGeneratedFiles(List<File> generatedFiles) throws Exception {
        System.gc();
        if (generatedFiles != null) {
            for (File file : generatedFiles) {
                if (file.exists()) {
                    AnalysisLogger.getLogger().debug((Object)("Deleting File " + file.getAbsolutePath()));
                    try {
                        AnalysisLogger.getLogger().debug((Object)("Deleting File Check " + file.delete()));
                    }
                    catch (Exception exception) {}
                    continue;
                }
                AnalysisLogger.getLogger().debug((Object)("Deleting File - File does not exist " + file.getAbsolutePath()));
            }
        }
        System.gc();
    }

    public void manageUserToken() {
        String scope = null;
        String username = null;
        TokenManager tokenm = new TokenManager();
        tokenm.getCredentials();
        scope = tokenm.getScope();
        username = tokenm.getUserName();
        this.inputs.put(ConfigurationManager.scopeParameter, scope);
        this.inputs.put(ConfigurationManager.usernameParameter, username);
    }

    public void updateStatus(float status) {
        if (this.agent != null) {
            long stream = 0L;
            try {
                stream = DatabaseFactory.getDatabase().getContentLengthForStoreResponse(this.wpsExternalID);
                if (this.statusInterrupt == 0L || this.statusInterrupt > stream - 3L && stream != 468L) {
                    this.statusInterrupt = stream;
                } else {
                    AnalysisLogger.getLogger().debug((Object)"STATUS INTERRUPTED!");
                    this.agent.shutdown();
                    this.statusInterrupt = -1L;
                    this.agent = null;
                    status = -1.0f;
                    super.update((Object)new Integer((int)status));
                    this.updateComputationOnWS(status, null);
                    System.gc();
                }
                if (status != this.previousStatus) {
                    AnalysisLogger.getLogger().debug((Object)("STATUS update to:" + status + " - status interrupt " + this.statusInterrupt));
                    this.previousStatus = status;
                    super.update((Object)new Integer((int)status));
                    this.updateComputationOnWS(status, null);
                }
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().debug((Object)("WARNING: STATUS RETRIEVAL EXCEPTION " + e.getLocalizedMessage()));
            }
        }
    }

    public void updateComputationOnWS(float status, String exception) {
        this.updateComputationOnWS(status, exception, null, null);
    }

    public void updateComputationOnWS(float status, String exception, List<StoredData> inputData, List<File> generatedData) {
        if (this.currentComputation != null) {
            this.currentComputation.setStatus("" + status);
            if (exception != null && exception.length() > 0) {
                this.currentComputation.setException(exception);
            }
            DataspaceManager manager = new DataspaceManager(this.config, this.currentComputation, inputData, null, generatedData);
            try {
                manager.writeRunningComputationData();
            }
            catch (Exception ez) {
                AnalysisLogger.getLogger().debug((Object)"Dataspace->Status updater->Impossible to write computation information on the Workspace");
                AnalysisLogger.getLogger().debug((Object)ez);
            }
        }
    }

    @Execute
    public void run() throws Exception {
        String algorithm = "";
        List<String> generatedInputTables = null;
        List<String> generatedOutputTables = null;
        List<File> generatedFiles = null;
        String date = new SimpleDateFormat("dd_MM_yyyy_HH:mm:ss").format(System.currentTimeMillis());
        String computationSession = this.getAlgorithmClass().getSimpleName() + "_ID_" + UUID.randomUUID().toString();
        if (this.wpsExternalID != null) {
            AnalysisLogger.getLogger().info((Object)("Using wps External ID " + this.wpsExternalID));
            computationSession = this.getAlgorithmClass().getSimpleName() + "_ID_" + this.wpsExternalID;
        } else {
            AnalysisLogger.getLogger().info((Object)"Wps External ID not set");
        }
        InputsManager inputsManager = null;
        try {
            this.startTime = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(System.currentTimeMillis());
            this.time("WPS Algorithm objects Initialization: Session " + computationSession);
            Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
            root.setLevel(Level.OFF);
            ConfigurationManager configManager = new ConfigurationManager();
            this.manageUserToken();
            configManager.configAlgorithmEnvironment(this.inputs);
            configManager.setComputationId(computationSession);
            this.config = configManager.getConfig();
            AnalysisLogger.getLogger().info((Object)("Configured algorithm with session " + computationSession));
            this.time("Configuration");
            this.waitForResources();
            AnalysisLogger.getLogger().info((Object)("Running algorithm with session " + computationSession));
            this.time("Waiting time for resources to be free");
            AbstractEcologicalEngineMapper.addComputation(computationSession, configManager.getUsername() + ":" + configManager.getScope());
            String scope = configManager.getScope();
            String username = configManager.getUsername();
            AnalysisLogger.getLogger().info((Object)("1 - Algorithm environment initialized in scope " + scope + " with user name " + username + " and session " + computationSession));
            AnalysisLogger.getLogger().info((Object)("Max allowed computations " + ConfigurationManager.getMaxComputations() + " using storage " + ConfigurationManager.useStorage()));
            AnalysisLogger.getLogger().info((Object)"2 - Initializing connection to the e-Infrastructure");
            this.infrastructureDialoguer = new InfrastructureDialoguer(scope);
            this.time("Connection to the e-Infrastructure initialized");
            AnalysisLogger.getLogger().info((Object)"3 - Initializing connection to the e-Infrastructure central database for computations");
            DatabaseInfo supportDatabaseInfo = AbstractEcologicalEngineMapper.getDatabaseInfo(scope);
            if (supportDatabaseInfo == null) {
                supportDatabaseInfo = this.infrastructureDialoguer.getDatabaseInfo("StatisticalManagerDataBase");
                AbstractEcologicalEngineMapper.addDatabaseInfo(scope, supportDatabaseInfo);
            } else {
                AnalysisLogger.getLogger().info((Object)("Using cached database information: " + supportDatabaseInfo));
            }
            AnalysisLogger.getLogger().info((Object)("Retrieved Central Database: " + supportDatabaseInfo));
            inputsManager = new InputsManager(this.inputs, this.config, computationSession);
            inputsManager.configSupportDatabaseParameters(supportDatabaseInfo);
            this.time("Central database information retrieval");
            AnalysisLogger.getLogger().info((Object)"4 - Retrieving WPS algorithm name");
            algorithm = this.getAlgorithmClass().getSimpleName();
            AnalysisLogger.getLogger().debug((Object)("Selected Algorithm: " + algorithm));
            this.config.setAgent(algorithm);
            this.config.setModel(algorithm);
            this.time("Ecological Engine Algorithm selection");
            AnalysisLogger.getLogger().info((Object)"5 - Adding Service parameters to the configuration");
            inputsManager.addInputServiceParameters(this.getInputParameters(algorithm), this.infrastructureDialoguer);
            this.time("Service parameters added to the algorithm");
            AnalysisLogger.getLogger().info((Object)"6 - Translating WPS Inputs into Ecological Engine Inputs");
            AnalysisLogger.getLogger().debug((Object)("Operator class is " + ((Object)((Object)this)).getClass().getCanonicalName()));
            this.currentComputation = new ComputationData(this.config.getTaskID(), this.config.getAgent(), "", "", this.startTime, "-", "0", this.config.getTaskID(), configManager.getUsername(), this.config.getGcubeScope(), ((Object)((Object)this)).getClass().getCanonicalName());
            inputsManager.mergeWpsAndEcologicalInputs(supportDatabaseInfo);
            generatedInputTables = inputsManager.getGeneratedTables();
            generatedFiles = inputsManager.getGeneratedInputFiles();
            this.time("Setup and download of input parameters with tables creation");
            AnalysisLogger.getLogger().info((Object)"7 - Retrieving Ecological Engine algorithm");
            this.agent = this.getComputationalAgent(algorithm);
            this.currentComputation.setOperatorDescription(this.agent.getDescription());
            this.currentComputation.setInfrastructure(this.agent.getInfrastructure().name());
            AnalysisLogger.getLogger().debug((Object)("Found Ecological Engine Algorithm: " + this.agent));
            this.time("Algorithm initialization");
            AnalysisLogger.getLogger().info((Object)"8 - Retrieving the a priori output of the algorithm");
            StatisticalType prioroutput = null;
            try {
                prioroutput = this.getOutput(algorithm);
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().info((Object)("Warning: No a priori output for algorithm " + algorithm));
            }
            this.time("A priori output retrieval");
            AnalysisLogger.getLogger().info((Object)"9 - Running the computation and updater");
            AnalysisLogger.getLogger().info((Object)"Initializing the computation");
            this.updateStatus(0.0f);
            this.agent.init();
            AnalysisLogger.getLogger().info((Object)"Updating status");
            this.runStatusUpdater();
            AnalysisLogger.getLogger().info((Object)"Running the computation");
            this.agent.compute();
            AnalysisLogger.getLogger().info((Object)"The computation has finished. Retrieving output");
            this.time("Execution time");
            AnalysisLogger.getLogger().info((Object)"10 - Retrieving the a posteriori output of the algorithm");
            StatisticalType postoutput = this.agent.getOutput();
            AnalysisLogger.getLogger().debug((Object)("Computation Output: " + postoutput));
            this.time("Output retrieval");
            AnalysisLogger.getLogger().info((Object)"11 - Merging the a priori and a posteriori output");
            OutputsManager outputmanager = new OutputsManager(this.config, computationSession);
            this.outputs = outputmanager.createOutput(prioroutput, postoutput);
            generatedOutputTables = outputmanager.getGeneratedTables();
            if (ConfigurationManager.useStorage().booleanValue()) {
                generatedFiles.addAll(outputmanager.getGeneratedFiles());
                this.time("Output preparation for WPS document (using storage)");
            } else {
                this.time("Output preparation for WPS document (no storage manager)");
            }
            outputmanager.shutdown();
            AnalysisLogger.getLogger().info((Object)"12 - Deleting possible generated temporary tables");
            AnalysisLogger.getLogger().debug((Object)("Final Computation Output: " + this.outputs));
            this.endTime = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(System.currentTimeMillis());
            if (this.statusInterrupt == -1L) {
                AnalysisLogger.getLogger().debug((Object)"Computation interrupted - no update");
                throw new Exception("Computation cancelled");
            }
            this.saveComputationOnWS(inputsManager.getProvenanceData(), outputmanager.getProvenanceData(), this.agent, generatedFiles);
            AnalysisLogger.getLogger().debug((Object)"All done");
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)("Error in Algorithm execution: " + algorithm));
            AnalysisLogger.getLogger().debug((Object)e);
            e.printStackTrace();
            int exitstatus = -2;
            if (this.statusInterrupt == -1L) {
                exitstatus = -1;
            }
            if (inputsManager != null) {
                this.updateComputationOnWS(exitstatus, e.getMessage(), inputsManager.getProvenanceData(), generatedFiles);
            } else {
                this.updateComputationOnWS(exitstatus, e.getMessage());
            }
            if (this.statusInterrupt == -1L) {
                throw new Exception("Computation cancelled");
            }
            throw e;
        }
        finally {
            AnalysisLogger.getLogger().debug((Object)"Deleting Input Tables");
            this.deleteTemporaryTables(generatedInputTables);
            AnalysisLogger.getLogger().debug((Object)"Deleting Output Tables");
            this.deleteTemporaryTables(generatedOutputTables);
            AbstractEcologicalEngineMapper.removeComputation(computationSession);
            this.time("Cleaning of resources");
            this.displayTimes();
            this.cleanResources();
            AnalysisLogger.getLogger().debug((Object)"All done - Computation Finished");
        }
    }

    private void runStatusUpdater() {
        StatusUpdater updater = new StatusUpdater();
        Thread t = new Thread(updater);
        t.start();
        AnalysisLogger.getLogger().debug((Object)"Provenance manager running");
    }

    private void saveComputationOnWS(List<StoredData> inputData, List<StoredData> outputData, ComputationalAgent agent, List<File> generatedFiles) {
        AnalysisLogger.getLogger().debug((Object)("Provenance manager started for operator " + ((Object)((Object)this)).getClass().getCanonicalName()));
        ComputationData computation = new ComputationData(this.config.getTaskID(), this.config.getAgent(), agent.getDescription(), agent.getInfrastructure().name(), this.startTime, this.endTime, "100", this.config.getTaskID(), this.config.getParam(ConfigurationManager.serviceUserNameParameterVariable), this.config.getGcubeScope(), ((Object)((Object)this)).getClass().getCanonicalName());
        DataspaceManager manager = new DataspaceManager(this.config, computation, inputData, outputData, generatedFiles);
        Thread t = new Thread(manager);
        t.start();
        AnalysisLogger.getLogger().debug((Object)"Provenance manager running");
    }

    private void time(String label) {
        this.times.put(label, System.currentTimeMillis());
    }

    private void displayTimes() {
        AnalysisLogger.getLogger().debug((Object)"Times Summary:");
        AnalysisLogger.getLogger().debug((Object)"Label;Elapsed(ms);Time");
        long prevtime = 0L;
        long inittime = 0L;
        for (String label : this.times.keySet()) {
            long currentTime = this.times.get(label);
            if (prevtime == 0L) {
                prevtime = currentTime;
                inittime = currentTime;
            }
            AnalysisLogger.getLogger().debug((Object)(label + ";" + (currentTime - prevtime) + ";" + new Date(currentTime)));
            prevtime = currentTime;
        }
        AnalysisLogger.getLogger().debug((Object)("Total Elapsed;" + (prevtime - inittime) + ";" + new Date(prevtime)));
    }

    private void cleanResources() {
        this.times = null;
        this.agent = null;
        AnalysisLogger.getLogger().debug((Object)"Managing open files");
        try {
            String checkOpenFiles = "for i in `ls -l /proc/*/fd/* 2>/dev/null | grep delete | grep tomcat | awk '{print $9}'`; do du -hL $i | awk '{print $1}' | tr '\n' ' '; ls -l $i | awk '{print $6\" \"$7\" \"$8\" \"$9\" \"$10\" \"$11\" \"$12}'; done";
            List<String> openFiles = AbstractEcologicalEngineMapper.command(checkOpenFiles, "./");
            AnalysisLogger.getLogger().debug((Object)("Open Files " + openFiles));
            if (openFiles != null) {
                for (String openFile : openFiles) {
                    if (openFile.contains("cannot access") || !openFile.contains("(deleted)")) continue;
                    String size = openFile.substring(0, openFile.indexOf(" ")).trim();
                    String pid = openFile.substring(openFile.indexOf("/proc/"), openFile.indexOf("->"));
                    pid = pid.trim();
                    if (size.equals("0")) continue;
                    AnalysisLogger.getLogger().debug((Object)("Killing " + pid + " with size " + size));
                    AbstractEcologicalEngineMapper.command(":>" + pid, "./");
                }
            }
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)("Could not kill files " + e.getLocalizedMessage()));
        }
        System.gc();
    }

    public static List<String> command(String cmdline, String directory) {
        try {
            Process process = new ProcessBuilder("bash", "-c", cmdline).redirectErrorStream(true).directory(new File(directory)).start();
            ArrayList<String> output = new ArrayList<String>();
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            while ((line = br.readLine()) != null) {
                output.add(line);
            }
            if (0 != process.waitFor()) {
                return null;
            }
            return output;
        }
        catch (Exception e) {
            return null;
        }
    }

    public class StatusUpdater
    implements Runnable {
        @Override
        public void run() {
            while (AbstractEcologicalEngineMapper.this.agent != null && AbstractEcologicalEngineMapper.this.statusInterrupt != -1L && AbstractEcologicalEngineMapper.this.agent.getStatus() < 100.0f) {
                try {
                    AbstractEcologicalEngineMapper.this.updateStatus(AbstractEcologicalEngineMapper.this.agent.getStatus());
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            AnalysisLogger.getLogger().info((Object)"Status updater terminated");
        }
    }
}

