/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.dataspace;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.HomeManager;
import org.gcube.common.homelibrary.home.HomeManagerFactory;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.util.WorkspaceUtil;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.FileTools;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.AbstractEcologicalEngineMapper;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.dataspace.ComputationData;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.dataspace.ProvOGenerator;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.dataspace.StoredData;

public class DataspaceManager
implements Runnable {
    public static String dataminerFolder = "DataMiner";
    public static String importedDataFolder = "Input Data Sets";
    public static String computedDataFolder = "Output Data Sets";
    public static String computationsFolder = "Computations";
    AlgorithmConfiguration config;
    ComputationData computation;
    List<StoredData> inputData;
    List<StoredData> outputData;
    List<File> generatedFiles;
    public static String computation_id = "computation_id";
    public static String data_id = "data_id";
    public static String data_type = "data_type";
    public static String operator_name = "operator_name";
    public static String operator_id = "operator_id";
    public static String vre = "VRE";
    public static String operator_description = "operator_description";
    public static String data_description = "data_description";
    public static String creation_date = "creation_date";
    public static String start_date = "start_date";
    public static String end_date = "end_date";
    public static String status = "status";
    public static String execution_platform = "execution_platform";
    public static String error = "error";
    public static String IO = "IO";
    public static String operator = "operator_name";
    public static String payload = "payload";

    public DataspaceManager(AlgorithmConfiguration config, ComputationData computation, List<StoredData> inputData, List<StoredData> outputData, List<File> generatedFiles) {
        this.config = config;
        this.computation = computation;
        this.inputData = inputData;
        this.outputData = outputData;
        this.generatedFiles = generatedFiles;
    }

    @Override
    public void run() {
        try {
            AnalysisLogger.getLogger().debug((Object)"Dataspace->Deleting running computation");
            try {
                this.deleteRunningComputationData();
            }
            catch (Exception e) {
                e.printStackTrace();
                AnalysisLogger.getLogger().debug((Object)"Dataspace->No running computation available");
            }
            AnalysisLogger.getLogger().debug((Object)"Dataspace->Writing provenance information");
            this.writeProvenance(this.computation, this.inputData, this.outputData);
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().debug((Object)("Dataspace-> error writing provenance information " + e.getLocalizedMessage()));
            AnalysisLogger.getLogger().debug((Object)e);
        }
    }

    public void createFoldersNetwork(Workspace ws, WorkspaceFolder root) throws Exception {
        WorkspaceFolder dataminerFolderWS;
        AnalysisLogger.getLogger().debug((Object)"Dataspace->Creating folders for DataMiner");
        if (!ws.exists(dataminerFolder, root.getId())) {
            AnalysisLogger.getLogger().debug((Object)"Dataspace->Creating DataMiner main folder");
            root.createFolder(dataminerFolder, "A folder collecting DataMiner experiments data and computation information");
            ((WorkspaceFolder)root.find(dataminerFolder)).setSystemFolder(true);
        }
        if (!ws.exists(importedDataFolder, (dataminerFolderWS = (WorkspaceFolder)root.find(dataminerFolder)).getId())) {
            AnalysisLogger.getLogger().debug((Object)"Dataspace->Creating DataMiner imported data folder");
            dataminerFolderWS.createFolder(importedDataFolder, "A folder collecting DataMiner imported data");
        }
        if (!ws.exists(computedDataFolder, dataminerFolderWS.getId())) {
            AnalysisLogger.getLogger().debug((Object)"Dataspace->Creating DataMiner computed data folder");
            dataminerFolderWS.createFolder(computedDataFolder, "A folder collecting DataMiner computed data");
        }
        if (!ws.exists(computationsFolder, dataminerFolderWS.getId())) {
            AnalysisLogger.getLogger().debug((Object)"Dataspace->Creating DataMiner computations folder");
            dataminerFolderWS.createFolder(computationsFolder, "A folder collecting DataMiner computations information");
        }
    }

    public String uploadData(StoredData data, WorkspaceFolder wsFolder) throws Exception {
        return this.uploadData(data, wsFolder, true);
    }

    public String uploadData(StoredData data, WorkspaceFolder wsFolder, boolean changename) throws Exception {
        String url;
        block15: {
            AnalysisLogger.getLogger().debug((Object)("Dataspace->Analysing " + data.name));
            String filenameonwsString = data.name;
            if (changename) {
                filenameonwsString = data.name + "_[" + data.computationId + "]";
                if (data.type.equals("text/csv")) {
                    filenameonwsString = filenameonwsString + ".csv";
                } else if (data.type.equals("image/png")) {
                    filenameonwsString = filenameonwsString + ".png";
                }
            }
            InputStream in = null;
            url = "";
            try {
                long size = 0L;
                if (data.type.equals("text/csv") || data.type.equals("application/d4science") || data.type.equals("image/png")) {
                    if (new File(data.payload).exists() || !data.payload.startsWith("http")) {
                        AnalysisLogger.getLogger().debug((Object)("Dataspace->Uploading file " + data.payload));
                        in = new FileInputStream(new File(data.payload));
                        size = new File(data.payload).length();
                    } else {
                        AnalysisLogger.getLogger().debug((Object)("Dataspace->Uploading via URL " + data.payload));
                        int tries = 10;
                        for (int i = 0; i < tries; ++i) {
                            try {
                                URL urlc = new URL(data.payload);
                                HttpURLConnection urlConnection = (HttpURLConnection)urlc.openConnection();
                                urlConnection.setConnectTimeout(10000);
                                urlConnection.setReadTimeout(10000);
                                in = new BufferedInputStream(urlConnection.getInputStream());
                            }
                            catch (Exception ee) {
                                AnalysisLogger.getLogger().debug((Object)ee);
                                AnalysisLogger.getLogger().debug((Object)("Dataspace->Retrying connection to " + data.payload + " number " + (i + 1)));
                                in = null;
                            }
                            if (in != null) break;
                            Thread.sleep(10000L);
                        }
                    }
                    if (in == null) {
                        throw new Exception("Impossible to open stream from " + data.payload);
                    }
                    AnalysisLogger.getLogger().debug((Object)("Dataspace->WS OP saving the following file on the WS " + filenameonwsString));
                    LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
                    properties.put(computation_id, data.computationId);
                    properties.put(vre, data.vre);
                    properties.put(creation_date, data.creationDate);
                    properties.put(operator, data.operator);
                    properties.put(data_id, data.id);
                    properties.put(data_description, data.description);
                    properties.put(IO, data.provenance.name());
                    properties.put(data_type, data.type);
                    properties.put(payload, url);
                    FolderItem fileItem = WorkspaceUtil.createExternalFile((WorkspaceFolder)wsFolder, (String)filenameonwsString, (String)data.description, (InputStream)in, properties, (String)data.type, (long)size);
                    AnalysisLogger.getLogger().debug((Object)("Dataspace->WS OP file saved on the WS " + filenameonwsString));
                    url = fileItem.getPublicLink(true);
                    AnalysisLogger.getLogger().debug((Object)("Dataspace->WS OP url produced for the file " + url));
                    data.payload = url;
                    try {
                        in.close();
                    }
                    catch (Exception e) {
                        AnalysisLogger.getLogger().debug((Object)("Dataspace->Error creating file " + e.getMessage()));
                        AnalysisLogger.getLogger().debug((Object)e);
                    }
                    AnalysisLogger.getLogger().debug((Object)("Dataspace->File created " + filenameonwsString));
                    break block15;
                }
                AnalysisLogger.getLogger().debug((Object)("Dataspace->String parameter " + data.payload));
                url = data.payload;
            }
            catch (Throwable e) {
                e.printStackTrace();
                AnalysisLogger.getLogger().debug((Object)("Dataspace->Could not retrieve input payload " + data.payload + " - " + e.getLocalizedMessage()));
                AnalysisLogger.getLogger().debug((Object)e);
                data.payload = url = "payload was not made available for this dataset";
            }
        }
        return url;
    }

    public List<String> uploadInputData(List<StoredData> inputData, WorkspaceFolder dataminerFolder) throws Exception {
        AnalysisLogger.getLogger().debug((Object)("Dataspace->uploading input data; Number of data: " + inputData.size()));
        WorkspaceItem folderItem = dataminerFolder.find(importedDataFolder);
        ArrayList<String> urls = new ArrayList<String>();
        if (folderItem != null && folderItem.isFolder()) {
            WorkspaceFolder destinationFolder = (WorkspaceFolder)folderItem;
            for (StoredData input : inputData) {
                String url;
                WorkspaceItem item = null;
                if (input.type.equals("text/csv") || input.type.equals("application/d4science") || input.type.equals("image/png")) {
                    item = destinationFolder.find(input.name);
                }
                if (item == null) {
                    url = this.uploadData(input, destinationFolder, false);
                    AnalysisLogger.getLogger().debug((Object)("Dataspace->returning property " + url));
                    urls.add(url);
                    continue;
                }
                AnalysisLogger.getLogger().debug((Object)("Dataspace->Input item " + input.name + " is already available in the input folder"));
                url = item.getPublicLink(false);
                AnalysisLogger.getLogger().debug((Object)("Dataspace->returning WS url " + url));
                urls.add(url);
            }
        } else {
            AnalysisLogger.getLogger().debug((Object)"Dataspace->folder is not valid");
        }
        AnalysisLogger.getLogger().debug((Object)"Dataspace->finished uploading input data");
        return urls;
    }

    public List<String> uploadOutputData(List<StoredData> outputData, WorkspaceFolder dataminerFolder) throws Exception {
        AnalysisLogger.getLogger().debug((Object)("Dataspace->uploading output data; Number of data: " + outputData.size()));
        WorkspaceItem folderItem = dataminerFolder.find(computedDataFolder);
        ArrayList<String> urls = new ArrayList<String>();
        if (folderItem != null && folderItem.isFolder()) {
            WorkspaceFolder destinationFolder = (WorkspaceFolder)folderItem;
            for (StoredData output : outputData) {
                String url = this.uploadData(output, destinationFolder);
                urls.add(url);
            }
        } else {
            AnalysisLogger.getLogger().debug((Object)"Dataspace->folder is not valid");
        }
        AnalysisLogger.getLogger().debug((Object)"Dataspace->finished uploading output data");
        return urls;
    }

    public void uploadComputationData(ComputationData computation, List<StoredData> inputData, List<StoredData> outputData, WorkspaceFolder dataminerFolder, Workspace ws) throws Exception {
        AnalysisLogger.getLogger().debug((Object)"Dataspace->uploading computation data");
        WorkspaceItem folderItem = dataminerFolder.find(computationsFolder);
        if (folderItem != null && folderItem.isFolder()) {
            StoredData input;
            int i;
            AnalysisLogger.getLogger().debug((Object)("Dataspace->Creating computation folder " + computation.id));
            WorkspaceFolder cfolder = (WorkspaceFolder)folderItem;
            String cfoldername = computation.id;
            WorkspaceFolder newcomputationFolder = null;
            try {
                newcomputationFolder = cfolder.createFolder(cfoldername, computation.operatorDescription);
            }
            catch (ClassCastException e) {
                AnalysisLogger.getLogger().debug((Object)"Dataspace->concurrency exception - deleting remaining item");
                this.deleteRunningComputationData();
                newcomputationFolder = cfolder.createFolder(cfoldername, computation.operatorDescription);
            }
            String itemType = "COMPUTATION";
            AnalysisLogger.getLogger().debug((Object)("Dataspace->creating IO folders under " + cfoldername));
            newcomputationFolder.createFolder(importedDataFolder, importedDataFolder);
            newcomputationFolder.createFolder(computedDataFolder, computedDataFolder);
            AnalysisLogger.getLogger().debug((Object)"Dataspace->*****uploading inputs in IO folder*****");
            List<String> inputurls = this.uploadInputData(inputData, newcomputationFolder);
            AnalysisLogger.getLogger().debug((Object)"Dataspace->*****uploading outputs in IO folder*****");
            List<String> outputurls = this.uploadOutputData(outputData, newcomputationFolder);
            AnalysisLogger.getLogger().debug((Object)"Dataspace->*****adding properties to the folder*****");
            AnalysisLogger.getLogger().debug((Object)"Dataspace->creating Folder Properties");
            LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
            properties.put(computation_id, computation.id);
            properties.put(vre, computation.vre);
            properties.put(operator_name, this.config.getAgent());
            properties.put(operator_id, computation.operatorId);
            properties.put(operator_description, computation.operatorDescription);
            properties.put(start_date, computation.startDate);
            properties.put(end_date, computation.endDate);
            properties.put(status, this.getStatus(computation.status));
            properties.put(execution_platform, computation.infrastructure);
            int ninput = inputurls.size();
            int noutput = outputurls.size();
            AnalysisLogger.getLogger().debug((Object)("Dataspace->Adding input properties for " + ninput + " inputs"));
            for (i = 1; i <= ninput; ++i) {
                input = inputData.get(i - 1);
                if (!input.payload.contains("|")) continue;
                String payload = input.payload;
                AnalysisLogger.getLogger().debug((Object)("Dataspace->Managing complex input " + input.name + " : " + payload));
                for (StoredData subinput : inputData) {
                    if (!input.description.equals(subinput.description)) continue;
                    payload = payload.replace(subinput.name, subinput.payload);
                    subinput.name = null;
                }
                input.name = null;
                if (payload.endsWith("|")) {
                    payload = payload.substring(0, payload.length() - 1);
                }
                AnalysisLogger.getLogger().debug((Object)("Dataspace->Complex input after processing " + payload));
                properties.put("input" + i + "_" + input.description, payload);
                input.payload = payload;
            }
            for (i = 1; i <= ninput; ++i) {
                input = inputData.get(i - 1);
                if (input.name == null) continue;
                properties.put("input" + i + "_" + input.name, inputurls.get(i - 1));
            }
            AnalysisLogger.getLogger().debug((Object)("Dataspace->Adding output properties for " + noutput + " outputs"));
            for (i = 1; i <= noutput; ++i) {
                properties.put("output" + i + "_" + outputData.get((int)(i - 1)).name, outputurls.get(i - 1));
            }
            AnalysisLogger.getLogger().debug((Object)("Dataspace->Properties of the folder: " + properties));
            AnalysisLogger.getLogger().debug((Object)("Dataspace->Saving properties to ProvO XML file " + noutput + " outputs"));
            try {
                String xmlproperties = ProvOGenerator.toProvO(computation, inputData, outputData);
                File xmltosave = new File(this.config.getPersistencePath(), "prov_o_" + UUID.randomUUID());
                FileTools.saveString((String)xmltosave.getAbsolutePath(), (String)xmlproperties, (boolean)true, (String)"UTF-8");
                FileInputStream sis = new FileInputStream(xmltosave);
                WorkspaceUtil.createExternalFile((WorkspaceFolder)newcomputationFolder, (String)(computation.id + ".xml"), (String)computation.operatorDescription, (InputStream)sis, null, (String)"text/xml", (long)xmltosave.length());
                ((InputStream)sis).close();
                xmltosave.delete();
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().debug((Object)("Dataspace->Failed creating ProvO XML file " + e.getLocalizedMessage()));
                AnalysisLogger.getLogger().debug((Object)e);
                e.printStackTrace();
            }
            newcomputationFolder.getProperties().addProperties(properties);
        }
        AnalysisLogger.getLogger().debug((Object)"Dataspace->finished uploading computation data");
    }

    public String buildCompositePayload(List<StoredData> inputData, String payload, String inputName) {
        for (StoredData input : inputData) {
            if (!inputName.equals(input.description)) continue;
            payload = payload.replace(input.name, input.payload);
        }
        return payload;
    }

    public void writeProvenance(ComputationData computation, List<StoredData> inputData, List<StoredData> outputData) throws Exception {
        AnalysisLogger.getLogger().debug((Object)"Dataspace->connecting to Workspace");
        HomeManagerFactory factory = HomeLibrary.getHomeManagerFactory();
        HomeManager manager = factory.getHomeManager();
        AnalysisLogger.getLogger().debug((Object)"Dataspace->getting user");
        User user = manager.createUser(computation.user);
        Home home = manager.getHome(user);
        AnalysisLogger.getLogger().debug((Object)"Dataspace->getting root folder");
        Workspace ws = home.getWorkspace();
        WorkspaceFolder root = ws.getRoot();
        AnalysisLogger.getLogger().debug((Object)"Dataspace->create folders network");
        this.createFoldersNetwork(ws, root);
        WorkspaceFolder dataminerItem = (WorkspaceFolder)root.find(dataminerFolder);
        AnalysisLogger.getLogger().debug((Object)"Dataspace->****uploading input files****");
        this.uploadInputData(inputData, dataminerItem);
        AnalysisLogger.getLogger().debug((Object)"Dataspace->****uploading output files****");
        this.uploadOutputData(outputData, dataminerItem);
        AnalysisLogger.getLogger().debug((Object)"Dataspace->****uploading computation files****");
        this.uploadComputationData(computation, inputData, outputData, dataminerItem, ws);
        AnalysisLogger.getLogger().debug((Object)"Dataspace->provenance management finished");
        AnalysisLogger.getLogger().debug((Object)"Dataspace->deleting generated files");
        AbstractEcologicalEngineMapper.deleteGeneratedFiles(this.generatedFiles);
        AnalysisLogger.getLogger().debug((Object)"Dataspace->generated files deleted");
    }

    public void writeRunningComputationData() throws Exception {
        try {
            this.deleteRunningComputationData();
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().debug((Object)"Dataspace->impossible to delete running computation");
        }
        HomeManagerFactory factory = HomeLibrary.getHomeManagerFactory();
        HomeManager manager = factory.getHomeManager();
        User user = manager.createUser(this.computation.user);
        Home home = manager.getHome(user);
        Workspace ws = home.getWorkspace();
        WorkspaceFolder root = ws.getRoot();
        this.createFoldersNetwork(ws, root);
        WorkspaceFolder dataminerFolderWS = (WorkspaceFolder)root.find(dataminerFolder);
        WorkspaceItem computationsFolderItem = dataminerFolderWS.find(computationsFolder);
        String itemType = "COMPUTATION";
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put(computation_id, this.computation.id);
        properties.put(vre, this.computation.vre);
        properties.put(operator_name, this.config.getAgent());
        properties.put(operator_description, this.computation.operatorDescription);
        properties.put(operator_id, this.computation.operatorId);
        properties.put(start_date, this.computation.startDate);
        properties.put(end_date, this.computation.endDate);
        properties.put(status, this.getStatus(this.computation.status));
        properties.put(execution_platform, this.computation.infrastructure);
        if (this.computation.exception != null && this.computation.exception.length() > 0) {
            properties.put(error, this.computation.exception);
        }
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add(this.config.getGcubeScope());
        ws.createGcubeItem(this.computation.id, this.computation.operatorDescription, scopes, this.computation.user, itemType, properties, computationsFolderItem.getId());
        AnalysisLogger.getLogger().debug((Object)"Dataspace->finished uploading computation data");
    }

    public String getStatus(String status) {
        double statusD = 0.0;
        try {
            statusD = Double.parseDouble(status);
        }
        catch (Exception e) {
            return status;
        }
        if (statusD == 100.0) {
            return "completed";
        }
        if (statusD == -2.0) {
            return "error";
        }
        if (statusD == -1.0) {
            return "cancelled";
        }
        return status;
    }

    public void deleteRunningComputationData() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"Dataspace->deleting computation item");
        AnalysisLogger.getLogger().debug((Object)"Dataspace->connecting to Workspace");
        HomeManagerFactory factory = HomeLibrary.getHomeManagerFactory();
        HomeManager manager = factory.getHomeManager();
        AnalysisLogger.getLogger().debug((Object)"Dataspace->getting user");
        User user = manager.createUser(this.computation.user);
        Home home = manager.getHome(user);
        AnalysisLogger.getLogger().debug((Object)"Dataspace->getting root folder");
        Workspace ws = home.getWorkspace();
        WorkspaceFolder root = ws.getRoot();
        WorkspaceFolder dataminerFolderWS = (WorkspaceFolder)root.find(dataminerFolder);
        WorkspaceItem computationsFolderItem = dataminerFolderWS.find(computationsFolder);
        AnalysisLogger.getLogger().debug((Object)"Dataspace->removing computation data");
        WorkspaceFolder computationsFolderWs = (WorkspaceFolder)computationsFolderItem;
        WorkspaceItem wi = computationsFolderWs.find(this.computation.id);
        if (wi != null) {
            AnalysisLogger.getLogger().debug((Object)("Dataspace->Found " + this.computation.id + " under " + computationsFolderWs.getName() + " - removing"));
            wi.remove();
        } else {
            AnalysisLogger.getLogger().debug((Object)("Dataspace->Warning Could not find " + this.computation.id + " under " + computationsFolderWs.getName()));
        }
        int maxtries = 3;
        for (int i = 1; ws.exists(this.computation.id, computationsFolderWs.getId()) && i < maxtries; ++i) {
            AnalysisLogger.getLogger().debug((Object)("Dataspace->computation data still exist... retrying " + i));
            Thread.sleep(1000L);
            computationsFolderWs.find(this.computation.id).remove();
        }
        AnalysisLogger.getLogger().debug((Object)("Dataspace->finished removing computation data - success " + !ws.exists(this.computation.id, computationsFolderWs.getId())));
    }
}

