/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.connectors.netcdf;

import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.gcube.contentmanagement.graphtools.utils.MathFunctions;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.utils.Tuple;
import org.gcube.dataanalysis.geo.utils.VectorOperations;
import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayLong;
import ucar.ma2.Range;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.FeatureCollection;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.PointDatasetImpl;
import ucar.nc2.ft.point.standard.StandardPointCollectionImpl;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public class NetCDFDataExplorer {
    public static String timePrefix = "time:";
    public double minZ = 0.0;
    public double maxZ = 0.0;
    GridDataset gds;

    public NetCDFDataExplorer(String openDapLink, String layer) {
        this.calcZRange(openDapLink, layer);
    }

    public List<Double> retrieveDataFromNetCDF(String openDapLink, String layer, int time, List<Tuple<Double>> triplets) {
        try {
            ArrayList<Double> values = new ArrayList<Double>();
            if (NetCDFDataExplorer.isGridDataset(openDapLink)) {
                AnalysisLogger.getLogger().debug((Object)"Managing Grid File");
                return this.manageGridDataset(layer, openDapLink, time, triplets);
            }
            AnalysisLogger.getLogger().debug((Object)"Warning: the NETCDF file is of an unknown type");
            return values;
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)("ERROR: " + e.getMessage()));
            AnalysisLogger.getLogger().debug((Object)e);
            return null;
        }
    }

    public void calcZRange(String openDapLink, String layer) {
        block3: {
            try {
                if (!NetCDFDataExplorer.isGridDataset(openDapLink)) break block3;
                this.gds = GridDataset.open((String)openDapLink);
                List gridTypes = this.gds.getGrids();
                for (GridDatatype gdt : gridTypes) {
                    AnalysisLogger.getLogger().debug((Object)("Inside File - layer name: " + gdt.getName()));
                    if (!layer.equalsIgnoreCase(gdt.getName())) continue;
                    CoordinateAxis1D zAxis = gdt.getCoordinateSystem().getVerticalAxis();
                    this.minZ = zAxis.getMinValue();
                    this.maxZ = zAxis.getMaxValue();
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                AnalysisLogger.getLogger().debug((Object)("NetCDF Explorer Error:" + e.getLocalizedMessage()));
                AnalysisLogger.getLogger().debug((Object)e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Double> manageGridDataset(String layer, String filename, int time, List<Tuple<Double>> triplets) throws Exception {
        ArrayList<Double> values = new ArrayList<Double>();
        if (this.gds == null) {
            this.gds = GridDataset.open((String)filename);
        }
        List gridTypes = this.gds.getGrids();
        for (GridDatatype gdt : gridTypes) {
            AnalysisLogger.getLogger().debug((Object)("Inside File - layer name: " + gdt.getName() + " layer to find " + layer));
            if (!layer.equalsIgnoreCase(gdt.getName()) && !layer.toLowerCase().startsWith("http:")) continue;
            AnalysisLogger.getLogger().debug((Object)("Found layer " + layer + " inside file"));
            GridDatatype grid = this.gds.findGridDatatype(gdt.getName());
            CoordinateAxis1D zAxis = gdt.getCoordinateSystem().getVerticalAxis();
            CoordinateAxis xAxis = gdt.getCoordinateSystem().getXHorizAxis();
            CoordinateAxis yAxis = gdt.getCoordinateSystem().getYHorizAxis();
            double resolutionZ = 0.0;
            try {
                resolutionZ = Math.abs((zAxis.getMaxValue() - zAxis.getMinValue()) / (double)zAxis.getShape()[0]);
                AnalysisLogger.getLogger().debug((Object)("Zmin:" + zAxis.getMinValue() + " Zmax:" + zAxis.getMaxValue()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            GridCoordSystem gcs = grid.getCoordinateSystem();
            int tsize = triplets.size();
            long t01 = System.currentTimeMillis();
            LatLonRect llr = null;
            AnalysisLogger.getLogger().debug((Object)"Extracting subset...");
            GridDatatype gdtsub = grid.makeSubset(new Range(time, time), null, llr, 1, 1, 1);
            Array data = gdtsub.readVolumeData(time);
            int[] shapeD = data.getShape();
            int zD = 0;
            int xD = 0;
            int yD = 0;
            if (shapeD.length > 2) {
                zD = shapeD[0];
                yD = shapeD[1];
                xD = shapeD[2];
            } else if (shapeD.length > 1) {
                yD = shapeD[0];
                xD = shapeD[1];
            }
            double resolutionX = Math.abs((xAxis.getMaxValue() - xAxis.getMinValue()) / (double)xD);
            double resolutionY = Math.abs((yAxis.getMaxValue() - yAxis.getMinValue()) / (double)yD);
            AnalysisLogger.getLogger().debug((Object)("Shape: Z:" + zD + " X:" + xD + " Y:" + yD));
            AnalysisLogger.getLogger().debug((Object)("Layer Information Retrieval ELAPSED Time: " + (System.currentTimeMillis() - t01)));
            int rank = data.getRank();
            AnalysisLogger.getLogger().debug((Object)("Rank of the layer: " + rank));
            ArrayFloat.D3 data3Float = null;
            ArrayDouble.D3 data3Double = null;
            ArrayInt.D3 data3Int = null;
            ArrayLong.D3 data3Long = null;
            ArrayFloat.D2 data2Float = null;
            ArrayDouble.D2 data2Double = null;
            ArrayInt.D2 data2Int = null;
            ArrayLong.D2 data2Long = null;
            if (data.getRank() == 3) {
                if (data instanceof ArrayFloat.D3) {
                    data3Float = (ArrayFloat.D3)data;
                } else if (data instanceof ArrayInt.D3) {
                    data3Int = (ArrayInt.D3)data;
                } else if (data instanceof ArrayDouble.D3) {
                    data3Double = (ArrayDouble.D3)data;
                } else if (data instanceof ArrayDouble.D3) {
                    data3Double = (ArrayDouble.D3)data;
                } else if (data instanceof ArrayLong.D3) {
                    data3Long = (ArrayLong.D3)data;
                } else {
                    if (!(data instanceof ArrayByte.D3)) throw new Exception("Layer data format not supported");
                    data3Double = VectorOperations.arrayByte3DArrayDouble((ArrayByte)data);
                }
            } else if (data instanceof ArrayFloat.D2) {
                data2Float = (ArrayFloat.D2)data;
            } else if (data instanceof ArrayInt.D2) {
                data2Int = (ArrayInt.D2)data;
            } else if (data instanceof ArrayDouble.D2) {
                data2Double = (ArrayDouble.D2)data;
            } else if (data instanceof ArrayLong.D2) {
                data2Long = (ArrayLong.D2)data;
            } else {
                if (!(data instanceof ArrayByte.D2)) throw new Exception("Layer data format not supported");
                data2Double = VectorOperations.arrayByte2DArrayDouble((ArrayByte)data);
            }
            double xmin = xAxis.getMinValue();
            double xmax = xAxis.getMaxValue();
            double ymax = yAxis.getMaxValue();
            double ymin = yAxis.getMinValue();
            int xmaxidx = (int)Math.round((xmax - xmin) / resolutionX);
            int ymaxidx = (int)Math.round((ymax - ymin) / resolutionY);
            boolean is0_360 = false;
            AnalysisLogger.getLogger().debug((Object)("X dimension: " + xD + " Xmin:" + xmin + " Xmax:" + xmax + " Xmaxidx:" + xmaxidx + " XRes: " + resolutionX));
            AnalysisLogger.getLogger().debug((Object)("Y dimension: " + yD + " Ymin:" + ymin + " Ymax:" + ymax + " Ymaxidx:" + ymaxidx + " YRes: " + resolutionY));
            if (xmin >= 0.0) {
                xmax = 180.0;
                xmin = -180.0;
                is0_360 = true;
            }
            AnalysisLogger.getLogger().debug((Object)("Assigning " + tsize + " grid elements to the NetCDF values"));
            for (int i = 0; i < tsize; ++i) {
                int zint = 0;
                int xint = 0;
                int yint = 0;
                Tuple<Double> triplet = triplets.get(i);
                double x = (Double)triplet.getElements().get(0);
                double y = (Double)triplet.getElements().get(1);
                if (x == 180.0) {
                    x = -180.0;
                }
                if (y == 90.0) {
                    y = -90.0;
                }
                double z = 0.0;
                if (triplet.getElements().size() > 1) {
                    z = (Double)triplet.getElements().get(2);
                }
                if (resolutionZ > 0.0 && zAxis.getMinValue() <= z && zAxis.getMaxValue() >= z) {
                    zint = Math.abs((int)Math.round((z - zAxis.getMinValue()) / resolutionZ));
                }
                if (y < ymin) {
                    y = ymin;
                }
                if (x < xmin) {
                    x = xmin;
                }
                if (y > ymax) {
                    y = ymax;
                }
                if (x > xmax) {
                    x = xmax;
                }
                try {
                    int[] idxbb = gcs.findXYindexFromLatLon(75.0, 10.0, null);
                    int[] idxo = gcs.findXYindexFromLatLon(0.0, 0.0, null);
                    LatLonPoint inverseOrigin = gcs.getLatLon(idxo[0], idxo[1]);
                    x -= inverseOrigin.getLongitude();
                    y -= inverseOrigin.getLatitude();
                    if (i == 0) {
                        AnalysisLogger.getLogger().debug((Object)("bb: " + idxbb[0] + "," + idxbb[1] + " origin: " + idxo[0] + "," + idxo[1] + " middle " + xD / 2 + "," + yD / 2 + " shift " + (idxo[0] - xD / 2) + " inverse shift on origin " + inverseOrigin));
                    }
                }
                catch (Exception e) {
                    AnalysisLogger.getLogger().debug((Object)("Error getting x,y corrections " + e.getLocalizedMessage()));
                    e.printStackTrace();
                }
                int[] idx = gcs.findXYindexFromLatLon(y, x, null);
                xint = idx[0];
                yint = idx[1];
                if (yint < 0) {
                    yint = 0;
                }
                if (xint < 0) {
                    xint = 0;
                }
                if (xint > xD - 1) {
                    xint = xD - 1;
                }
                if (yint > yD - 1) {
                    yint = yD - 1;
                }
                Double val = Double.NaN;
                if (zint > zD - 1) {
                    zint = zD - 1;
                }
                if (data3Float != null) {
                    val = data3Float.get(zint, yint, xint);
                } else if (data3Int != null) {
                    val = data3Int.get(zint, yint, xint);
                } else if (data3Double != null) {
                    val = data3Double.get(zint, yint, xint);
                } else if (data3Long != null) {
                    val = data3Long.get(zint, yint, xint);
                } else if (data2Float != null) {
                    val = data2Float.get(yint, xint);
                } else if (data2Int != null) {
                    val = data2Int.get(yint, xint);
                } else if (data2Double != null) {
                    val = data2Double.get(yint, xint);
                } else if (data2Long != null) {
                    val = data2Long.get(yint, xint);
                }
                values.add(val);
            }
        }
        return values;
    }

    private boolean detIsPositive(double x0, double y0, double x1, double y1, double x2, double y2) {
        double det = x1 * y2 - y1 * x2 - x0 * y2 + y0 * x2 + x0 * y1 - y0 * x1;
        if (det == 0.0) {
            System.out.printf("determinate = 0%n", new Object[0]);
        }
        return det > 0.0;
    }

    public static GridDatatype getGrid(String layer, String netcdffile) throws Exception {
        AnalysisLogger.getLogger().debug((Object)("Opening File : " + netcdffile));
        AnalysisLogger.getLogger().debug((Object)("Searching for layer: " + layer));
        GridDataset gds = GridDataset.open((String)netcdffile);
        List gridTypes = gds.getGrids();
        StringBuffer sb = new StringBuffer();
        for (GridDatatype gdt : gridTypes) {
            AnalysisLogger.getLogger().debug((Object)("Inside File - layer name: " + gdt.getName()));
            sb.append(gdt.getName() + " ");
            if (!layer.equals(gdt.getName())) continue;
            AnalysisLogger.getLogger().debug((Object)("Found layer " + layer + " inside file"));
            GridDatatype grid = gds.findGridDatatype(gdt.getName());
            return grid;
        }
        throw new Exception("No layer with  name " + layer + " is available in the NetCDF file. Possible values are " + sb.toString());
    }

    public static LinkedHashMap<String, Double> manageGridDataset(String layer, String filename, double x, double y, double z) throws Exception {
        LinkedHashMap<String, Double> valuesMap = new LinkedHashMap<String, Double>();
        GridDataset gds = GridDataset.open((String)filename);
        List gridTypes = gds.getGrids();
        for (GridDatatype gdt : gridTypes) {
            AnalysisLogger.getLogger().debug((Object)("Inside File - layer name: " + gdt.getName()));
            if (!layer.equalsIgnoreCase(gdt.getName())) continue;
            AnalysisLogger.getLogger().debug((Object)("Found layer " + layer + " inside file"));
            GridDatatype grid = gds.findGridDatatype(gdt.getName());
            GridCoordSystem gcs = grid.getCoordinateSystem();
            long timeSteps = 0L;
            Date[] dates = null;
            if (gcs.hasTimeAxis1D()) {
                CoordinateAxis1DTime tAxis1D = gcs.getTimeAxis1D();
                dates = tAxis1D.getTimeDates();
                timeSteps = dates.length;
            } else if (gcs.hasTimeAxis()) {
                CoordinateAxis tAxis = gcs.getTimeAxis();
                timeSteps = tAxis.getSize();
            }
            CoordinateAxis1D zAxis = gdt.getCoordinateSystem().getVerticalAxis();
            double resolutionZ = Math.abs((zAxis.getMaxValue() - zAxis.getMinValue()) / (double)zAxis.getShape()[0]);
            int zint = 0;
            if (resolutionZ > 0.0 && zAxis.getMinValue() <= z && zAxis.getMaxValue() >= z) {
                zint = Math.abs((int)Math.round((z - zAxis.getMinValue()) / resolutionZ));
            }
            AnalysisLogger.getLogger().debug((Object)("Z index to take: " + zint));
            int[] xy = gcs.findXYindexFromLatLon(x, y, null);
            int j = 0;
            while ((long)j < timeSteps) {
                try {
                    Array data = grid.readDataSlice(j, zint, xy[1], xy[0]);
                    Double val = NetCDFDataExplorer.takeFirstDouble(data);
                    if (!val.isNaN()) {
                        String date = "" + j;
                        if (dates != null) {
                            date = dates[j].toString();
                        }
                        valuesMap.put(timePrefix + date, Double.parseDouble("" + val));
                    }
                }
                catch (Exception e) {
                    AnalysisLogger.getLogger().debug((Object)("Error in getting grid values in (" + x + "," + y + "," + z + "= with zint: " + zint + " resolution: " + resolutionZ + " and shape: " + zAxis.getShape()[0]));
                }
                ++j;
            }
            break block2;
        }
        return valuesMap;
    }

    public static Double takeFirstDouble(Array data) {
        long datal = data.getSize();
        Double val = Double.NaN;
        try {
            int k = 0;
            while ((long)k < datal) {
                Double testVal = data.getDouble(k);
                if (!testVal.isNaN()) {
                    val = testVal;
                    break;
                }
                ++k;
            }
        }
        catch (Exception ee) {
            AnalysisLogger.getLogger().debug((Object)("NetCDFDataExplorer-> WARNING: Error in getting value: " + ee.getLocalizedMessage()));
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashMap<String, String> managePointsDataset(String layer, String filename, double x, double y) throws Exception {
        LinkedHashMap<String, String> valuesMap = new LinkedHashMap<String, String>();
        float tolerance = 0.25f;
        Formatter errlog = new Formatter();
        FeatureDataset fdataset = FeatureDatasetFactoryManager.open((FeatureType)FeatureType.POINT, (String)filename, null, (Formatter)errlog);
        PointDatasetImpl ds = (PointDatasetImpl)fdataset;
        List lfc = ds.getPointFeatureCollectionList();
        Iterator iterator = lfc.iterator();
        if (iterator.hasNext()) {
            LatLonRect rect;
            PointFeatureCollection coll;
            FeatureCollection fc = (FeatureCollection)iterator.next();
            StandardPointCollectionImpl spf = (StandardPointCollectionImpl)fc;
            PointFeatureIterator iter = null;
            while (y - (double)tolerance > -90.0 && x - (double)tolerance > -180.0 && y + (double)tolerance < 90.0 && x + (double)tolerance < 180.0 && (iter = (coll = spf.subset(rect = new LatLonRect((LatLonPoint)new LatLonPointImpl(y - (double)tolerance, x - (double)tolerance), (LatLonPoint)new LatLonPointImpl(y + (double)tolerance, x + (double)tolerance)), null)).getPointFeatureIterator(100000)).getCount() == 0) {
                iter.finish();
                AnalysisLogger.getLogger().debug((Object)("NetCDFDataExplorer-> -> tolerance = " + (tolerance += 0.25f)));
            }
            if (iter != null) {
                try {
                    while (iter.hasNext()) {
                        PointFeature pf = iter.next();
                        AnalysisLogger.getLogger().debug((Object)("NetCDFDataExplorer-> -> EarthLoc: " + pf.getLocation()));
                        AnalysisLogger.getLogger().debug((Object)("NetCDFDataExplorer-> -> EarthTime: " + pf.getObservationTime()));
                        StructureData sd = pf.getData();
                        List mems = sd.getMembers();
                        for (StructureMembers.Member m : mems) {
                            String unit = m.getUnitsString();
                            if (unit == null || unit.length() <= 0) continue;
                            AnalysisLogger.getLogger().debug((Object)("NetCDFDataExplorer-> -> description: " + m.getDescription()));
                            AnalysisLogger.getLogger().debug((Object)("NetCDFDataExplorer-> -> data param: " + m.getDataParam()));
                            AnalysisLogger.getLogger().debug((Object)("NetCDFDataExplorer-> -> name: " + m.getName()));
                            AnalysisLogger.getLogger().debug((Object)("NetCDFDataExplorer-> -> unit: " + m.getUnitsString()));
                            AnalysisLogger.getLogger().debug((Object)("NetCDFDataExplorer-> -> type: " + m.getDataType()));
                            Array arr = sd.getArray(m.getName());
                            AnalysisLogger.getLogger().debug((Object)("NetCDFDataExplorer-> -> is Time: " + m.getDataType()));
                            Double val = NetCDFDataExplorer.takeFirstDouble(arr);
                            AnalysisLogger.getLogger().debug((Object)("NetCDFDataExplorer-> -> extracted value: " + val));
                        }
                        AnalysisLogger.getLogger().debug((Object)"NetCDFDataExplorer-> -> EarthTime: ");
                    }
                }
                finally {
                    iter.finish();
                }
            }
        }
        return valuesMap;
    }

    public static boolean isGridDataset(String filename) {
        try {
            AnalysisLogger.getLogger().debug((Object)("Analyzing file " + filename));
            Formatter errlog = new Formatter();
            FeatureDataset fdataset = FeatureDatasetFactoryManager.open((FeatureType)FeatureType.GRID, (String)filename, null, (Formatter)errlog);
            if (fdataset == null) {
                AnalysisLogger.getLogger().debug((Object)"NetCDFDataExplorer-> NOT GRID");
                return false;
            }
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isPointDataset(String filename) {
        try {
            Formatter errlog = new Formatter();
            FeatureDataset fdataset = FeatureDatasetFactoryManager.open((FeatureType)FeatureType.POINT, (String)filename, null, (Formatter)errlog);
            if (fdataset == null) {
                AnalysisLogger.getLogger().debug((Object)"NetCDFDataExplorer-> NOT POINT");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDataset(String filename) throws Exception {
        boolean isdataset = false;
        try {
            Formatter errlog = new Formatter();
            FeatureType[] fts = FeatureType.values();
            for (int i = 0; i < fts.length; ++i) {
                FeatureDataset fdataset = FeatureDatasetFactoryManager.open((FeatureType)fts[i], (String)filename, null, (Formatter)errlog);
                if (fdataset == null) continue;
                AnalysisLogger.getLogger().debug((Object)("NetCDFDataExplorer->  " + fts[i] + " OK!"));
                isdataset = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isdataset;
    }

    public static double adjX(double x) {
        return x;
    }

    public static double adjY(double y) {
        return y;
    }

    public static double getMinX(GridCoordSystem gcs) {
        CoordinateAxis xAxis = gcs.getXHorizAxis();
        return NetCDFDataExplorer.adjX(xAxis.getMinValue());
    }

    public static double getMaxX(GridCoordSystem gcs) {
        CoordinateAxis xAxis = gcs.getXHorizAxis();
        return NetCDFDataExplorer.adjX(xAxis.getMaxValue());
    }

    public static double getMinY(GridCoordSystem gcs) {
        CoordinateAxis yAxis = gcs.getYHorizAxis();
        return NetCDFDataExplorer.adjY(yAxis.getMinValue());
    }

    public static double getMaxY(GridCoordSystem gcs) {
        CoordinateAxis yAxis = gcs.getYHorizAxis();
        return NetCDFDataExplorer.adjY(yAxis.getMaxValue());
    }

    public static double getResolution(String layer, String file) throws Exception {
        GridDatatype gdt = NetCDFDataExplorer.getGrid(layer, file);
        double minY = NetCDFDataExplorer.getMinY(gdt.getCoordinateSystem());
        double maxY = NetCDFDataExplorer.getMaxY(gdt.getCoordinateSystem());
        GridDatatype gdtsub = gdt.makeSubset(new Range(0, 0), null, null, 1, 1, 1);
        Array data = gdtsub.readVolumeData(0);
        int[] shapeD = data.getShape();
        int yD = 0;
        yD = shapeD.length > 2 ? shapeD[1] : shapeD[0];
        double resolutionY = Math.abs((maxY - minY) / (double)yD);
        resolutionY = MathFunctions.roundDecimal((double)resolutionY, (int)4);
        return resolutionY;
    }
}

