/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.connectors.asc;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.NumberFormat;
import org.gcube.dataanalysis.geo.connectors.asc.AscRaster;

public class AscRasterWriter {
    NumberFormat cellFormat = null;
    String nodataString = "-9999";

    public void writeRaster(String filename, AscRaster r) throws IOException {
        File f = new File(filename);
        if (f.exists()) {
            f.delete();
        }
        if (!f.createNewFile()) {
            throw new RuntimeException("Could not create file for some reason!");
        }
        PrintStream o = new PrintStream(f);
        o.println("ncols " + r.getCols());
        o.println("nrows " + r.getRows());
        o.println("xllcorner " + r.getXll());
        o.println("yllcorner " + r.getYll());
        if (r.getCellsize() > 0.0) {
            o.println("cellsize " + r.getCellsize());
        } else {
            o.println("dx " + r.getdx());
            o.println("dy " + r.getdy());
        }
        o.println("NODATA_value " + r.getNDATA());
        double[][] values = r.getData();
        for (int k = 0; k < values.length; ++k) {
            double[] row = values[k];
            StringBuffer b = new StringBuffer();
            for (int i = 0; i < row.length; ++i) {
                if (Double.isNaN(row[i])) {
                    b.append(r.getNDATA());
                } else if (this.cellFormat != null) {
                    b.append(this.cellFormat.format(row[i]));
                } else {
                    b.append(row[i]);
                }
                if (i >= row.length - 1) continue;
                b.append(" ");
            }
            o.println(b);
        }
        o.close();
    }

    public void writeRasterInvertYAxis(String filename, AscRaster r) throws IOException {
        File f = new File(filename);
        if (f.exists()) {
            f.delete();
        }
        if (!f.createNewFile()) {
            throw new RuntimeException("Could not create file for some reason!");
        }
        PrintStream o = new PrintStream(f);
        o.println("ncols " + r.getCols());
        o.println("nrows " + r.getRows());
        o.println("xllcorner " + r.getXll());
        o.println("yllcorner " + r.getYll());
        if (r.getCellsize() > 0.0) {
            o.println("cellsize " + r.getCellsize());
        } else {
            o.println("dx " + r.getdx());
            o.println("dy " + r.getdy());
        }
        o.println("NODATA_value " + r.getNDATA());
        double[][] values = r.getData();
        for (int k = values.length - 1; k >= 0; --k) {
            double[] row = values[k];
            StringBuffer b = new StringBuffer();
            for (int i = 0; i < row.length; ++i) {
                if (Double.isNaN(row[i])) {
                    b.append(r.getNDATA());
                } else if (this.cellFormat != null) {
                    b.append(this.cellFormat.format(row[i]));
                } else {
                    b.append(row[i]);
                }
                if (i >= row.length - 1) continue;
                b.append(" ");
            }
            o.println(b);
        }
        o.close();
    }

    public void writeRaster(String filename, double[][] data, double xll, double yll, double size, String ndata) throws IOException {
        this.writeRaster(filename, AscRaster.getTempRaster(data, xll, yll, size, ndata));
    }

    public void writeRasterInvertYAxis(String filename, double[][] data, double xll, double yll, double size, String ndata) throws IOException {
        this.writeRasterInvertYAxis(filename, AscRaster.getTempRaster(data, xll, yll, size, ndata));
    }

    public void setCellFormat(NumberFormat format) {
        this.cellFormat = format;
    }
}

