/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.utils;

import java.util.ArrayList;
import java.util.List;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;

public final class CrsHelper {
    public static final String PLATE_CARREE_CRS_CODE = "CRS:84";
    public static final List<String> SUPPORTED_CRS_CODES = new ArrayList<String>();
    private CoordinateReferenceSystem crs;
    private MathTransform crsToLatLon;
    private MathTransform latLonToCrs;
    private boolean isLatLon;

    private CrsHelper() {
    }

    public static CrsHelper fromCrsCode(String crsCode) throws Exception {
        CrsHelper crsHelper = new CrsHelper();
        try {
            crsHelper.crs = CRS.decode((String)crsCode, (boolean)true);
            crsHelper.crsToLatLon = CRS.findMathTransform((CoordinateReferenceSystem)crsHelper.crs, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (boolean)true);
            crsHelper.latLonToCrs = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)crsHelper.crs, (boolean)true);
            crsHelper.isLatLon = crsHelper.crsToLatLon.isIdentity();
            return crsHelper;
        }
        catch (Exception e) {
            throw new Exception("Error creating CrsHelper from code " + crsCode);
        }
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public boolean isPointValidForCrs(ProjectionPoint point) {
        return this.isPointValidForCrs(point.getX(), point.getY());
    }

    public boolean isPointValidForCrs(double x, double y) {
        CoordinateSystemAxis xAxis = this.crs.getCoordinateSystem().getAxis(0);
        CoordinateSystemAxis yAxis = this.crs.getCoordinateSystem().getAxis(1);
        return x >= xAxis.getMinimumValue() && x <= xAxis.getMaximumValue() && y >= yAxis.getMinimumValue() && y <= yAxis.getMaximumValue();
    }

    public LatLonPoint crsToLatLon(double x, double y) throws TransformException {
        if (this.isLatLon) {
            return new LatLonPointImpl(y, x);
        }
        double[] point = new double[]{x, y};
        this.crsToLatLon.transform(point, 0, point, 0, 1);
        return new LatLonPointImpl(point[1], point[0]);
    }

    public LatLonPoint crsToLatLon(ProjectionPoint point) throws TransformException {
        return this.crsToLatLon(point.getX(), point.getY());
    }

    public ProjectionPoint latLonToCrs(LatLonPoint latLonPoint) throws TransformException {
        return this.latLonToCrs(latLonPoint.getLongitude(), latLonPoint.getLatitude());
    }

    public ProjectionPoint latLonToCrs(double longitude, double latitude) throws TransformException {
        if (this.isLatLon) {
            return new ProjectionPointImpl(longitude, latitude);
        }
        double[] point = new double[]{longitude, latitude};
        this.latLonToCrs.transform(point, 0, point, 0, 1);
        return new ProjectionPointImpl(point[0], point[1]);
    }

    public boolean isLatLon() {
        return this.isLatLon;
    }

    public static void main(String[] args) throws Exception {
        CrsHelper helper = CrsHelper.fromCrsCode(PLATE_CARREE_CRS_CODE);
        LatLonPoint point = helper.crsToLatLon(190.0, 10.0);
        double x = point.getLongitude();
        double y = point.getLatitude();
        System.out.println(point + " (" + x + "," + y + ")");
    }

    static {
        for (Object codeObj : CRS.getSupportedCodes((String)"urn:ogc:def")) {
            SUPPORTED_CRS_CODES.add((String)codeObj);
        }
        System.out.println("Supported Codes:" + SUPPORTED_CRS_CODES);
    }
}

